/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.model;

public class CallbackObject
implements Comparable<CallbackObject> {
    private String fromUser;
    private String toUser;
    private String scheduledAt;
    private String status;
    private String mediaType;
    private long epoch;

    public CallbackObject() {
    }

    public CallbackObject(String fromUser, String toUser, String mediaType, long epoch, String time) {
        this.fromUser = fromUser;
        this.toUser = toUser;
        this.mediaType = mediaType;
        this.epoch = epoch;
        this.scheduledAt = time;
        this.status = "pending";
    }

    @Override
    public int compareTo(CallbackObject other) {
        int cmp = Long.compare(this.epoch, other.epoch);
        if (cmp == 0 && (cmp = this.fromUser.compareTo(other.fromUser)) == 0) {
            cmp = this.toUser.compareTo(other.toUser);
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CallbackObject)) {
            return false;
        }
        CallbackObject that = (CallbackObject)obj;
        return this.fromUser.equals(that.fromUser) && this.toUser.equals(that.toUser);
    }

    public int hashCode() {
        return (this.fromUser + ":" + this.toUser).hashCode();
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getScheduledAt() {
        return this.scheduledAt;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public void setScheduledAt(String scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }
}

