/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.messaging;

import com.coraltele.db.telephony.main.entity.SipSubscription;
import com.coraltele.db.telephony.main.repository.SipSubscriptionRepository;
import com.coraltele.helper.Constants;
import com.coraltele.model.RedisMessageWrapper;
import com.coraltele.service.FeatureIMSService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.transaction.annotation.Transactional;

public class SubscriptionMessageListener
implements MessageListener {
    private static final Logger logger = LogManager.getLogger(SubscriptionMessageListener.class);
    private final SipSubscriptionRepository sipSubscriptionRepository;
    private ObjectMapper objectMapper = null;
    private transient Lock userLock = new ReentrantLock();

    public SubscriptionMessageListener(SipSubscriptionRepository sipSubscriptionRepository) {
        this.sipSubscriptionRepository = sipSubscriptionRepository;
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void onMessage(Message message, byte[] pattern) {
        if (message == null || message.getBody() == null) {
            logger.warn("Received a null or empty Redis message body. Skipping processing.");
            return;
        }
        String channel = new String(message.getChannel());
        try {
            byte[] messageBodyBytes = message.getBody();
            RedisMessageWrapper wrapper = (RedisMessageWrapper)this.objectMapper.readValue(messageBodyBytes, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (wrapper == null) {
                logger.warn("Received null wrapper from Redis message on channel {}. Skipping.", (Object)channel);
                return;
            }
            Object payload = wrapper.getPayload();
            String hostname = wrapper.getHostname();
            if (hostname != null && hostname.equalsIgnoreCase(Constants.HOSTNAME)) {
                logger.info("Redis Message hostname {} matches with local hostname {}. Skipping processing.", (Object)hostname, (Object)Constants.HOSTNAME);
                return;
            }
            FeatureIMSService.SubscribeObject subscribeObject = payload != null ? (FeatureIMSService.SubscribeObject)this.objectMapper.convertValue(payload, FeatureIMSService.SubscribeObject.class) : null;
            logger.info("Received Subscription message on channel: {} -> {} - {}", (Object)channel, subscribeObject != null ? subscribeObject.getSipUser() + ":" + subscribeObject.getSubToUser() : null, (Object)(subscribeObject != null ? subscribeObject.getCallId() : null));
            if (!this.isDatabaseConnected()) {
                logger.info("Database connection is down. Skipping save operation for SubscriptionHASync.");
                return;
            }
            if (subscribeObject == null) {
                logger.warn("SubscribeObject is null after conversion. Skipping processing.");
                return;
            }
            this.saveAndUpdateEntry(subscribeObject);
        }
        catch (Exception e) {
            logger.error("Error processing Redis message in SubscriptionMessageListener", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(transactionManager="switchTransactionManager")
    private void saveAndUpdateEntry(FeatureIMSService.SubscribeObject subscribeObject) {
        block15: {
            try {
                if (this.userLock.tryLock(5L, TimeUnit.SECONDS)) {
                    try {
                        if (subscribeObject.getExpireHeaderInSeconds() <= 0L) {
                            if (this.sipSubscriptionRepository.existsByCallId(subscribeObject.getCallId())) {
                                this.sipSubscriptionRepository.deleteByCallId(subscribeObject.getCallId());
                                logger.info("Removed subscription for callId={} onMessage SubscriptionMessageListener", (Object)subscribeObject.getCallId());
                            } else {
                                logger.info("No callId is present for Unsubscription for callId={} onMessage SubscriptionMessageListener", (Object)subscribeObject.getCallId());
                            }
                        } else {
                            SipSubscription sipSubscription = this.makeSipSubscriptionObject(subscribeObject);
                            if (this.sipSubscriptionRepository.existsByCallId(subscribeObject.getCallId())) {
                                this.sipSubscriptionRepository.deleteByCallId(subscribeObject.getCallId());
                            } else {
                                int deletedRows = this.sipSubscriptionRepository.deleteBySipUserAndContact(subscribeObject.getSipUser(), subscribeObject.getSubToUser(), subscribeObject.getContactWithPath());
                                if (deletedRows > 0) {
                                    logger.info("Deleting existing subscription for callId={} onMessage SubscriptionMessageListener", (Object)subscribeObject.getCallId());
                                }
                            }
                            this.sipSubscriptionRepository.save((Object)sipSubscription);
                            logger.info("Inserted Subscription for ==> {} -> {} for callId {}", (Object)sipSubscription.getSipUser(), (Object)sipSubscription.getSubToUser(), (Object)sipSubscription.getCallId());
                        }
                        break block15;
                    }
                    catch (Exception e) {
                        logger.error("Error while saving in database with lock for Entity :{} , callid :{}, {}", (Object)subscribeObject.getSipUser(), (Object)subscribeObject.getCallId(), (Object)e.getMessage(), (Object)e);
                        break block15;
                    }
                    finally {
                        this.userLock.unlock();
                    }
                }
                logger.info("Lock not acquired by user: {} within 5 seconds", (Object)subscribeObject.getSipUser());
            }
            catch (Exception e) {
                logger.error("Error while saving in database for Subscription Entity: {}, callId: {}, {}", (Object)subscribeObject.getSipUser(), (Object)subscribeObject.getCallId(), (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private SipSubscription makeSipSubscriptionObject(FeatureIMSService.SubscribeObject subscribeObject) {
        SipSubscription sipSubscription = new SipSubscription();
        sipSubscription.setProto("sip");
        sipSubscription.setSipUser(subscribeObject.getSipUser());
        sipSubscription.setSipHost(subscribeObject.getDomainName());
        sipSubscription.setSubToUser(subscribeObject.getSubToUser());
        sipSubscription.setSubToHost(subscribeObject.getSipServerDomainName());
        sipSubscription.setPresenceHosts(subscribeObject.getSipServerDomainName());
        sipSubscription.setEvent(subscribeObject.getEvent());
        sipSubscription.setContact(subscribeObject.getContactWithPath());
        sipSubscription.setCallId(subscribeObject.getCallId());
        sipSubscription.setFullFrom(subscribeObject.getFullFrom());
        sipSubscription.setFullVia(subscribeObject.getFullVia());
        sipSubscription.setExpires(subscribeObject.getExpireAtInSecondsEpoch());
        sipSubscription.setUserAgent(Constants.USER_AGENT);
        sipSubscription.setAccept(subscribeObject.getAccept());
        sipSubscription.setProfileName(subscribeObject.getSipServerProfileName());
        sipSubscription.setHostname("sipserver");
        sipSubscription.setNetworkPort(subscribeObject.getNetworkPort());
        sipSubscription.setNetworkIp(subscribeObject.getNetworkIp());
        sipSubscription.setFullTo(subscribeObject.getFullTo());
        return sipSubscription;
    }

    private boolean isDatabaseConnected() {
        try {
            this.sipSubscriptionRepository.count();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

