/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.messaging;

import com.coraltele.db.telephony.main.entity.SipRegistrations;
import com.coraltele.db.telephony.main.repository.SipRegistrationRepository;
import com.coraltele.helper.Constants;
import com.coraltele.model.RedisMessageWrapper;
import com.coraltele.service.FeatureIMSService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.transaction.annotation.Transactional;

public class RegistrationMessageListener
implements MessageListener {
    private static final Logger logger = LogManager.getLogger(RegistrationMessageListener.class);
    private final SipRegistrationRepository sipRegistrationRepository;
    private final FeatureIMSService featureIMSService;
    private ObjectMapper objectMapper = null;
    private transient Lock userLock = new ReentrantLock();

    public RegistrationMessageListener(SipRegistrationRepository sipRegistrationRepository, FeatureIMSService featureIMSService) {
        this.sipRegistrationRepository = sipRegistrationRepository;
        this.featureIMSService = featureIMSService;
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void onMessage(Message message, byte[] pattern) {
        if (message == null || message.getBody() == null) {
            logger.warn("Received a null or empty Redis message body. Skipping processing.");
            return;
        }
        String channel = new String(message.getChannel());
        try {
            byte[] messageBodyBytes = message.getBody();
            RedisMessageWrapper wrapper = (RedisMessageWrapper)this.objectMapper.readValue(messageBodyBytes, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (wrapper == null) {
                logger.warn("Received null wrapper from Redis message on channel {}. Skipping.", (Object)channel);
                return;
            }
            Object payload = wrapper.getPayload();
            String hostname = wrapper.getHostname();
            if (hostname != null && hostname.equalsIgnoreCase(Constants.HOSTNAME)) {
                logger.info("Redis Message hostname {} matches with local hostname {}. Skipping processing.", (Object)hostname, (Object)Constants.HOSTNAME);
                return;
            }
            FeatureIMSService.RegisterObject registerObject = payload != null ? (FeatureIMSService.RegisterObject)this.objectMapper.convertValue(payload, FeatureIMSService.RegisterObject.class) : null;
            logger.info("Received Registration message on channel: {} ->  {}", (Object)channel, registerObject != null ? registerObject.getSipUser() + ":" + registerObject.getCallId() : null);
            if (!this.isDatabaseConnected()) {
                logger.warn("Database connection is down. Skipping save operation for RegistrationHASync.");
                return;
            }
            if (registerObject == null) {
                logger.warn("RegisterObject is null after conversion. Skipping processing.");
                return;
            }
            this.saveAndUpdateEntry(registerObject);
        }
        catch (Exception e) {
            logger.error("Error processing Redis message RegistrationMessageListener", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(transactionManager="switchTransactionManager")
    private void saveAndUpdateEntry(FeatureIMSService.RegisterObject registerObject) {
        block15: {
            try {
                if (this.userLock.tryLock(5L, TimeUnit.SECONDS)) {
                    try {
                        String callId = registerObject.getCallId().trim();
                        if (registerObject.getExpireHeaderInSeconds() == 0L) {
                            this.featureIMSService.removeUser_from_UserRegisterMap(registerObject);
                            if (this.sipRegistrationRepository.existsByCallId(callId)) {
                                this.sipRegistrationRepository.deleteByCallId(callId);
                                logger.info("UnRegister for callId={} onMessage RegistrationMessageListener", (Object)callId);
                            } else {
                                logger.info("No callId is present for UnRegister for callId={} onMessage RegistrationMessageListener", (Object)callId);
                            }
                        } else {
                            this.featureIMSService.addUser_in_UserRegisterMap(registerObject);
                            SipRegistrations sipRegistrations = this.makeSipRegistrationObject(registerObject);
                            if (this.sipRegistrationRepository.existsByCallId(callId)) {
                                int rows = this.sipRegistrationRepository.deleteByCallId(callId);
                                logger.info("Deleted {} existing registration for sipUser={} before inserting a new one on callID:{}", (Object)rows, (Object)registerObject.getSipUser(), (Object)callId);
                            } else {
                                int deletedRows = this.sipRegistrationRepository.deleteBySipUserAndContact(registerObject.getSipUser(), registerObject.getContactWithPath());
                                logger.info("No existing registration is present for callId={} onMessage RegistrationMessageListener", (Object)callId);
                                if (deletedRows > 0) {
                                    logger.info("Deleted existing registration for sipUser={} before inserting a new one on same ContactWithPath: {}", (Object)registerObject.getSipUser(), (Object)registerObject.getContactWithPath());
                                }
                            }
                            this.sipRegistrationRepository.save((Object)sipRegistrations);
                            logger.info("Inserted Registration for user:callid {} : {} in database", (Object)sipRegistrations.getSipUser(), (Object)sipRegistrations.getCallId());
                        }
                        break block15;
                    }
                    catch (Exception e) {
                        logger.error("Error while saving in database with lock for Entity :{} , callid :{}, {}", (Object)registerObject.getSipUser(), (Object)registerObject.getCallId(), (Object)e.getMessage(), (Object)e);
                        break block15;
                    }
                    finally {
                        this.userLock.unlock();
                    }
                }
                logger.info("Lock not acquired by user: {} within 5 seconds", (Object)registerObject.getSipUser());
            }
            catch (Exception e) {
                logger.error("Error while saving in database for Entity :{} , callid :{}, {}", (Object)registerObject.getSipUser(), (Object)registerObject.getCallId(), (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private SipRegistrations makeSipRegistrationObject(FeatureIMSService.RegisterObject registerObject) {
        SipRegistrations sipRegistrations = new SipRegistrations();
        sipRegistrations.setCallId(registerObject.getCallId());
        sipRegistrations.setSipUser(registerObject.getSipUser());
        sipRegistrations.setSipHost(registerObject.getSipServerDomainName());
        sipRegistrations.setPresenceHosts(registerObject.getSipServerDomainName());
        sipRegistrations.setContact(registerObject.getContactWithPath());
        sipRegistrations.setStatus("Registered(" + registerObject.getNetworkTransport() + "-NAT)");
        sipRegistrations.setPingStatus("Reachable");
        sipRegistrations.setPingCount(Integer.valueOf(0));
        sipRegistrations.setForcePing(Integer.valueOf(0));
        sipRegistrations.setRpid("unknown");
        sipRegistrations.setExpires(registerObject.getExpireAtInSecondsEpoch());
        sipRegistrations.setPingExpires(Integer.valueOf(registerObject.getRegisterTimeInSecondsEpoch().intValue()));
        sipRegistrations.setUserAgent(Constants.USER_AGENT);
        sipRegistrations.setServerUser(registerObject.getSipUser());
        sipRegistrations.setServerHost(Constants.LISTEN_IP_ADDRESS);
        sipRegistrations.setProfileName(registerObject.getSipServerProfileName());
        sipRegistrations.setHostname("sipserver");
        sipRegistrations.setNetworkIp(registerObject.getNetworkIp());
        sipRegistrations.setNetworkPort(registerObject.getNetworkPort());
        sipRegistrations.setSipUsername(registerObject.getSipUser());
        sipRegistrations.setSipRealm(registerObject.getDomainName());
        sipRegistrations.setMwiUser(registerObject.getSipUser());
        sipRegistrations.setMwiHost(registerObject.getSipServerDomainName());
        sipRegistrations.setOrigServerHost(Constants.LISTEN_IP_ADDRESS);
        sipRegistrations.setOrigHostname("sipserver");
        sipRegistrations.setSubHost(registerObject.getSipServerDomainName());
        return sipRegistrations;
    }

    private boolean isDatabaseConnected() {
        try {
            this.sipRegistrationRepository.count();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

