/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.messaging;

import com.coraltele.db.telephony.main.entity.Recovery;
import com.coraltele.db.telephony.main.repository.RecoveryRepository;
import com.coraltele.helper.Constants;
import com.coraltele.model.RedisMessageWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;

public class RecoveryMessageListener
implements MessageListener {
    private static final Logger logger = LogManager.getLogger(RecoveryMessageListener.class);
    private final RecoveryRepository recoveryRepository;
    @Value(value="${redis.recoveryAddHASyncChannel}")
    private String recoveryAddHASyncChannel;
    @Value(value="${redis.recoveryRemoveHASyncChannel}")
    private String recoveryRemoveHASyncChannel;
    private ObjectMapper objectMapper = null;

    public RecoveryMessageListener(RecoveryRepository recoveryRepository) {
        this.recoveryRepository = recoveryRepository;
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void onMessage(Message message, @Nullable byte[] pattern) {
        if (message == null || message.getBody() == null) {
            logger.warn("Received a null or empty Redis message body. Skipping processing.");
            return;
        }
        String channel = new String(message.getChannel());
        String patternStr = pattern != null ? new String(pattern) : "N/A";
        try {
            byte[] messageBodyBytes = message.getBody();
            RedisMessageWrapper wrapper = (RedisMessageWrapper)this.objectMapper.readValue(messageBodyBytes, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (wrapper == null) {
                logger.warn("Received null wrapper from Redis message on channel {}. Skipping.", (Object)channel);
                return;
            }
            Object payload = wrapper.getPayload();
            String hostname = wrapper.getHostname();
            if (hostname != null && hostname.equalsIgnoreCase(Constants.HOSTNAME)) {
                logger.info("Redis Message hostname {} matches with local hostname {}. Skipping processing.", (Object)hostname, (Object)Constants.HOSTNAME);
                return;
            }
            if (channel.equals(this.recoveryAddHASyncChannel)) {
                Recovery recovery = payload != null ? (Recovery)this.objectMapper.convertValue(payload, Recovery.class) : null;
                logger.info("Received Recovery message on channel: {} (pattern: {}). Object: {}", (Object)channel, (Object)patternStr, (Object)(recovery != null ? recovery.getUuid() : null));
                if (!this.isDatabaseConnected()) {
                    logger.info("Database connection is down. Skipping save operation in Recovery Table.");
                    return;
                }
                if (recovery == null) {
                    logger.warn("Recovery object is null after conversion. Skipping processing.");
                    return;
                }
                this.saveAndUpdateEntry(recovery);
            } else if (channel.equals(this.recoveryRemoveHASyncChannel)) {
                String uuidToRemove = payload != null ? (String)this.objectMapper.convertValue(payload, String.class) : "";
                logger.info("Received Recovery (Remove) message on channel: {} (pattern: {}). UUID to remove: {}", (Object)channel, (Object)patternStr, (Object)uuidToRemove);
                if (!this.isDatabaseConnected()) {
                    logger.info("Database connection is down. Skipping Remove operation from Recovery Table.");
                    return;
                }
                this.removeEntryByUuid(uuidToRemove);
            } else {
                logger.warn("Received message on unknown channel: {} (pattern: {}). Message Body: {}", (Object)channel, (Object)patternStr, (Object)new String(messageBodyBytes));
            }
        }
        catch (Exception e) {
            logger.error("An unexpected error occurred while processing Recovery message on channel {}. Error: {}", (Object)channel, (Object)e.getMessage(), (Object)e);
        }
    }

    @Transactional(transactionManager="switchTransactionManager")
    private void saveAndUpdateEntry(Recovery recovery) {
        try {
            if (recovery == null || recovery.getUuid() == null || recovery.getUuid().isEmpty()) {
                logger.warn("Recovery object or its UUID is null/empty. Cannot save or update.");
                return;
            }
            Optional existingRecoveryOptional = this.recoveryRepository.findByUuid(recovery.getUuid());
            if (existingRecoveryOptional.isPresent()) {
                Recovery existingRecovery = (Recovery)existingRecoveryOptional.get();
                existingRecovery.setTechnology(recovery.getTechnology());
                existingRecovery.setProfile_name(recovery.getProfile_name());
                existingRecovery.setHostname(recovery.getHostname());
                existingRecovery.setServercode(recovery.getServercode());
                existingRecovery.setRuntime_uuid(recovery.getRuntime_uuid());
                existingRecovery.setMetadata(recovery.getMetadata());
                this.recoveryRepository.save((Object)existingRecovery);
                logger.info("Recovery entry for UUID: {} updated successfully.", (Object)recovery.getUuid());
            } else {
                this.recoveryRepository.save((Object)recovery);
                logger.info("New Recovery entry for UUID: {} saved successfully.", (Object)recovery.getUuid());
            }
        }
        catch (Exception e) {
            logger.error("Error while saving or updating Recovery entry for UUID: {}. Error: {}", (Object)(recovery != null ? recovery.getUuid() : "N/A"), (Object)e.getMessage(), (Object)e);
        }
    }

    @Transactional(transactionManager="switchTransactionManager")
    private void removeEntryByUuid(String uuid) {
        try {
            int deletedCount = this.recoveryRepository.deleteByUuid(uuid);
            if (deletedCount > 0) {
                logger.info("Successfully removed {} Recovery entries for UUID: {}", (Object)deletedCount, (Object)uuid);
            } else {
                logger.warn("No Recovery entry found to remove for UUID: {}", (Object)uuid);
            }
        }
        catch (Exception e) {
            logger.error("Error while removing Recovery entry for UUID: {}. Error: {}", (Object)uuid, (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isDatabaseConnected() {
        try {
            this.recoveryRepository.count();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

