/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.messaging;

import com.coraltele.ims.HelperIMS;
import com.coraltele.ims.SubscribeIMS;
import com.coraltele.model.ExtensionUpdate;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class ExtensionUpdateSubscriber
implements MessageListener {
    private static final Logger logger = LogManager.getLogger(ExtensionUpdateSubscriber.class);
    private SubscribeIMS subscribeIMS;
    private HelperIMS helperIMS;

    public ExtensionUpdateSubscriber(SubscribeIMS subscribeIMS, HelperIMS helperIMS) {
        this.subscribeIMS = subscribeIMS;
        this.helperIMS = helperIMS;
    }

    public void onMessage(Message message, byte[] pattern) {
        String messageBody = message.toString();
        ObjectMapper data = new ObjectMapper();
        try {
            data.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ExtensionUpdate subscribedMessage = (ExtensionUpdate)data.readValue(messageBody, ExtensionUpdate.class);
            if (this.helperIMS.isValidLogUser(subscribedMessage.getNumber())) {
                logger.info("Message received : {}", (Object)messageBody);
                logger.info("Message Processed : Number: {},callID: {},Available: {},direction: {},callStatus: {}", (Object)subscribedMessage.getNumber(), (Object)subscribedMessage.getActiveCallId(), (Object)subscribedMessage.isAvailable(), (Object)subscribedMessage.getDirection(), (Object)subscribedMessage.getCallStatus());
            }
            String callStatus = "";
            if (subscribedMessage.getDirection().equals("initiator")) {
                callStatus = "confirmed";
            } else if (subscribedMessage.getCallStatus().equalsIgnoreCase("early") || subscribedMessage.getCallStatus().equalsIgnoreCase("ringing")) {
                callStatus = "early";
            } else if (subscribedMessage.getCallStatus().equalsIgnoreCase("confirmed")) {
                callStatus = "confirmed";
            }
            if (callStatus == null || callStatus.isEmpty()) {
                callStatus = "terminated";
            }
            this.subscribeIMS.sendNotify(subscribedMessage.getNumber(), subscribedMessage.getActiveCallId(), callStatus);
        }
        catch (JsonProcessingException e) {
            logger.info("Error while processing message : {} {}", (Object)messageBody, (Object)e);
            e.printStackTrace();
        }
    }
}

