/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.messaging;

import com.coraltele.helper.Constants;
import com.coraltele.model.RedisMessageWrapper;
import com.coraltele.service.FeatureIMSService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class ControlSyncMessageListener
implements MessageListener {
    private static final Logger logger = LogManager.getLogger(ControlSyncMessageListener.class);
    private final FeatureIMSService featureIMSService;
    private final ObjectMapper objectMapper;

    public ControlSyncMessageListener(FeatureIMSService featureIMSService) {
        this.featureIMSService = featureIMSService;
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void onMessage(Message message, byte[] pattern) {
        if (message == null || message.getBody() == null) {
            logger.warn("Received null or empty Redis control message. Skipping processing.");
            return;
        }
        String channel = new String(message.getChannel());
        try {
            byte[] messageBodyBytes = message.getBody();
            RedisMessageWrapper wrapper = (RedisMessageWrapper)this.objectMapper.readValue(messageBodyBytes, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (wrapper == null) {
                logger.warn("Received null wrapper from Redis message on channel {}. Skipping.", (Object)channel);
                return;
            }
            Object payload = wrapper.getPayload();
            String hostname = wrapper.getHostname();
            if (hostname != null && hostname.equalsIgnoreCase(Constants.HOSTNAME)) {
                logger.info("Redis Message hostname {} matches with local hostname {}. Skipping processing.", (Object)hostname, (Object)Constants.HOSTNAME);
                return;
            }
            logger.info("Received controlHostname message on channel {}: {}", (Object)channel, (Object)hostname);
            this.featureIMSService.stopSchedulerSaveAfterControlShift();
        }
        catch (Exception e) {
            logger.error("Error processing Redis control message on channel {}: {}", (Object)channel, (Object)e.getMessage(), (Object)e);
        }
    }
}

