/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.messaging;

import com.coraltele.helper.Constants;
import com.coraltele.model.CallbackObject;
import com.coraltele.model.RedisMessageWrapper;
import com.coraltele.service.FeatureIMSService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class CallbackMessageListener
implements MessageListener {
    private static final Logger logger = LogManager.getLogger(CallbackMessageListener.class);
    private final FeatureIMSService featureIMSService;
    private final ObjectMapper objectMapper;
    private final Lock userLock = new ReentrantLock();

    public CallbackMessageListener(FeatureIMSService featureIMSService) {
        this.featureIMSService = featureIMSService;
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message, byte[] pattern) {
        block23: {
            if (message == null || message.getBody() == null) {
                logger.warn("Received null or empty Redis callback message. Skipping processing.");
                return;
            }
            String channel = new String(message.getChannel());
            try {
                byte[] messageBodyBytes = message.getBody();
                RedisMessageWrapper wrapper = (RedisMessageWrapper)this.objectMapper.readValue(messageBodyBytes, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                if (wrapper == null) {
                    logger.warn("Received null wrapper from Redis message on channel {}. Skipping.", (Object)channel);
                    return;
                }
                Object payload = wrapper.getPayload();
                String hostname = wrapper.getHostname();
                if (hostname != null && hostname.equalsIgnoreCase(Constants.HOSTNAME)) {
                    logger.info("Redis Message hostname {} matches with local hostname {}. Skipping processing.", (Object)hostname, (Object)Constants.HOSTNAME);
                    return;
                }
                if (channel.contains("callbackHASyncChannel")) {
                    FeatureIMSService.CallbackUpdate update;
                    FeatureIMSService.CallbackUpdate callbackUpdate = update = payload != null ? (FeatureIMSService.CallbackUpdate)this.objectMapper.convertValue(payload, FeatureIMSService.CallbackUpdate.class) : null;
                    if (update == null) {
                        logger.warn("Received null CallbackUpdate object from Redis message. Skipping.");
                        return;
                    }
                    logger.info("Received Callback message on channel: {} -> {}:{}:{}:{}", (Object)channel, (Object)update.getFromUser(), (Object)update.getToUser(), (Object)update.getMapType(), (Object)update.getOperation());
                    if (this.userLock.tryLock(5L, TimeUnit.SECONDS)) {
                        try {
                            this.featureIMSService.processCallbackOperation(update);
                            break block23;
                        }
                        finally {
                            this.userLock.unlock();
                        }
                    }
                    logger.warn("Lock not acquired within 5 seconds for callback: {} -> {}", (Object)update.getFromUser(), (Object)update.getToUser());
                    break block23;
                }
                if (channel.contains("callbackWithTimeAddHASyncChannel")) {
                    CallbackObject callbackObj;
                    CallbackObject callbackObject = callbackObj = payload != null ? (CallbackObject)this.objectMapper.convertValue(payload, CallbackObject.class) : null;
                    if (callbackObj == null) {
                        logger.warn("Received null callbackWithTimeAdd object from Redis message. Skipping.");
                        return;
                    }
                    logger.info("Received CallbackWithTimeAdd message on channel: {} -> {}:{}:{}:{}", (Object)channel, (Object)callbackObj.getFromUser(), (Object)callbackObj.getToUser());
                    if (this.userLock.tryLock(5L, TimeUnit.SECONDS)) {
                        try {
                            this.featureIMSService.processCallbackWithTimeOperation(callbackObj, "add");
                            break block23;
                        }
                        finally {
                            this.userLock.unlock();
                        }
                    }
                    logger.warn("Lock not acquired within 5 seconds for callbackWithTime: {} -> {}", (Object)callbackObj.getFromUser(), (Object)callbackObj.getToUser());
                    break block23;
                }
                if (channel.contains("callbackWithTimeRemoveHASyncChannel")) {
                    CallbackObject callbackObj;
                    CallbackObject callbackObject = callbackObj = payload != null ? (CallbackObject)this.objectMapper.convertValue(payload, CallbackObject.class) : null;
                    if (callbackObj == null) {
                        logger.warn("Received null callbackWithTimeRemove object from Redis message. Skipping.");
                        return;
                    }
                    logger.info("Received CallbackWithTimeRemove message on channel: {} -> {}:{}", (Object)channel, (Object)callbackObj.getFromUser(), (Object)callbackObj.getToUser());
                    if (this.userLock.tryLock(5L, TimeUnit.SECONDS)) {
                        try {
                            this.featureIMSService.processCallbackWithTimeOperation(callbackObj, "remove");
                            break block23;
                        }
                        finally {
                            this.userLock.unlock();
                        }
                    }
                    logger.warn("Lock not acquired within 5 seconds for callbackWithTime: {} -> {}", (Object)callbackObj.getFromUser(), (Object)callbackObj.getToUser());
                    break block23;
                }
                logger.info("Received message on Unknown channel: {} ", (Object)channel);
            }
            catch (Exception e) {
                logger.error("Error processing Redis message in CallbackMessageListener", (Throwable)e);
            }
        }
    }
}

