/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack.timers;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.StackLogger;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.stack.SIPStackTimerTask;
import com.coraltele.javax.sip.stack.timers.DefaultSipTimer;
import com.coraltele.javax.sip.stack.timers.SipTimer;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultSipTimer
extends Timer
implements SipTimer {
    private static StackLogger logger = CommonLogger.getLogger(DefaultSipTimer.class);
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected SipStackImpl sipStackImpl;

    public boolean schedule(SIPStackTimerTask task, long delay) {
        if (!this.started.get()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        super.schedule((TimerTask)new DefaultTimerTask(this, task), delay);
        return true;
    }

    public boolean scheduleWithFixedDelay(SIPStackTimerTask task, long delay, long period) {
        if (!this.started.get()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        super.schedule((TimerTask)new DefaultTimerTask(this, task), delay, period);
        return true;
    }

    public boolean cancel(SIPStackTimerTask task) {
        return ((TimerTask)task.getSipTimerTask()).cancel();
    }

    public void start(SipStackImpl sipStack, Properties configurationProperties) {
        this.sipStackImpl = sipStack;
        this.started.set(true);
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("the sip stack timer " + this.getClass().getName() + " has been started");
        }
    }

    public void stop() {
        this.started.set(false);
        this.cancel();
        logger.logStackTrace(32);
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("the sip stack timer " + this.getClass().getName() + " has been stopped");
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }
}

