/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.HostPort;
import com.coraltele.core.InternalErrorHandler;
import com.coraltele.core.StackLogger;
import com.coraltele.core.ThreadAuditor;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.stack.BlockingQueueDispatchAuditor;
import com.coraltele.javax.sip.stack.DatagramQueuedMessageDispatch;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.MessageProcessor;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import com.coraltele.javax.sip.stack.UDPMessageChannel;
import com.coraltele.service.IMSV2ServerService;
import com.coraltele.service.SubscribeIMSService;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class UDPMessageProcessor
extends MessageProcessor {
    private static StackLogger logger = CommonLogger.getLogger(UDPMessageProcessor.class);
    private int port;
    protected BlockingQueue<DatagramQueuedMessageDispatch> messageQueue;
    BlockingQueueDispatchAuditor congestionAuditor;
    protected LinkedList messageChannels;
    protected int threadPoolSize;
    protected DatagramSocket sock;
    protected boolean isRunning;
    private static final int HIGHWAT = 5000;
    private static final int LOWAT = 2500;
    private int maxMessageSize = SipStackImpl.MAX_DATAGRAM_SIZE;

    protected UDPMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port) throws IOException {
        super(ipAddress, port, "udp", sipStack);
        this.sipStack = sipStack;
        if (sipStack.getMaxMessageSize() < SipStackImpl.MAX_DATAGRAM_SIZE && sipStack.getMaxMessageSize() > 0) {
            this.maxMessageSize = sipStack.getMaxMessageSize();
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Max Message size is " + this.maxMessageSize);
        }
        this.messageQueue = new LinkedBlockingQueue();
        if (sipStack.stackCongenstionControlTimeout > 0) {
            this.congestionAuditor = new BlockingQueueDispatchAuditor((Queue)this.messageQueue);
            this.congestionAuditor.setTimeout(sipStack.stackCongenstionControlTimeout);
            this.congestionAuditor.start(2000);
        }
        this.port = port;
        try {
            this.sock = sipStack.getNetworkLayer().createDatagramSocket(port, ipAddress);
            this.sock.setReceiveBufferSize(sipStack.getReceiveUdpBufferSize());
            this.sock.setSendBufferSize(sipStack.getSendUdpBufferSize());
            if (sipStack.getThreadAuditor().isEnabled()) {
                this.sock.setSoTimeout((int)sipStack.getThreadAuditor().getPingIntervalInMillisecs());
            }
            if (ipAddress.getHostAddress().equals("0.0.0.0") || ipAddress.getHostAddress().equals("::0")) {
                super.setIpAddress(this.sock.getLocalAddress());
            }
        }
        catch (SocketException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws IOException {
        this.isRunning = true;
        Thread thread = new Thread((Runnable)this);
        thread.setDaemon(true);
        thread.setName("UDPMessageProcessorThread");
        thread.setPriority(this.sipStack.getThreadPriority());
        thread.start();
    }

    public void run() {
        this.messageChannels = new LinkedList();
        if (this.sipStack.threadPoolSize != -1) {
            for (int i = 0; i < this.sipStack.threadPoolSize; ++i) {
                UDPMessageChannel channel = new UDPMessageChannel(this.sipStack, this, ((SipStackImpl)this.sipStack).getStackName() + "-UDPMessageChannelThread-" + i);
                this.messageChannels.add(channel);
            }
        }
        ThreadAuditor.ThreadHandle threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
        this.processPackets(SubscribeIMSService.packets);
        this.processPackets(IMSV2ServerService.UDPSubscriptionPackets);
        while (this.isRunning) {
            try {
                threadHandle.ping();
                int bufsize = this.maxMessageSize;
                byte[] message = new byte[bufsize];
                DatagramPacket packet = new DatagramPacket(message, bufsize);
                this.sock.receive(packet);
                if (this.sipStack.threadPoolSize != -1) {
                    this.messageQueue.offer(new DatagramQueuedMessageDispatch(packet, System.currentTimeMillis()));
                    continue;
                }
                new UDPMessageChannel(this.sipStack, this, packet);
            }
            catch (SocketTimeoutException bufsize) {
            }
            catch (SocketException ex) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("UDPMessageProcessor: Stopping");
                }
                this.isRunning = false;
            }
            catch (IOException ex) {
                this.isRunning = false;
                ex.printStackTrace();
                if (!logger.isLoggingEnabled(32)) continue;
                logger.logDebug("UDPMessageProcessor: Got an IO Exception");
            }
            catch (Exception ex) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("UDPMessageProcessor: Unexpected Exception - quitting");
                }
                InternalErrorHandler.handleException((Exception)ex);
                return;
            }
        }
    }

    private void processPackets(List<DatagramPacket> packets) {
        for (DatagramPacket packet : packets) {
            if (this.sipStack.threadPoolSize != -1) {
                this.messageQueue.offer(new DatagramQueuedMessageDispatch(packet, System.currentTimeMillis()));
                continue;
            }
            new UDPMessageChannel(this.sipStack, this, packet);
        }
    }

    public void stop() {
        this.isRunning = false;
        this.sock.close();
        for (Object messageChannel : this.messageChannels) {
            ((MessageChannel)messageChannel).close();
        }
        if (this.sipStack.stackCongenstionControlTimeout > 0 && this.congestionAuditor != null) {
            this.congestionAuditor.stop();
        }
    }

    public String getTransport() {
        return "udp";
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public MessageChannel createMessageChannel(HostPort targetHostPort) throws UnknownHostException {
        return new UDPMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
    }

    public MessageChannel createMessageChannel(InetAddress host, int port) throws IOException {
        return new UDPMessageChannel(host, port, this.sipStack, this);
    }

    public int getDefaultTargetPort() {
        return 5060;
    }

    public boolean isSecure() {
        return false;
    }

    public int getMaximumMessageSize() {
        return this.sipStack.getReceiveUdpBufferSize();
    }

    public boolean inUse() {
        return !this.messageQueue.isEmpty();
    }
}

