/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.InternalErrorHandler;
import com.coraltele.core.StackLogger;
import com.coraltele.core.ThreadAuditor;
import com.coraltele.interfaces.sip.address.Hop;
import com.coraltele.interfaces.sip.message.Message;
import com.coraltele.javax.sip.header.CSeq;
import com.coraltele.javax.sip.header.CallID;
import com.coraltele.javax.sip.header.ContentLength;
import com.coraltele.javax.sip.header.From;
import com.coraltele.javax.sip.header.RequestLine;
import com.coraltele.javax.sip.header.StatusLine;
import com.coraltele.javax.sip.header.To;
import com.coraltele.javax.sip.header.Via;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.parser.MessageParser;
import com.coraltele.javax.sip.parser.ParseExceptionListener;
import com.coraltele.javax.sip.stack.DatagramQueuedMessageDispatch;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.MessageProcessor;
import com.coraltele.javax.sip.stack.RawMessageChannel;
import com.coraltele.javax.sip.stack.SIPClientTransaction;
import com.coraltele.javax.sip.stack.SIPServerTransaction;
import com.coraltele.javax.sip.stack.SIPStackTimerTask;
import com.coraltele.javax.sip.stack.SIPTransaction;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import com.coraltele.javax.sip.stack.ServerRequestInterface;
import com.coraltele.javax.sip.stack.ServerResponseInterface;
import com.coraltele.javax.sip.stack.UDPMessageChannel;
import com.coraltele.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import java.util.Hashtable;

/*
 * Exception performing whole class analysis ignored.
 */
public class UDPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Runnable,
RawMessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(UDPMessageChannel.class);
    protected SIPTransactionStack sipStack;
    protected MessageParser myParser;
    private InetAddress peerAddress;
    private String myAddress;
    private int peerPacketSourcePort;
    private InetAddress peerPacketSourceAddress;
    private int peerPort;
    private String peerProtocol;
    protected int myPort;
    private DatagramPacket incomingPacket;
    private long receptionTime;
    private Thread mythread = null;
    private static Hashtable<String, PingBackTimerTask> pingBackRecord = new Hashtable();

    protected UDPMessageChannel(SIPTransactionStack stack, UDPMessageProcessor messageProcessor, String threadName) {
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        this.myParser = this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack);
        this.mythread = new Thread((Runnable)this);
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.mythread.setName(threadName);
        this.mythread.setDaemon(true);
        this.mythread.start();
    }

    protected UDPMessageChannel(SIPTransactionStack stack, UDPMessageProcessor messageProcessor, DatagramPacket packet) {
        this.incomingPacket = packet;
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        this.myParser = this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack);
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.mythread = new Thread((Runnable)this);
        this.mythread.setDaemon(true);
        this.mythread.start();
    }

    protected UDPMessageChannel(InetAddress targetAddr, int port, SIPTransactionStack sipStack, UDPMessageProcessor messageProcessor) {
        this.peerAddress = targetAddr;
        this.peerPort = port;
        this.peerProtocol = "UDP";
        this.messageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.sipStack = sipStack;
        this.myParser = sipStack.getMessageParserFactory().createMessageParser(sipStack);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Creating message channel " + targetAddr.getHostAddress() + "/" + port);
        }
    }

    @Override
    public void run() {
        ThreadAuditor.ThreadHandle threadHandle = null;
        UDPMessageProcessor udpMessageProcessor = (UDPMessageProcessor)this.messageProcessor;
        do {
            DatagramPacket packet = null;
            if (this.sipStack.threadPoolSize != -1) {
                block8: {
                    if (threadHandle == null) {
                        threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
                    }
                    threadHandle.ping();
                    try {
                        packet = ((DatagramQueuedMessageDispatch)udpMessageProcessor.messageQueue.take()).packet;
                    }
                    catch (InterruptedException ex) {
                        if (udpMessageProcessor.isRunning) break block8;
                        return;
                    }
                }
                this.incomingPacket = packet;
            } else {
                packet = this.incomingPacket;
            }
            try {
                this.processIncomingDataPacket(packet);
            }
            catch (Exception e) {
                logger.logError("Error while processing incoming UDP packet", e);
            }
        } while (this.sipStack.threadPoolSize != -1);
    }

    private void processIncomingDataPacket(DatagramPacket packet) throws Exception {
        this.peerAddress = packet.getAddress();
        int packetLength = packet.getLength();
        byte[] bytes = packet.getData();
        byte[] msgBytes = new byte[packetLength];
        System.arraycopy(bytes, 0, msgBytes, 0, packetLength);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("UDPMessageChannel: processIncomingDataPacket : peerAddress = " + this.peerAddress.getHostAddress() + "/" + packet.getPort() + " Length = " + packetLength);
        }
        SIPMessage sipMessage = null;
        try {
            this.receptionTime = System.currentTimeMillis();
            sipMessage = this.myParser.parseSIPMessage(msgBytes, true, false, (ParseExceptionListener)this);
            if (sipMessage instanceof SIPRequest) {
                String cseqMethod;
                String sipVersion = ((SIPRequest)sipMessage).getRequestLine().getSipVersion();
                if (!sipVersion.equals("SIP/2.0")) {
                    SIPResponse versionNotSupported = ((SIPRequest)sipMessage).createResponse(505, "Bad version " + sipVersion);
                    this.sendMessage(versionNotSupported.toString().getBytes(), this.peerAddress, packet.getPort(), "UDP", false);
                    return;
                }
                String method = ((SIPRequest)sipMessage).getMethod();
                if (!method.equalsIgnoreCase(cseqMethod = ((SIPRequest)sipMessage).getCSeqHeader().getMethod())) {
                    SIPResponse sipResponse = ((SIPRequest)sipMessage).createResponse(400);
                    byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                    this.sendMessage(resp, this.peerAddress, packet.getPort(), "UDP", false);
                    return;
                }
            }
        }
        catch (ParseException ex) {
            String msgString;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Rejecting message !  " + new String(msgBytes));
                logger.logDebug("error message " + ex.getMessage());
                logger.logException((Throwable)ex);
            }
            if (!(msgString = new String(msgBytes, 0, packetLength)).startsWith("SIP/") && !msgString.startsWith("ACK ")) {
                String badReqRes = this.createBadReqRes(msgString, ex);
                if (badReqRes != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Sending automatic 400 Bad Request:");
                        logger.logDebug(badReqRes);
                    }
                    try {
                        this.sendMessage(badReqRes.getBytes(), this.peerAddress, packet.getPort(), "UDP", false);
                    }
                    catch (IOException e) {
                        logger.logException((Throwable)e);
                    }
                } else if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Could not formulate automatic 400 Bad Request");
                }
            }
            return;
        }
        if (sipMessage == null) {
            String key;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Rejecting message !  + Null message parsed.");
            }
            if (pingBackRecord.get(key = packet.getAddress().getHostAddress() + ":" + packet.getPort()) == null && this.sipStack.getMinKeepAliveInterval() > 0L) {
                byte[] retval = "\r\n\r\n".getBytes();
                DatagramPacket keepalive = new DatagramPacket(retval, 0, retval.length, packet.getAddress(), packet.getPort());
                PingBackTimerTask task = new PingBackTimerTask(this, packet.getAddress().getHostAddress(), packet.getPort());
                pingBackRecord.put(key, task);
                this.sipStack.getTimer().schedule((SIPStackTimerTask)task, this.sipStack.getMinKeepAliveInterval() * 1000L);
                ((UDPMessageProcessor)this.messageProcessor).sock.send(keepalive);
            } else {
                logger.logDebug("Not sending ping back");
            }
            return;
        }
        Via topMostVia = sipMessage.getTopmostVia();
        if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || topMostVia == null) {
            String badmsg = new String(msgBytes);
            if (logger.isLoggingEnabled()) {
                logger.logError("bad message " + badmsg);
                logger.logError(">>> Dropped Bad Msg From = " + sipMessage.getFrom() + "To = " + sipMessage.getTo() + "CallId = " + sipMessage.getCallId() + "CSeq = " + sipMessage.getCSeq() + "Via = " + sipMessage.getViaHeaders());
            }
            return;
        }
        if (this.sipStack.sipEventInterceptor != null) {
            this.sipStack.sipEventInterceptor.beforeMessage((Message)sipMessage);
        }
        if (sipMessage instanceof SIPRequest) {
            Hop hop = this.sipStack.addressResolver.resolveAddress(topMostVia.getHop());
            this.peerPort = hop.getPort();
            this.peerProtocol = topMostVia.getTransport();
            this.peerPacketSourceAddress = packet.getAddress();
            this.peerPacketSourcePort = packet.getPort();
            try {
                this.peerAddress = packet.getAddress();
                boolean hasRPort = topMostVia.hasParameter("rport");
                if (hasRPort || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                    topMostVia.setParameter("received", this.peerAddress.getHostAddress());
                }
                if (hasRPort) {
                    topMostVia.setParameter("rport", Integer.toString(this.peerPacketSourcePort));
                }
            }
            catch (ParseException ex1) {
                InternalErrorHandler.handleException((Exception)ex1);
            }
        } else {
            this.peerPacketSourceAddress = packet.getAddress();
            this.peerPacketSourcePort = packet.getPort();
            this.peerAddress = packet.getAddress();
            this.peerPort = packet.getPort();
            this.peerProtocol = topMostVia.getTransport();
        }
        this.processMessage(sipMessage);
        if (this.sipStack.sipEventInterceptor != null) {
            this.sipStack.sipEventInterceptor.afterMessage((Message)sipMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(SIPMessage sipMessage) {
        sipMessage.setRemoteAddress(this.peerAddress);
        sipMessage.setRemotePort(this.getPeerPort());
        sipMessage.setLocalPort(this.getPort());
        sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        if (sipMessage instanceof SIPRequest) {
            ServerRequestInterface sipServerRequest;
            SIPRequest sipRequest = (SIPRequest)sipMessage;
            if (logger.isLoggingEnabled(16)) {
                this.sipStack.serverLogger.logMessage(sipMessage, this.getPeerHostPort().toString(), this.getHost() + ":" + this.myPort, false, this.receptionTime);
            }
            if ((sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, (MessageChannel)this)) == null) {
                if (logger.isLoggingEnabled()) {
                    logger.logWarning("Null request interface returned -- dropping request");
                }
                return;
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("About to process " + sipRequest.getFirstLine() + "/" + sipServerRequest);
            }
            try {
                sipServerRequest.processRequest(sipRequest, (MessageChannel)this);
            }
            finally {
                SIPServerTransaction sipServerTx;
                if (sipServerRequest instanceof SIPTransaction && !(sipServerTx = (SIPServerTransaction)sipServerRequest).passToListener()) {
                    ((SIPTransaction)sipServerRequest).releaseSem();
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Done processing " + sipRequest.getFirstLine() + "/" + sipServerRequest);
            }
        } else {
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            try {
                sipResponse.checkHeaders();
            }
            catch (ParseException ex) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("Dropping Badly formatted response message >>> " + sipResponse);
                }
                return;
            }
            ServerResponseInterface sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, (MessageChannel)this);
            if (sipServerResponse != null) {
                try {
                    if (sipServerResponse instanceof SIPClientTransaction && !((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) {
                        if (logger.isLoggingEnabled()) {
                            logger.logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        return;
                    }
                    sipServerResponse.processResponse(sipResponse, (MessageChannel)this);
                }
                finally {
                    if (sipServerResponse instanceof SIPTransaction && !((SIPTransaction)sipServerResponse).passToListener()) {
                        ((SIPTransaction)sipServerResponse).releaseSem();
                    }
                }
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("null sipServerResponse!");
            }
        }
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (logger.isLoggingEnabled()) {
            logger.logException((Throwable)ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(ContentLength.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            if (logger.isLoggingEnabled()) {
                logger.logError("BAD MESSAGE!");
                logger.logError(message);
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public void sendMessage(SIPMessage sipMessage) throws IOException {
        if (logger.isLoggingEnabled(16) && this.sipStack.isLogStackTraceOnMessageSend()) {
            if (sipMessage instanceof SIPRequest && ((SIPRequest)sipMessage).getRequestLine() != null) {
                logger.logStackTrace(16);
            } else {
                logger.logStackTrace(16);
            }
        }
        long time = System.currentTimeMillis();
        try {
            for (MessageProcessor messageProcessor : this.sipStack.getMessageProcessors()) {
                MessageChannel messageChannel;
                if (!messageProcessor.getIpAddress().equals(this.peerAddress) || messageProcessor.getPort() != this.peerPort || !messageProcessor.getTransport().equalsIgnoreCase(this.peerProtocol) || !((messageChannel = messageProcessor.createMessageChannel(this.peerAddress, this.peerPort)) instanceof RawMessageChannel)) continue;
                RawMessageChannel channel = (RawMessageChannel)messageChannel;
                1 processMessageTask = new /* Unavailable Anonymous Inner Class!! */;
                this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute((Runnable)processMessageTask);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Self routing message");
                }
                return;
            }
            byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
            this.sendMessage(msg, this.peerAddress, this.peerPort, this.peerProtocol, sipMessage instanceof SIPRequest);
            sipMessage.setRemoteAddress(this.peerAddress);
            sipMessage.setRemotePort(this.peerPort);
            sipMessage.setLocalPort(this.getPort());
            sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.logError("An exception occured while sending message", ex);
            throw new IOException("An exception occured while sending message");
        }
        finally {
            if (logger.isLoggingEnabled(16) && !sipMessage.isNullRequest()) {
                this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Sent EMPTY Message");
            }
        }
    }

    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, boolean reConnect) throws IOException {
        if (logger.isLoggingEnabled(16) && this.sipStack.isLogStackTraceOnMessageSend()) {
            logger.logStackTrace(16);
        }
        if (peerPort == -1) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            }
            throw new IOException("Receiver port not set ");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\nmessageSize =  " + msg.length + " message = " + new String(msg));
            logger.logDebug("*******************\n");
        }
        DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
        try {
            DatagramSocket sock;
            boolean created = false;
            if (this.sipStack.udpFlag) {
                sock = ((UDPMessageProcessor)this.messageProcessor).sock;
            } else {
                sock = new DatagramSocket();
                created = true;
            }
            sock.send(reply);
            if (created) {
                sock.close();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException((Exception)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, String peerProtocol, boolean retry) throws IOException {
        if (peerPort == -1) {
            if (!logger.isLoggingEnabled(32)) throw new IOException("Receiver port not set ");
            logger.logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            throw new IOException("Receiver port not set ");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(":sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n messageSize = " + msg.length);
        }
        if (peerProtocol.compareToIgnoreCase("UDP") == 0) {
            DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
            try {
                DatagramSocket sock = this.sipStack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : this.sipStack.getNetworkLayer().createDatagramSocket();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
                }
                sock.send(reply);
                if (this.sipStack.udpFlag) return;
                sock.close();
                return;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException((Exception)ex);
                return;
            }
        } else {
            Socket outputSocket = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), peerAddress, peerPort, "tcp", msg, retry, (MessageChannel)this);
            OutputStream myOutputStream = outputSocket.getOutputStream();
            myOutputStream.write(msg, 0, msg.length);
            myOutputStream.flush();
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "udp";
    }

    public String getHost() {
        return this.messageProcessor.getIpAddress().getHostAddress();
    }

    public int getPort() {
        return ((UDPMessageProcessor)this.messageProcessor).getPort();
    }

    public String getPeerName() {
        return this.peerAddress.getHostName();
    }

    public String getPeerAddress() {
        return this.peerAddress.getHostAddress();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public boolean equals(Object other) {
        boolean retval;
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            retval = false;
        } else {
            UDPMessageChannel that = (UDPMessageChannel)other;
            retval = this.getKey().equals(that.getKey());
        }
        return retval;
    }

    public String getKey() {
        return UDPMessageChannel.getKey((InetAddress)this.peerAddress, (int)this.peerPort, (String)"UDP");
    }

    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public boolean isReliable() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    public void close() {
        if (this.mythread != null) {
            this.mythread.interrupt();
            this.mythread = null;
        }
    }

    static /* synthetic */ Hashtable access$000() {
        return pingBackRecord;
    }

    static /* synthetic */ StackLogger access$100() {
        return logger;
    }
}

