/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.InternalErrorHandler;
import com.coraltele.core.StackLogger;
import com.coraltele.interfaces.sip.address.Hop;
import com.coraltele.javax.sip.header.CSeq;
import com.coraltele.javax.sip.header.CallID;
import com.coraltele.javax.sip.header.ContentLength;
import com.coraltele.javax.sip.header.From;
import com.coraltele.javax.sip.header.RequestLine;
import com.coraltele.javax.sip.header.StatusLine;
import com.coraltele.javax.sip.header.To;
import com.coraltele.javax.sip.header.Via;
import com.coraltele.javax.sip.header.ViaList;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.parser.Pipeline;
import com.coraltele.javax.sip.parser.PipelinedMsgParser;
import com.coraltele.javax.sip.parser.SIPMessageListener;
import com.coraltele.javax.sip.stack.IOHandler;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.MessageProcessor;
import com.coraltele.javax.sip.stack.RawMessageChannel;
import com.coraltele.javax.sip.stack.SIPClientTransaction;
import com.coraltele.javax.sip.stack.SIPServerTransaction;
import com.coraltele.javax.sip.stack.SIPStackTimerTask;
import com.coraltele.javax.sip.stack.SIPTransaction;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import com.coraltele.javax.sip.stack.ServerRequestInterface;
import com.coraltele.javax.sip.stack.ServerResponseInterface;
import com.coraltele.javax.sip.stack.TCPMessageChannel;
import com.coraltele.javax.sip.stack.TCPMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TCPMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable,
RawMessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(TCPMessageChannel.class);
    private static final Logger v2Logger = LogManager.getLogger(TCPMessageChannel.class);
    private Socket mySock;
    private PipelinedMsgParser myParser;
    protected InputStream myClientInputStream;
    protected OutputStream myClientOutputStream;
    protected String key;
    protected boolean isCached;
    protected boolean isRunning = true;
    private Thread mythread;
    protected SIPTransactionStack sipStack;
    protected String myAddress;
    protected int myPort;
    protected InetAddress peerAddress;
    protected int peerPortAdvertisedInHeaders = -1;
    protected int peerPort;
    protected String peerProtocol;
    private TCPMessageProcessor tcpMessageProcessor;

    protected TCPMessageChannel(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    protected TCPMessageChannel(Socket sock, SIPTransactionStack sipStack, TCPMessageProcessor msgProcessor, String threadName) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("creating new TCPMessageChannel ");
            logger.logStackTrace();
        }
        this.mySock = sock;
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = msgProcessor.getIpAddress().getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.myClientOutputStream = this.mySock.getOutputStream();
        this.mythread = new Thread((Runnable)this);
        this.mythread.setDaemon(true);
        this.mythread.setName(threadName);
        this.sipStack = sipStack;
        this.peerPort = this.mySock.getPort();
        this.key = MessageChannel.getKey((InetAddress)this.peerAddress, (int)this.peerPort, (String)"TCP");
        this.tcpMessageProcessor = msgProcessor;
        this.myPort = this.tcpMessageProcessor.getPort();
        this.messageProcessor = msgProcessor;
        this.mythread.start();
    }

    protected TCPMessageChannel(InetAddress inetAddr, int port, SIPTransactionStack sipStack, TCPMessageProcessor messageProcessor) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("creating new TCPMessageChannel ");
            logger.logStackTrace();
        }
        this.peerAddress = inetAddr;
        this.peerPort = port;
        this.myPort = messageProcessor.getPort();
        this.peerProtocol = "TCP";
        this.sipStack = sipStack;
        this.tcpMessageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.key = MessageChannel.getKey((InetAddress)this.peerAddress, (int)this.peerPort, (String)"TCP");
        this.messageProcessor = messageProcessor;
    }

    public boolean isReliable() {
        return true;
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean removeSocket) {
        String ioHandlerKey;
        block16: {
            block15: {
                this.isRunning = false;
                if (this.mySock != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Closing socket " + this.key);
                    }
                    try {
                        this.mySock.close();
                        this.mySock = null;
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggingEnabled(32)) break block15;
                        logger.logDebug("Error closing socket " + ex);
                    }
                }
            }
            if (this.myParser != null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Closing my parser " + this.myParser);
                }
                this.myParser.close();
            }
            if (this.myClientOutputStream != null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Closing client output stream " + this.myClientOutputStream);
                }
                try {
                    this.myClientOutputStream.close();
                }
                catch (IOException ex) {
                    if (!logger.isLoggingEnabled(32)) break block16;
                    logger.logDebug("Error closing client output stream" + ex);
                }
            }
        }
        if (removeSocket) {
            ioHandlerKey = this.key.substring(4);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing TCP socket " + ioHandlerKey);
            }
            this.sipStack.ioHandler.removeSocket(ioHandlerKey);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing message Channel " + this);
            }
        } else if (logger.isLoggingEnabled(32)) {
            ioHandlerKey = this.key.substring(4);
            logger.logDebug("not removing socket key from the cached map since it has already been updated by the iohandler.sendBytes " + ioHandlerKey);
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "TCP";
    }

    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    private void sendMessage(byte[] msg, boolean isClient) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage isClient  = " + isClient);
        }
        Socket sock = null;
        IOException problem = null;
        try {
            if (this.myClientInputStream == null) {
                v2Logger.info("In sendMessage 1 clientinputstream is null for {}", (Object)this.getPeerHostPort());
            }
            sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), this.peerAddress, this.peerPort, this.peerProtocol, msg, isClient, (MessageChannel)this);
        }
        catch (IOException any) {
            problem = any;
            logger.logWarning("Failed to connect " + this.peerAddress + ":" + this.peerPort + " but trying the advertised port=" + this.peerPortAdvertisedInHeaders + " if it's different than the port we just failed on");
        }
        if (sock == null) {
            if (this.peerPort != this.peerPortAdvertisedInHeaders && this.peerPortAdvertisedInHeaders > 0) {
                logger.logWarning("Couldn't connect to peerAddress = " + this.peerAddress + " peerPort = " + this.peerPort + " key = " + this.key + " retrying on peerPortAdvertisedInHeaders " + this.peerPortAdvertisedInHeaders);
                sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), this.peerAddress, this.peerPortAdvertisedInHeaders, this.peerProtocol, msg, isClient, (MessageChannel)this);
                this.peerPort = this.peerPortAdvertisedInHeaders;
                this.key = MessageChannel.getKey((InetAddress)this.peerAddress, (int)this.peerPort, (String)"TCP");
                logger.logWarning("retry suceeded to peerAddress = " + this.peerAddress + " peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " key = " + this.key);
            } else {
                throw problem;
            }
        }
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null && logger.isLoggingEnabled(32)) {
                logger.logDebug("Old socket different than new socket");
                logger.logStackTrace();
                logger.logDebug("Old socket local ip address " + this.mySock.getLocalSocketAddress());
                logger.logDebug("Old socket remote ip address " + this.mySock.getRemoteSocketAddress());
                logger.logDebug("New socket local ip address " + sock.getLocalSocketAddress());
                logger.logDebug("New socket remote ip address " + sock.getRemoteSocketAddress());
            }
            this.close(false);
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread thread = new Thread((Runnable)this);
            thread.setDaemon(true);
            thread.setName("TCPMessageChannelThread");
            thread.start();
        }
    }

    public void sendMessage(SIPMessage sipMessage) throws IOException {
        SIPResponse sipResponse;
        Via via;
        if (logger.isLoggingEnabled(32) && !sipMessage.isNullRequest()) {
            logger.logDebug("sendMessage:: " + sipMessage.getFirstLine() + " cseq method = " + sipMessage.getCSeq().getMethod());
        }
        for (MessageProcessor messageProcessor : this.getSIPStack().getMessageProcessors()) {
            if (!messageProcessor.getIpAddress().getHostAddress().equals(this.getPeerAddress()) || messageProcessor.getPort() != this.getPeerPort() || !messageProcessor.getTransport().equalsIgnoreCase(this.getPeerProtocol())) continue;
            1 processMessageTask = new /* Unavailable Anonymous Inner Class!! */;
            this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute((Runnable)processMessageTask);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Self routing message");
            }
            return;
        }
        byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
        long time = System.currentTimeMillis();
        if (this.peerPortAdvertisedInHeaders <= 0 && sipMessage instanceof SIPResponse && (via = (sipResponse = (SIPResponse)sipMessage).getTopmostVia()).getRPort() > 0) {
            this.peerPortAdvertisedInHeaders = via.getPort() <= 0 ? 5060 : via.getPort();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("1.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for via port = " + via.getPort() + " via rport = " + via.getRPort() + " and peer port = " + this.peerPort + " for this channel " + this + " key " + this.key);
            }
        }
        this.sendMessage(msg, sipMessage instanceof SIPRequest);
        sipMessage.setRemoteAddress(this.peerAddress);
        sipMessage.setRemotePort(this.peerPort);
        sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        sipMessage.setLocalPort(this.getPort());
        if (logger.isLoggingEnabled(16)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (this.peerPortAdvertisedInHeaders <= 0) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("receiver port = " + receiverPort + " for this channel " + this + " key " + this.key);
            }
            this.peerPortAdvertisedInHeaders = receiverPort <= 0 ? 5060 : receiverPort;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("2.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
            }
        }
        Socket sock = null;
        IOException problem = null;
        try {
            if (this.myClientInputStream == null) {
                v2Logger.info("In sendMessage 2 clientinputstream is null for {}", (Object)this.getPeerHostPort());
            }
            sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, receiverPort, "TCP", message, retry, (MessageChannel)this);
        }
        catch (IOException any) {
            problem = any;
            logger.logWarning("Failed to connect " + this.peerAddress + ":" + receiverPort + " but trying the advertised port=" + this.peerPortAdvertisedInHeaders + " if it's different than the port we just failed on");
            logger.logError("Error is ", (Exception)any);
        }
        if (sock == null) {
            if (receiverPort != this.peerPortAdvertisedInHeaders && this.peerPortAdvertisedInHeaders > 0) {
                this.sipStack.getStackLogger().logWarning("Couldn't connect to receiverAddress = " + receiverAddress + " receiverPort = " + receiverPort + " key = " + this.key + " retrying on peerPortAdvertisedInHeaders " + this.peerPortAdvertisedInHeaders);
                sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, this.peerPortAdvertisedInHeaders, "TCP", message, retry, (MessageChannel)this);
                this.peerPort = this.peerPortAdvertisedInHeaders;
                this.key = MessageChannel.getKey((InetAddress)this.peerAddress, (int)this.peerPortAdvertisedInHeaders, (String)"TCP");
                this.sipStack.getStackLogger().logWarning("retry suceeded to receiverAddress = " + receiverAddress + " peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " key = " + this.key);
            } else {
                throw problem;
            }
        }
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Old socket different than new socket");
                    logger.logStackTrace();
                    logger.logDebug("Old socket local ip address " + this.mySock.getLocalSocketAddress());
                    logger.logDebug("Old socket remote ip address " + this.mySock.getRemoteSocketAddress());
                    logger.logDebug("New socket local ip address " + sock.getLocalSocketAddress());
                    logger.logDebug("New socket remote ip address " + sock.getRemoteSocketAddress());
                }
                this.sipStack.getTimer().schedule((SIPStackTimerTask)new /* Unavailable Anonymous Inner Class!! */, 8000L);
            }
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread mythread = new Thread((Runnable)this);
            mythread.setDaemon(true);
            mythread.setName("TCPMessageChannelThread");
            mythread.start();
        }
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (logger.isLoggingEnabled()) {
            logger.logException((Throwable)ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(ContentLength.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            block7: {
                String msgString;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Encountered Bad Message \n" + sipMessage.toString());
                }
                if (!(msgString = sipMessage.toString()).startsWith("SIP/") && !msgString.startsWith("ACK ") && this.mySock != null) {
                    if (logger.isLoggingEnabled(4)) {
                        logger.logError("Malformed mandatory headers: closing socket! :" + this.mySock.toString());
                    }
                    try {
                        this.mySock.close();
                    }
                    catch (IOException ie) {
                        if (!logger.isLoggingEnabled(4)) break block7;
                        logger.logError("Exception while closing socket! :" + this.mySock.toString() + ":" + ie.toString());
                    }
                }
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public void processMessage(SIPMessage sipMessage, InetAddress address) {
        block2: {
            this.peerAddress = address;
            try {
                this.processMessage(sipMessage);
            }
            catch (Exception e) {
                if (!logger.isLoggingEnabled(4)) break block2;
                logger.logError("ERROR processing self routing", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(SIPMessage sipMessage) throws Exception {
        if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
            String badmsg = sipMessage.encode();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(">>> Dropped Bad Msg");
                logger.logDebug(badmsg);
            }
            return;
        }
        sipMessage.setRemoteAddress(this.peerAddress);
        sipMessage.setRemotePort(this.getPeerPort());
        sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        sipMessage.setLocalPort(this.getPort());
        ViaList viaList = sipMessage.getViaHeaders();
        if (sipMessage instanceof SIPRequest) {
            Via v = (Via)viaList.getFirst();
            Hop hop = this.sipStack.addressResolver.resolveAddress(v.getHop());
            this.peerProtocol = v.getTransport();
            if (this.peerPortAdvertisedInHeaders <= 0) {
                int hopPort = v.getPort();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("hop port = " + hopPort + " for request " + sipMessage + " for this channel " + this + " key " + this.key);
                }
                this.peerPortAdvertisedInHeaders = hopPort <= 0 ? 5060 : hopPort;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("3.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
                }
            }
            try {
                if (this.mySock != null) {
                    this.peerAddress = this.mySock.getInetAddress();
                }
                if (v.hasParameter("rport") || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                    v.setParameter("received", this.peerAddress.getHostAddress());
                }
                v.setParameter("rport", Integer.toString(this.peerPort));
            }
            catch (ParseException ex) {
                InternalErrorHandler.handleException((Exception)ex, (StackLogger)logger);
            }
            if (!this.isCached && this.mySock != null) {
                this.isCached = true;
                int remotePort = ((InetSocketAddress)this.mySock.getRemoteSocketAddress()).getPort();
                String key = IOHandler.makeKey((InetAddress)this.mySock.getInetAddress(), (int)remotePort);
                this.sipStack.ioHandler.putSocket(key, this.mySock);
                ((TCPMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
            }
        }
        long receptionTime = System.currentTimeMillis();
        if (sipMessage instanceof SIPRequest) {
            String cseqMethod;
            SIPRequest sipRequest = (SIPRequest)sipMessage;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("----Processing Message---");
            }
            if (logger.isLoggingEnabled(16)) {
                this.sipStack.serverLogger.logMessage(sipMessage, this.getPeerHostPort().toString(), this.getMessageProcessor().getIpAddress().getHostAddress() + ":" + this.getMessageProcessor().getPort(), false, receptionTime);
            }
            if (this.sipStack.getMaxMessageSize() > 0 && sipRequest.getSize() + (sipRequest.getContentLength() == null ? 0 : sipRequest.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                SIPResponse sipResponse = sipRequest.createResponse(513);
                byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                this.sendMessage(resp, false);
                throw new Exception("Message size exceeded");
            }
            String sipVersion = ((SIPRequest)sipMessage).getRequestLine().getSipVersion();
            if (!sipVersion.equals("SIP/2.0")) {
                SIPResponse versionNotSupported = ((SIPRequest)sipMessage).createResponse(505, "Bad version " + sipVersion);
                this.sendMessage(versionNotSupported.encodeAsBytes(this.getTransport()), false);
                throw new Exception("Bad sip version");
            }
            String method = ((SIPRequest)sipMessage).getMethod();
            if (!method.equalsIgnoreCase(cseqMethod = ((SIPRequest)sipMessage).getCSeqHeader().getMethod())) {
                SIPResponse sipResponse = sipRequest.createResponse(400);
                byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                this.sendMessage(resp, false);
                throw new Exception("Bad CSeq method");
            }
            ServerRequestInterface sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, (MessageChannel)this);
            if (sipServerRequest != null) {
                try {
                    sipServerRequest.processRequest(sipRequest, (MessageChannel)this);
                }
                finally {
                    SIPServerTransaction sipServerTx;
                    if (sipServerRequest instanceof SIPTransaction && !(sipServerTx = (SIPServerTransaction)sipServerRequest).passToListener()) {
                        ((SIPTransaction)sipServerRequest).releaseSem();
                    }
                }
            } else if (logger.isLoggingEnabled()) {
                logger.logWarning("Dropping request -- could not acquire semaphore in 10 sec");
            }
        } else {
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            try {
                sipResponse.checkHeaders();
            }
            catch (ParseException ex) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("Dropping Badly formatted response message >>> " + sipResponse);
                }
                return;
            }
            if (this.sipStack.getMaxMessageSize() > 0 && sipResponse.getSize() + (sipResponse.getContentLength() == null ? 0 : sipResponse.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Message size exceeded");
                }
                return;
            }
            ServerResponseInterface sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, (MessageChannel)this);
            if (sipServerResponse != null) {
                try {
                    if (sipServerResponse instanceof SIPClientTransaction && !((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) {
                        if (logger.isLoggingEnabled()) {
                            logger.logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        return;
                    }
                    sipServerResponse.processResponse(sipResponse, (MessageChannel)this);
                }
                finally {
                    if (sipServerResponse instanceof SIPTransaction && !((SIPTransaction)sipServerResponse).passToListener()) {
                        ((SIPTransaction)sipServerResponse).releaseSem();
                    }
                }
            } else {
                logger.logWarning("Application is blocked -- could not acquire semaphore -- dropping response");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        hispipe = null;
        hispipe = new Pipeline(this.myClientInputStream, this.sipStack.readTimeout, this.sipStack.getTimer());
        this.myParser = new PipelinedMsgParser(this.sipStack, (SIPMessageListener)this, hispipe, this.sipStack.getMaxMessageSize());
        this.myParser.processInput();
        bufferSize = 4096;
        ++this.tcpMessageProcessor.useCount;
        this.isRunning = true;
        while (true) lbl-1000:
        // 3 sources

        {
            if ((nbytes = this.myClientInputStream.read(msg = new byte[bufferSize], 0, bufferSize)) == -1) {
                hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                try {
                    if (this.sipStack.maxConnections != -1) {
                        var5_11 = this.tcpMessageProcessor;
                        synchronized (var5_11) {
                            --this.tcpMessageProcessor.nConnections;
                            this.tcpMessageProcessor.notify();
                        }
                    }
                    hispipe.close();
                    this.close();
                }
                catch (IOException var5_12) {
                    // empty catch block
                }
                return;
            }
            try {
                hispipe.write(msg, 0, nbytes);
            }
            catch (IOException ex) {
                try {
                    hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                }
                catch (Exception var4_7) {
                    // empty catch block
                }
                try {
                    if (TCPMessageChannel.logger.isLoggingEnabled(32)) {
                        TCPMessageChannel.logger.logDebug("IOException  closing sock " + ex);
                    }
                    try {
                        if (this.sipStack.maxConnections != -1) {
                            var4_8 = this.tcpMessageProcessor;
                            synchronized (var4_8) {
                                --this.tcpMessageProcessor.nConnections;
                                this.tcpMessageProcessor.notify();
                            }
                        }
                        this.close();
                        hispipe.close();
                    }
                    catch (IOException var4_9) {
                    }
                }
                catch (Exception var4_10) {
                    // empty catch block
                }
                return;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException((Exception)ex, (StackLogger)TCPMessageChannel.logger);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.isRunning = false;
            this.tcpMessageProcessor.remove(this);
            --this.tcpMessageProcessor.useCount;
            if (this.myParser != null) {
                this.myParser.close();
            }
        }
    }

    protected void uncache() {
        if (this.isCached && !this.isRunning) {
            this.tcpMessageProcessor.remove(this);
        }
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TCPMessageChannel that = (TCPMessageChannel)other;
        return this.mySock == that.mySock;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey((InetAddress)this.peerAddress, (int)this.peerPort, (String)"TCP");
        return this.key;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerAddress;
    }

    public boolean isSecure() {
        return false;
    }

    public void sendSingleCLRF() throws Exception {
        if (this.mySock != null && !this.mySock.isClosed()) {
            this.mySock.getOutputStream().write("\r\n".getBytes("UTF-8"));
        }
    }

    static /* synthetic */ StackLogger access$000() {
        return logger;
    }
}

