/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.StackLogger;
import com.coraltele.interfaces.sip.Dialog;
import com.coraltele.interfaces.sip.IOExceptionEvent;
import com.coraltele.interfaces.sip.Transaction;
import com.coraltele.interfaces.sip.TransactionState;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.SipProviderImpl;
import com.coraltele.javax.sip.TransactionExt;
import com.coraltele.javax.sip.address.AddressFactoryImpl;
import com.coraltele.javax.sip.header.Via;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.MessageProcessor;
import com.coraltele.javax.sip.stack.RawMessageChannel;
import com.coraltele.javax.sip.stack.SIPClientTransaction;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.javax.sip.stack.SIPServerTransaction;
import com.coraltele.javax.sip.stack.SIPTransaction;
import com.coraltele.javax.sip.stack.SIPTransactionErrorEvent;
import com.coraltele.javax.sip.stack.SIPTransactionEventListener;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import com.coraltele.javax.sip.stack.TCPMessageChannel;
import com.coraltele.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;

public abstract class SIPTransaction
extends MessageChannel
implements Transaction,
TransactionExt {
    private static StackLogger logger = CommonLogger.getLogger(SIPTransaction.class);
    protected boolean toListener;
    protected int BASE_TIMER_INTERVAL = 500;
    protected int T4 = 5000 / this.BASE_TIMER_INTERVAL;
    protected int T2 = 4000 / this.BASE_TIMER_INTERVAL;
    protected int TIMER_I = this.T4;
    protected int TIMER_K = this.T4;
    protected int TIMER_D = 32000 / this.BASE_TIMER_INTERVAL;
    protected static final int T1 = 1;
    protected static final int TIMER_A = 1;
    protected static final int TIMER_B = 64;
    protected static final int TIMER_J = 64;
    protected static final int TIMER_F = 64;
    protected static final int TIMER_H = 64;
    protected transient Object applicationData;
    protected SIPResponse lastResponse;
    protected boolean isMapped;
    private TransactionSemaphore semaphore;
    protected String transactionId;
    public long auditTag = 0L;
    public static final TransactionState INITIAL_STATE = null;
    public static final TransactionState TRYING_STATE = TransactionState.TRYING;
    public static final TransactionState CALLING_STATE = TransactionState.CALLING;
    public static final TransactionState PROCEEDING_STATE = TransactionState.PROCEEDING;
    public static final TransactionState COMPLETED_STATE = TransactionState.COMPLETED;
    public static final TransactionState CONFIRMED_STATE = TransactionState.CONFIRMED;
    public static final TransactionState TERMINATED_STATE = TransactionState.TERMINATED;
    protected static final int MAXIMUM_RETRANSMISSION_TICK_COUNT = 8;
    protected transient SIPTransactionStack sipStack;
    protected SIPRequest originalRequest;
    protected byte[] originalRequestBytes;
    protected long originalRequestCSeqNumber;
    protected String originalRequestBranch;
    protected boolean originalRequestHasPort;
    private transient MessageChannel encapsulatedChannel;
    protected AtomicBoolean transactionTimerStarted = new AtomicBoolean(false);
    private String branch;
    private String method;
    private int currentState = -1;
    private transient int retransmissionTimerLastTickCount;
    private transient int retransmissionTimerTicksLeft;
    protected int timeoutTimerTicksLeft;
    private transient Set<SIPTransactionEventListener> eventListeners;
    protected int collectionTime;
    private boolean terminatedEventDelivered;
    private boolean releaseReferences;
    private Boolean inviteTransaction = null;
    private Boolean dialogCreatingTransaction = null;
    private String forkId = null;
    public SIPClientTransaction.ExpiresTimerTask expiresTimerTask;

    public String getBranchId() {
        return this.branch;
    }

    protected SIPTransaction(SIPTransactionStack newParentStack, MessageChannel newEncapsulatedChannel) {
        this.sipStack = newParentStack;
        this.semaphore = new TransactionSemaphore(this);
        this.encapsulatedChannel = newEncapsulatedChannel;
        if (this.isReliable()) {
            ++this.encapsulatedChannel.useCount;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("use count for encapsulated channel" + this + " " + this.encapsulatedChannel.useCount);
            }
        }
        this.currentState = -1;
        this.disableRetransmissionTimer();
        this.disableTimeoutTimer();
        this.eventListeners = new CopyOnWriteArraySet();
        this.addEventListener((SIPTransactionEventListener)newParentStack);
        this.releaseReferences = this.sipStack.isAggressiveCleanup();
    }

    public abstract void cleanUp();

    public void setOriginalRequest(SIPRequest newOriginalRequest) {
        String newTransactionId = newOriginalRequest.getTransactionId();
        if (this.originalRequest != null && !this.originalRequest.getTransactionId().equals(newTransactionId)) {
            this.sipStack.removeTransactionHash(this);
        }
        this.originalRequest = newOriginalRequest;
        this.originalRequestCSeqNumber = newOriginalRequest.getCSeq().getSeqNumber();
        Via topmostVia = newOriginalRequest.getTopmostVia();
        this.originalRequestBranch = topmostVia.getBranch();
        this.originalRequestHasPort = topmostVia.hasPort();
        int originalRequestViaPort = topmostVia.getPort();
        if (originalRequestViaPort == -1) {
            originalRequestViaPort = topmostVia.getTransport().equalsIgnoreCase("TLS") ? 5061 : 5060;
        }
        this.method = newOriginalRequest.getMethod();
        this.transactionId = newTransactionId;
        this.originalRequest.setTransaction((Object)this);
        String newBranch = topmostVia.getBranch();
        if (newBranch != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Setting Branch id : " + newBranch);
            }
            this.setBranch(newBranch);
        } else {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Branch id is null - compute TID!" + newOriginalRequest.encode());
            }
            this.setBranch(newTransactionId);
        }
    }

    public SIPRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public Request getRequest() {
        if (this.isReleaseReferences() && this.originalRequest == null && this.originalRequestBytes != null) {
            if (logger.isLoggingEnabled(8)) {
                logger.logWarning("reparsing original request " + this.originalRequestBytes + " since it was eagerly cleaned up, but beware this is not efficient with the aggressive flag set !");
            }
            try {
                this.originalRequest = (SIPRequest)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.originalRequestBytes, true, false, null);
            }
            catch (ParseException e) {
                logger.logError("message " + this.originalRequestBytes + " could not be reparsed !");
            }
        }
        return this.originalRequest;
    }

    public final boolean isDialogCreatingTransaction() {
        if (this.dialogCreatingTransaction == null) {
            this.dialogCreatingTransaction = this.isInviteTransaction() || this.getMethod().equals("SUBSCRIBE") || this.getMethod().equals("REFER");
        }
        return this.dialogCreatingTransaction;
    }

    public final boolean isInviteTransaction() {
        if (this.inviteTransaction == null) {
            this.inviteTransaction = this.getMethod().equals("INVITE");
        }
        return this.inviteTransaction;
    }

    public final boolean isCancelTransaction() {
        return this.getMethod().equals("CANCEL");
    }

    public final boolean isByeTransaction() {
        return this.getMethod().equals("BYE");
    }

    public MessageChannel getMessageChannel() {
        return this.encapsulatedChannel;
    }

    public final void setBranch(String newBranch) {
        this.branch = newBranch;
    }

    public final String getBranch() {
        if (this.branch == null) {
            this.branch = this.originalRequestBranch;
        }
        return this.branch;
    }

    public final String getMethod() {
        return this.method;
    }

    public final long getCSeq() {
        return this.originalRequestCSeqNumber;
    }

    public void setState(int newState) {
        if (this.currentState == 3 && newState != 5 && newState != 4) {
            newState = 3;
        }
        if (this.currentState == 4 && newState != 5) {
            newState = 4;
        }
        if (this.currentState != 5) {
            this.currentState = newState;
        } else {
            newState = this.currentState;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Transaction:setState " + newState + " " + this + " branchID = " + this.getBranch() + " isClient = " + (this instanceof SIPClientTransaction));
            logger.logStackTrace();
        }
    }

    public int getInternalState() {
        return this.currentState;
    }

    public TransactionState getState() {
        if (this.currentState < 0) {
            return null;
        }
        return TransactionState.getObject((int)this.currentState);
    }

    protected final void enableRetransmissionTimer() {
        this.enableRetransmissionTimer(1);
    }

    protected final void enableRetransmissionTimer(int tickCount) {
        this.retransmissionTimerTicksLeft = this.isInviteTransaction() && this instanceof SIPClientTransaction ? tickCount : Math.min(tickCount, 8);
        this.retransmissionTimerLastTickCount = this.retransmissionTimerTicksLeft;
    }

    protected final void disableRetransmissionTimer() {
        this.retransmissionTimerTicksLeft = -1;
    }

    protected final void enableTimeoutTimer(int tickCount) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("enableTimeoutTimer " + this + " tickCount " + tickCount + " currentTickCount = " + this.timeoutTimerTicksLeft);
        }
        this.timeoutTimerTicksLeft = tickCount;
    }

    protected final void disableTimeoutTimer() {
        this.timeoutTimerTicksLeft = -1;
    }

    final void fireTimer() {
        if (this.timeoutTimerTicksLeft != -1 && --this.timeoutTimerTicksLeft == 0) {
            this.fireTimeoutTimer();
        }
        if (this.retransmissionTimerTicksLeft != -1 && --this.retransmissionTimerTicksLeft == 0) {
            this.enableRetransmissionTimer(this.retransmissionTimerLastTickCount * 2);
            this.fireRetransmissionTimer();
        }
    }

    public final boolean isTerminated() {
        return this.currentState == 5;
    }

    public String getHost() {
        return this.encapsulatedChannel.getHost();
    }

    public String getKey() {
        return this.encapsulatedChannel.getKey();
    }

    public int getPort() {
        return this.encapsulatedChannel.getPort();
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getPeerAddress() {
        return this.encapsulatedChannel.getPeerAddress();
    }

    public int getPeerPort() {
        return this.encapsulatedChannel.getPeerPort();
    }

    public int getPeerPacketSourcePort() {
        return this.encapsulatedChannel.getPeerPacketSourcePort();
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.encapsulatedChannel.getPeerPacketSourceAddress();
    }

    protected InetAddress getPeerInetAddress() {
        return this.encapsulatedChannel.getPeerInetAddress();
    }

    protected String getPeerProtocol() {
        return this.encapsulatedChannel.getPeerProtocol();
    }

    public String getTransport() {
        return this.encapsulatedChannel.getTransport();
    }

    public boolean isReliable() {
        return this.encapsulatedChannel.isReliable();
    }

    public Via getViaHeader() {
        Via channelViaHeader = super.getViaHeader();
        try {
            channelViaHeader.setBranch(this.branch);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return channelViaHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(SIPMessage messageToSend) throws IOException {
        try {
            RawMessageChannel channel = (RawMessageChannel)this.encapsulatedChannel;
            for (MessageProcessor messageProcessor : this.sipStack.getMessageProcessors()) {
                boolean addrmatch = messageProcessor.getIpAddress().getHostAddress().toString().equals(this.getPeerAddress());
                if (!addrmatch || messageProcessor.getPort() != this.getPeerPort() || !messageProcessor.getTransport().equalsIgnoreCase(this.getPeerProtocol())) continue;
                if (channel instanceof TCPMessageChannel) {
                    try {
                        1 processMessageTask = new /* Unavailable Anonymous Inner Class!! */;
                        this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute((Runnable)processMessageTask);
                    }
                    catch (Exception e) {
                        logger.logError("Error passing message in self routing TCP", e);
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Self routing message TCP");
                    }
                    return;
                }
                if (channel instanceof TLSMessageChannel) {
                    try {
                        2 processMessageTask = new /* Unavailable Anonymous Inner Class!! */;
                        this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute((Runnable)processMessageTask);
                    }
                    catch (Exception e) {
                        logger.logError("Error passing message in TLS self routing", e);
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Self routing message TLS");
                    }
                    return;
                }
                if (!(channel instanceof RawMessageChannel)) continue;
                try {
                    3 processMessageTask = new /* Unavailable Anonymous Inner Class!! */;
                    this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute((Runnable)processMessageTask);
                }
                catch (Exception e) {
                    logger.logError("Error passing message in self routing", e);
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Self routing message");
                }
                return;
            }
            this.encapsulatedChannel.sendMessage(messageToSend, this.getPeerInetAddress(), this.getPeerPort());
        }
        finally {
            this.startTransactionTimer();
        }
    }

    protected void sendMessage(byte[] messageBytes, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        throw new IOException("Cannot send unparsed message through Transaction Channel!");
    }

    public void addEventListener(SIPTransactionEventListener newListener) {
        this.eventListeners.add(newListener);
    }

    public void removeEventListener(SIPTransactionEventListener oldListener) {
        this.eventListeners.remove(oldListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseErrorEvent(int errorEventID) {
        SIPTransactionErrorEvent newErrorEvent = new SIPTransactionErrorEvent(this, errorEventID);
        Set set = this.eventListeners;
        synchronized (set) {
            for (SIPTransactionEventListener nextListener : this.eventListeners) {
                nextListener.transactionErrorEvent(newErrorEvent);
            }
        }
        if (errorEventID != 3) {
            this.eventListeners.clear();
            this.setState(5);
            if (this instanceof SIPServerTransaction && this.isByeTransaction() && this.getDialog() != null) {
                ((SIPDialog)this.getDialog()).setState(3);
            }
        }
    }

    protected boolean isServerTransaction() {
        return this instanceof SIPServerTransaction;
    }

    public abstract Dialog getDialog();

    public abstract void setDialog(SIPDialog var1, String var2);

    public int getRetransmitTimer() {
        return 500;
    }

    public String getViaHost() {
        return this.getViaHeader().getHost();
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public Response getResponse() {
        return this.lastResponse;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public int hashCode() {
        if (this.transactionId == null) {
            return -1;
        }
        return this.transactionId.hashCode();
    }

    public int getViaPort() {
        return this.getViaHeader().getPort();
    }

    public boolean doesCancelMatchTransaction(SIPRequest requestToTest) {
        boolean transactionMatches = false;
        SIPRequest origRequest = this.getOriginalRequest();
        if (origRequest == null || this.getMethod().equals("CANCEL")) {
            return false;
        }
        Via topViaHeader = requestToTest.getTopmostVia();
        if (topViaHeader != null) {
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.toLowerCase().startsWith("z9hg4bk")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                if (this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals((Object)origRequest.getTopmostVia().getSentBy())) {
                    transactionMatches = true;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("returning  true");
                    }
                }
            } else {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("testing against " + origRequest);
                }
                if (origRequest.getRequestURI().equals(requestToTest.getRequestURI()) && origRequest.getTo().equals((Object)requestToTest.getTo()) && origRequest.getFrom().equals((Object)requestToTest.getFrom()) && origRequest.getCallId().getCallId().equals(requestToTest.getCallId().getCallId()) && origRequest.getCSeq().getSeqNumber() == requestToTest.getCSeq().getSeqNumber() && topViaHeader.equals((Object)origRequest.getTopmostVia())) {
                    transactionMatches = true;
                }
            }
        }
        if (transactionMatches) {
            this.setPassToListener();
        }
        return transactionMatches;
    }

    public void setRetransmitTimer(int retransmitTimer) {
        if (retransmitTimer <= 0) {
            throw new IllegalArgumentException("Retransmit timer must be positive!");
        }
        if (this.transactionTimerStarted.get()) {
            throw new IllegalStateException("Transaction timer is already started");
        }
        this.BASE_TIMER_INTERVAL = retransmitTimer;
    }

    public void close() {
        this.encapsulatedChannel.close();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Closing " + this.encapsulatedChannel);
        }
    }

    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    public MessageProcessor getMessageProcessor() {
        return this.encapsulatedChannel.getMessageProcessor();
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void setEncapsulatedChannel(MessageChannel messageChannel) {
        this.encapsulatedChannel = messageChannel;
        if (this instanceof SIPClientTransaction) {
            this.encapsulatedChannel.setEncapsulatedClientTransaction((SIPClientTransaction)this);
        }
    }

    public SipProviderImpl getSipProvider() {
        return this.getMessageProcessor().getListeningPoint().getProvider();
    }

    public void raiseIOExceptionEvent() {
        this.setState(5);
        String host = this.getPeerAddress();
        int port = this.getPeerPort();
        String transport = this.getTransport();
        IOExceptionEvent exceptionEvent = new IOExceptionEvent((Object)this, host, port, transport);
        this.getSipProvider().handleEvent((EventObject)exceptionEvent, this);
    }

    public boolean acquireSem() {
        boolean retval = false;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("acquireSem [[[[" + this);
            logger.logStackTrace();
        }
        retval = this.sipStack.maxListenerResponseTime == -1 ? this.semaphore.acquire() : this.semaphore.tryAcquire();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("acquireSem() returning : " + retval);
        }
        return retval;
    }

    public void releaseSem() {
        try {
            this.toListener = false;
            this.semRelease();
        }
        catch (Exception ex) {
            logger.logError("Unexpected exception releasing sem", ex);
        }
    }

    protected void semRelease() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("semRelease ]]]]" + this);
            logger.logStackTrace();
        }
        this.semaphore.release();
    }

    public boolean passToListener() {
        return this.toListener;
    }

    public void setPassToListener() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setPassToListener()");
        }
        this.toListener = true;
    }

    protected synchronized boolean testAndSetTransactionTerminatedEvent() {
        boolean retval = !this.terminatedEventDelivered;
        this.terminatedEventDelivered = true;
        return retval;
    }

    public String getCipherSuite() throws UnsupportedOperationException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent() == null) {
                return null;
            }
            return ((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent().getCipherSuite();
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    public Certificate[] getLocalCertificates() throws UnsupportedOperationException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent() == null) {
                return null;
            }
            return ((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent().getLocalCertificates();
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent() == null) {
                return null;
            }
            return ((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent().getPeerCertificates();
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    public List<String> extractCertIdentities() throws SSLPeerUnverifiedException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            ArrayList<String> certIdentities = new ArrayList<String>();
            Certificate[] certs = this.getPeerCertificates();
            if (certs == null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("No certificates available");
                }
                return certIdentities;
            }
            for (Certificate cert : certs) {
                Collection<List<?>> subjAltNames;
                X509Certificate x509cert;
                block17: {
                    x509cert = (X509Certificate)cert;
                    subjAltNames = null;
                    try {
                        subjAltNames = x509cert.getSubjectAlternativeNames();
                    }
                    catch (CertificateParsingException ex) {
                        if (!logger.isLoggingEnabled()) break block17;
                        logger.logError("Error parsing TLS certificate", (Exception)ex);
                    }
                }
                Integer dnsNameType = 2;
                Integer uriNameType = 6;
                if (subjAltNames != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("found subjAltNames: " + subjAltNames);
                    }
                    for (List<?> altName : subjAltNames) {
                        if (!altName.get(0).equals(uriNameType)) continue;
                        try {
                            SipURI altNameUri = new AddressFactoryImpl().createSipURI((String)altName.get(1));
                            if (!"sip".equals(altNameUri.getScheme()) || altNameUri.getUser() != null) continue;
                            String altHostName = altNameUri.getHost();
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("found uri " + altName.get(1) + ", hostName " + altHostName);
                            }
                            certIdentities.add(altHostName);
                        }
                        catch (ParseException e) {
                            if (!logger.isLoggingEnabled()) continue;
                            logger.logError("certificate contains invalid uri: " + altName.get(1));
                        }
                    }
                    if (!certIdentities.isEmpty()) continue;
                    for (List<?> altName : subjAltNames) {
                        if (!altName.get(0).equals(dnsNameType)) continue;
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("found dns " + altName.get(1));
                        }
                        certIdentities.add(altName.get(1).toString());
                    }
                    continue;
                }
                String dname = x509cert.getSubjectDN().getName();
                String cname = "";
                try {
                    Pattern EXTRACT_CN = Pattern.compile(".*CN\\s*=\\s*([\\w*\\.]+).*");
                    Matcher matcher = EXTRACT_CN.matcher(dname);
                    if (!matcher.matches()) continue;
                    cname = matcher.group(1);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("found CN: " + cname + " from DN: " + dname);
                    }
                    certIdentities.add(cname);
                }
                catch (Exception ex) {
                    if (!logger.isLoggingEnabled()) continue;
                    logger.logError("exception while extracting CN", ex);
                }
            }
            return certIdentities;
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    protected abstract void startTransactionTimer();

    public abstract boolean isMessagePartOfTransaction(SIPMessage var1);

    protected abstract void fireRetransmissionTimer();

    protected abstract void fireTimeoutTimer();

    public boolean isReleaseReferences() {
        return this.releaseReferences;
    }

    public void setReleaseReferences(boolean releaseReferences) {
        this.releaseReferences = releaseReferences;
    }

    public int getTimerD() {
        return this.TIMER_D;
    }

    public int getTimerT2() {
        return this.T2;
    }

    public int getTimerT4() {
        return this.T4;
    }

    public void setTimerD(int interval) {
        if (interval < 32000) {
            throw new IllegalArgumentException("To be RFC 3261 compliant, the value of Timer D should be at least 32s");
        }
        this.TIMER_D = interval / this.BASE_TIMER_INTERVAL;
    }

    public void setTimerT2(int interval) {
        this.T2 = interval / this.BASE_TIMER_INTERVAL;
    }

    public void setTimerT4(int interval) {
        this.TIMER_I = this.T4 = interval / this.BASE_TIMER_INTERVAL;
        this.TIMER_K = this.T4;
    }

    public void setForkId(String forkId) {
        this.forkId = forkId;
    }

    public String getForkId() {
        return this.forkId;
    }

    static /* synthetic */ StackLogger access$000() {
        return logger;
    }
}

