/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.HostPort;
import com.coraltele.core.InternalErrorHandler;
import com.coraltele.core.StackLogger;
import com.coraltele.interfaces.sip.Dialog;
import com.coraltele.interfaces.sip.DialogState;
import com.coraltele.interfaces.sip.DialogTerminatedEvent;
import com.coraltele.interfaces.sip.ObjectInUseException;
import com.coraltele.interfaces.sip.ServerTransaction;
import com.coraltele.interfaces.sip.SipException;
import com.coraltele.interfaces.sip.Timeout;
import com.coraltele.interfaces.sip.TimeoutEvent;
import com.coraltele.interfaces.sip.TransactionState;
import com.coraltele.interfaces.sip.address.Hop;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.ServerTransactionExt;
import com.coraltele.javax.sip.SipProviderImpl;
import com.coraltele.javax.sip.Utils;
import com.coraltele.javax.sip.header.ContentType;
import com.coraltele.javax.sip.header.Expires;
import com.coraltele.javax.sip.header.RSeq;
import com.coraltele.javax.sip.header.Via;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.stack.HopImpl;
import com.coraltele.javax.sip.stack.IllegalTransactionStateException;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.SIPClientTransaction;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.javax.sip.stack.SIPServerTransaction;
import com.coraltele.javax.sip.stack.SIPStackTimerTask;
import com.coraltele.javax.sip.stack.SIPTransaction;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import com.coraltele.javax.sip.stack.ServerRequestInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.EventObject;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SIPServerTransaction
extends SIPTransaction
implements ServerRequestInterface,
ServerTransaction,
ServerTransactionExt {
    private static StackLogger logger = CommonLogger.getLogger(SIPServerTransaction.class);
    public static final String CONTENT_TYPE_APPLICATION = "application";
    public static final String CONTENT_SUBTYPE_SDP = "sdp";
    private int rseqNumber = -1;
    private transient ServerRequestInterface requestOf;
    private SIPDialog dialog;
    protected String dialogId;
    private byte[] pendingReliableResponseAsBytes;
    private String pendingReliableResponseMethod;
    private long pendingReliableCSeqNumber;
    private long pendingReliableRSeqNumber;
    private ProvisionalResponseTask provisionalResponseTask;
    private boolean retransmissionAlertEnabled;
    private RetransmissionAlertTimerTask retransmissionAlertTimerTask;
    private ListenerExecutionMaxTimer listenerExecutionMaxTimer;
    protected boolean isAckSeen;
    private SIPClientTransaction pendingSubscribeTransaction;
    private SIPServerTransaction inviteTransaction;
    private static boolean interlockProvisionalResponses = true;
    private Semaphore provisionalResponseSem = new Semaphore(1);
    private Semaphore terminationSemaphore = new Semaphore(0);
    private byte[] lastResponseAsBytes;
    private String lastResponseHost;
    private int lastResponsePort;
    private String lastResponseTransport;
    private int lastResponseStatusCode;
    private HostPort originalRequestSentBy;
    private String originalRequestFromTag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(SIPResponse transactionResponse) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sipServerTransaction::sendResponse " + transactionResponse.getFirstLine());
        }
        try {
            if (this.isReliable()) {
                this.getMessageChannel().sendMessage((SIPMessage)transactionResponse);
            } else {
                Via via = transactionResponse.getTopmostVia();
                String transport = via.getTransport();
                if (transport == null) {
                    throw new IOException("missing transport!");
                }
                int port = via.getRPort();
                if (port == -1) {
                    port = via.getPort();
                }
                if (port == -1) {
                    port = transport.equalsIgnoreCase("TLS") ? 5061 : 5060;
                }
                String host = null;
                if (via.getMAddr() != null) {
                    host = via.getMAddr();
                } else {
                    host = via.getParameter("received");
                    if (host == null) {
                        host = via.getHost();
                    }
                }
                Hop hop = this.sipStack.addressResolver.resolveAddress((Hop)new HopImpl(host, port, transport));
                MessageChannel messageChannel = this.getSIPStack().createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.getPort(), hop);
                if (messageChannel != null) {
                    messageChannel.sendMessage((SIPMessage)transactionResponse);
                    this.lastResponseHost = host;
                    this.lastResponsePort = port;
                    this.lastResponseTransport = transport;
                } else {
                    throw new IOException("Could not create a message channel for " + hop + " with source IP:Port " + this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress() + ":" + this.getPort());
                }
            }
            this.lastResponseAsBytes = transactionResponse.encodeAsBytes(this.getTransport());
            this.lastResponse = null;
        }
        finally {
            this.startTransactionTimer();
        }
    }

    protected SIPServerTransaction(SIPTransactionStack sipStack, MessageChannel newChannelToUse) {
        super(sipStack, newChannelToUse);
        if (sipStack.maxListenerResponseTime != -1) {
            sipStack.getTimer().schedule((SIPStackTimerTask)new ListenerExecutionMaxTimer(this), (long)(sipStack.maxListenerResponseTime * 1000));
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Creating Server Transaction" + this.getBranchId());
            logger.logStackTrace();
        }
    }

    public void setRequestInterface(ServerRequestInterface newRequestOf) {
        this.requestOf = newRequestOf;
    }

    public MessageChannel getResponseChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        Via topViaHeader;
        boolean transactionMatches = false;
        String method = messageToTest.getCSeq().getMethod();
        SIPRequest origRequest = this.getOriginalRequest();
        if ((this.isInviteTransaction() || !this.isTerminated()) && (topViaHeader = messageToTest.getTopmostVia()) != null) {
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.toLowerCase().startsWith("z9hg4bk")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                transactionMatches = method.equals("CANCEL") ? this.getMethod().equals("CANCEL") && this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals((Object)origRequest.getTopmostVia().getSentBy()) : (origRequest != null ? this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals((Object)origRequest.getTopmostVia().getSentBy()) : this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals((Object)this.originalRequestSentBy));
            } else {
                origRequest = (SIPRequest)this.getRequest();
                String originalFromTag = origRequest.getFromTag();
                String thisFromTag = messageToTest.getFrom().getTag();
                boolean skipFrom = originalFromTag == null || thisFromTag == null;
                String originalToTag = origRequest.getToTag();
                String thisToTag = messageToTest.getTo().getTag();
                boolean skipTo = originalToTag == null || thisToTag == null;
                boolean isResponse = messageToTest instanceof SIPResponse;
                if (messageToTest.getCSeq().getMethod().equalsIgnoreCase("CANCEL") && !origRequest.getCSeq().getMethod().equalsIgnoreCase("CANCEL")) {
                    transactionMatches = false;
                } else if ((isResponse || origRequest.getRequestURI().equals(((SIPRequest)messageToTest).getRequestURI())) && (skipFrom || originalFromTag != null && originalFromTag.equalsIgnoreCase(thisFromTag)) && (skipTo || originalToTag != null && originalToTag.equalsIgnoreCase(thisToTag)) && origRequest.getCallId().getCallId().equalsIgnoreCase(messageToTest.getCallId().getCallId()) && origRequest.getCSeq().getSeqNumber() == messageToTest.getCSeq().getSeqNumber() && (!messageToTest.getCSeq().getMethod().equals("CANCEL") || this.getMethod().equals(messageToTest.getCSeq().getMethod())) && topViaHeader.equals((Object)origRequest.getTopmostVia())) {
                    transactionMatches = true;
                }
            }
        }
        return transactionMatches;
    }

    protected void map() {
        int realState = this.getRealState();
        if (realState < 0 || realState == 1) {
            if (this.isInviteTransaction() && !this.isMapped && this.sipStack.getTimer() != null) {
                this.isMapped = true;
                this.sipStack.getTimer().schedule((SIPStackTimerTask)new SendTrying(this), 200L);
            } else {
                this.isMapped = true;
            }
        }
        this.sipStack.removePendingTransaction(this);
    }

    public boolean isTransactionMapped() {
        return this.isMapped;
    }

    public void processRequest(SIPRequest transactionRequest, MessageChannel sourceChannel) {
        block37: {
            boolean toTu = false;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("processRequest: " + transactionRequest.getFirstLine());
                logger.logDebug("tx state = " + this.getRealState());
            }
            try {
                if (this.getRealState() < 0) {
                    this.setOriginalRequest(transactionRequest);
                    this.setState(1);
                    toTu = true;
                    this.setPassToListener();
                    if (this.isInviteTransaction() && this.isMapped) {
                        this.sendMessage((SIPMessage)transactionRequest.createResponse(100, "Trying"));
                    }
                } else {
                    if (this.isInviteTransaction() && 3 == this.getRealState() && transactionRequest.getMethod().equals("ACK")) {
                        this.setState(4);
                        this.disableRetransmissionTimer();
                        if (!this.isReliable()) {
                            this.enableTimeoutTimer(this.TIMER_I);
                        } else {
                            this.setState(5);
                        }
                        if (this.sipStack.isNon2XXAckPassedToListener()) {
                            this.requestOf.processRequest(transactionRequest, (MessageChannel)this);
                        } else {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("ACK received for server Tx " + this.getTransactionId() + " not delivering to application!");
                            }
                            this.semRelease();
                        }
                        return;
                    }
                    if (transactionRequest.getMethod().equals(this.getMethod())) {
                        if (2 == this.getRealState() || 3 == this.getRealState()) {
                            this.semRelease();
                            this.resendLastResponseAsBytes();
                        } else if (transactionRequest.getMethod().equals("ACK")) {
                            if (this.requestOf != null) {
                                this.requestOf.processRequest(transactionRequest, (MessageChannel)this);
                            } else {
                                this.semRelease();
                            }
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("completed processing retransmitted request : " + transactionRequest.getFirstLine() + this + " txState = " + this.getState() + " lastResponse = " + this.lastResponseAsBytes);
                        }
                        return;
                    }
                }
                if (3 != this.getRealState() && 5 != this.getRealState() && this.requestOf != null) {
                    if (this.getMethod().equals(transactionRequest.getMethod())) {
                        if (toTu) {
                            this.requestOf.processRequest(transactionRequest, (MessageChannel)this);
                        } else {
                            this.semRelease();
                        }
                    } else if (this.requestOf != null) {
                        this.requestOf.processRequest(transactionRequest, (MessageChannel)this);
                    } else {
                        this.semRelease();
                    }
                    break block37;
                }
                if (SIPTransactionStack.isDialogCreated((String)this.getMethod()) && this.getRealState() == 5 && transactionRequest.getMethod().equals("ACK") && this.requestOf != null) {
                    SIPDialog thisDialog = (SIPDialog)this.getDialog();
                    if (thisDialog == null || !thisDialog.ackProcessed) {
                        if (thisDialog != null) {
                            thisDialog.ackReceived(transactionRequest.getCSeq().getSeqNumber());
                            thisDialog.ackProcessed = true;
                        }
                        this.requestOf.processRequest(transactionRequest, (MessageChannel)this);
                    } else {
                        this.semRelease();
                    }
                } else if (transactionRequest.getMethod().equals("CANCEL")) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Too late to cancel Transaction");
                    }
                    this.semRelease();
                    try {
                        this.sendMessage((SIPMessage)transactionRequest.createResponse(200));
                    }
                    catch (IOException thisDialog) {
                        // empty catch block
                    }
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dropping request " + this.getRealState());
                }
            }
            catch (IOException e) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("IOException ", (Exception)e);
                }
                this.semRelease();
                this.raiseIOExceptionEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(SIPMessage messageToSend) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sipServerTransaction::sendMessage " + messageToSend.getFirstLine());
        }
        SIPResponse transactionResponse = (SIPResponse)messageToSend;
        int statusCode = transactionResponse.getStatusCode();
        try {
            try {
                if (this.originalRequestBranch != null) {
                    transactionResponse.getTopmostVia().setBranch(this.getBranch());
                } else {
                    transactionResponse.getTopmostVia().removeParameter("branch");
                }
                if (!this.originalRequestHasPort) {
                    transactionResponse.getTopmostVia().removePort();
                }
            }
            catch (ParseException ex) {
                logger.logError("UnexpectedException", (Exception)ex);
                throw new IOException("Unexpected exception");
            }
            if (!transactionResponse.getCSeq().getMethod().equals(this.getMethod())) {
                this.sendResponse(transactionResponse);
                return;
            }
            if (!this.checkStateTimers(statusCode)) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("checkStateTimers returned false -- not sending message");
                }
                return;
            }
            try {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("sendMessage : tx = " + this + " getState = " + this.getState());
                }
                this.lastResponse = transactionResponse;
                this.lastResponseStatusCode = transactionResponse.getStatusCode();
                this.sendResponse(transactionResponse);
            }
            catch (IOException e) {
                this.setState(5);
                this.collectionTime = 0;
                throw e;
            }
        }
        finally {
            this.startTransactionTimer();
        }
    }

    private boolean checkStateTimers(int statusCode) {
        if (this.getRealState() == 1) {
            if (statusCode / 100 == 1) {
                this.setState(2);
            } else if (200 <= statusCode && statusCode <= 699) {
                if (!this.isInviteTransaction()) {
                    if (!this.isReliable() && this.getInternalState() != 3) {
                        this.setState(3);
                        this.startTransactionTimerJ(64L);
                        this.cleanUpOnTimer();
                    } else {
                        this.cleanUpOnTimer();
                        this.setState(5);
                        this.startTransactionTimerJ(0L);
                    }
                } else if (statusCode / 100 == 2) {
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                    this.collectionTime = 64;
                    this.cleanUpOnTimer();
                    this.setState(5);
                    if (this.getDialog() != null) {
                        ((SIPDialog)this.getDialog()).setRetransmissionTicks();
                    }
                } else {
                    this.setState(3);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.cleanUpOnTimer();
                    this.enableTimeoutTimer(64);
                }
            }
        } else if (this.getRealState() == 2) {
            if (this.isInviteTransaction()) {
                if (statusCode / 100 == 2) {
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                    this.collectionTime = 64;
                    this.cleanUpOnTimer();
                    this.setState(5);
                    if (this.getDialog() != null) {
                        ((SIPDialog)this.getDialog()).setRetransmissionTicks();
                    }
                } else if (300 <= statusCode && statusCode <= 699) {
                    this.setState(3);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.cleanUpOnTimer();
                    this.enableTimeoutTimer(64);
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                this.setState(3);
                if (!this.isReliable()) {
                    this.disableRetransmissionTimer();
                    this.startTransactionTimerJ(64L);
                } else {
                    this.setState(5);
                    this.startTransactionTimerJ(0L);
                }
                this.cleanUpOnTimer();
            }
        } else if (3 == this.getRealState()) {
            return false;
        }
        return true;
    }

    public String getViaHost() {
        return super.getViaHost();
    }

    public int getViaPort() {
        return super.getViaPort();
    }

    protected void fireRetransmissionTimer() {
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("fireRetransmissionTimer() -- " + this + " state " + this.getState());
            }
            if (this.isInviteTransaction() && (this.lastResponse != null || this.lastResponseAsBytes != null)) {
                if (!this.retransmissionAlertEnabled || this.sipStack.isTransactionPendingAck(this)) {
                    if (this.lastResponseStatusCode / 100 >= 2 && !this.isAckSeen) {
                        this.resendLastResponseAsBytes();
                    }
                } else {
                    SipProviderImpl sipProvider = this.getSipProvider();
                    TimeoutEvent txTimeout = new TimeoutEvent((Object)sipProvider, (ServerTransaction)this, Timeout.RETRANSMIT);
                    sipProvider.handleEvent((EventObject)txTimeout, (SIPTransaction)this);
                }
            }
        }
        catch (IOException e) {
            if (logger.isLoggingEnabled()) {
                logger.logException((Throwable)e);
            }
            this.raiseErrorEvent(2);
        }
    }

    public void resendLastResponseAsBytes() throws IOException {
        if (this.lastResponse != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("resend last response " + this.lastResponse);
            }
            this.sendMessage((SIPMessage)this.lastResponse);
        } else if (this.lastResponseAsBytes != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("resend last response " + new String(this.lastResponseAsBytes));
            }
            if (this.isReliable()) {
                block15: {
                    if (logger.isLoggingEnabled(16)) {
                        try {
                            SIPResponse lastReparsedResponse = (SIPResponse)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.lastResponseAsBytes, true, false, null);
                            lastReparsedResponse.setRemoteAddress(this.getPeerInetAddress());
                            lastReparsedResponse.setRemotePort(this.getPeerPort());
                            lastReparsedResponse.setLocalPort(this.getMessageChannel().getPort());
                            lastReparsedResponse.setLocalAddress(this.getMessageChannel().getMessageProcessor().getIpAddress());
                            this.getMessageChannel().logMessage((SIPMessage)lastReparsedResponse, this.getPeerInetAddress(), this.getPeerPort(), System.currentTimeMillis());
                        }
                        catch (ParseException e) {
                            if (!logger.isLoggingEnabled(32)) break block15;
                            logger.logDebug("couldn't reparse last response " + new String(this.lastResponseAsBytes));
                        }
                    }
                }
                this.getMessageChannel().sendMessage(this.lastResponseAsBytes, this.getPeerInetAddress(), this.getPeerPort(), false);
            } else {
                Hop hop = this.sipStack.addressResolver.resolveAddress((Hop)new HopImpl(this.lastResponseHost, this.lastResponsePort, this.lastResponseTransport));
                MessageChannel messageChannel = this.getSIPStack().createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.getPort(), hop);
                if (messageChannel != null) {
                    block16: {
                        if (logger.isLoggingEnabled(16)) {
                            try {
                                SIPResponse lastReparsedResponse = (SIPResponse)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.lastResponseAsBytes, true, false, null);
                                lastReparsedResponse.setRemoteAddress(this.getPeerInetAddress());
                                lastReparsedResponse.setRemotePort(this.getPeerPort());
                                lastReparsedResponse.setLocalPort(this.getMessageChannel().getPort());
                                lastReparsedResponse.setLocalAddress(this.getMessageChannel().getMessageProcessor().getIpAddress());
                                this.getMessageChannel().logMessage((SIPMessage)lastReparsedResponse, this.getPeerInetAddress(), this.getPeerPort(), System.currentTimeMillis());
                            }
                            catch (ParseException e) {
                                if (!logger.isLoggingEnabled(32)) break block16;
                                logger.logDebug("couldn't reparse last response " + new String(this.lastResponseAsBytes));
                            }
                        }
                    }
                    messageChannel.sendMessage(this.lastResponseAsBytes, InetAddress.getByName(hop.getHost()), hop.getPort(), false);
                } else {
                    throw new IOException("Could not create a message channel for " + hop + " with source IP:Port " + this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress() + ":" + this.getPort());
                }
            }
        }
    }

    private void fireReliableResponseRetransmissionTimer() {
        try {
            this.resendLastResponseAsBytes();
        }
        catch (IOException e) {
            if (logger.isLoggingEnabled()) {
                logger.logException((Throwable)e);
            }
            this.setState(5);
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPServerTransaction.fireTimeoutTimer this = " + this + " current state = " + this.getRealState() + " method = " + this.getMethod());
        }
        if (this.isInviteTransaction() && this.sipStack.removeTransactionPendingAck(this)) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Found tx pending ACK - returning");
            }
            return;
        }
        SIPDialog dialog = (SIPDialog)this.getDialog();
        if (SIPTransactionStack.isDialogCreated((String)this.getMethod()) && (0 == this.getRealState() || 1 == this.getRealState())) {
            dialog.setState(3);
        } else if (this.getMethod().equals("BYE") && dialog != null && dialog.isTerminatedOnBye()) {
            dialog.setState(3);
        }
        if (3 == this.getRealState() && this.isInviteTransaction()) {
            this.raiseErrorEvent(1);
            this.setState(5);
            this.sipStack.removeTransaction((SIPTransaction)this);
        } else if (3 == this.getRealState() && !this.isInviteTransaction()) {
            this.setState(5);
            if (!this.getMethod().equals("CANCEL")) {
                this.cleanUp();
            } else {
                this.sipStack.removeTransaction((SIPTransaction)this);
            }
        } else if (4 == this.getRealState() && this.isInviteTransaction()) {
            this.setState(5);
            this.sipStack.removeTransaction((SIPTransaction)this);
        } else if (!(this.isInviteTransaction() || 3 != this.getRealState() && 4 != this.getRealState())) {
            this.setState(5);
        } else if (this.isInviteTransaction() && 5 == this.getRealState()) {
            this.raiseErrorEvent(1);
            if (dialog != null) {
                dialog.setState(3);
            }
        }
    }

    public int getLastResponseStatusCode() {
        return this.lastResponseStatusCode;
    }

    public void setOriginalRequest(SIPRequest originalRequest) {
        super.setOriginalRequest(originalRequest);
    }

    public void sendResponse(Response response) throws SipException {
        SIPResponse sipResponse = (SIPResponse)response;
        SIPDialog dialog = (SIPDialog)this.getDialog();
        if (response == null) {
            throw new NullPointerException("null response");
        }
        try {
            sipResponse.checkHeaders();
        }
        catch (ParseException ex) {
            throw new IllegalTransactionStateException(ex.getMessage(), IllegalTransactionStateException.Reason.MissingRequiredHeader);
        }
        String responseMethod = sipResponse.getCSeq().getMethod();
        if (!responseMethod.equals(this.getMethod())) {
            throw new IllegalTransactionStateException("CSeq method does not match Request method of request that created the tx.", IllegalTransactionStateException.Reason.UnmatchingCSeq);
        }
        int statusCode = response.getStatusCode();
        if (this.getMethod().equals("SUBSCRIBE") && statusCode / 100 == 2) {
            if (response.getHeader("Expires") == null) {
                throw new IllegalTransactionStateException("Expires header is mandatory in 2xx response of SUBSCRIBE", IllegalTransactionStateException.Reason.ExpiresHeaderMandatory);
            }
            Expires requestExpires = (Expires)this.getOriginalRequest().getExpires();
            Expires responseExpires = (Expires)response.getExpires();
            if (requestExpires != null && responseExpires.getExpires() > requestExpires.getExpires()) {
                throw new SipException("Response Expires time exceeds request Expires time : See RFC 3265 3.1.1");
            }
        }
        if (statusCode == 200 && responseMethod.equals("INVITE") && sipResponse.getHeader("Contact") == null) {
            throw new IllegalTransactionStateException("Contact Header is mandatory for the OK to the INVITE", IllegalTransactionStateException.Reason.ContactHeaderMandatory);
        }
        if (!this.isMessagePartOfTransaction((SIPMessage)response)) {
            throw new SipException("Response does not belong to this transaction.");
        }
        try {
            block39: {
                ContentType contentTypeHeader = ((SIPResponse)response).getContentTypeHeader();
                if (this.pendingReliableResponseAsBytes != null && this.getDialog() != null && this.getInternalState() != 5 && statusCode / 100 == 2 && contentTypeHeader != null && contentTypeHeader.getContentType().equalsIgnoreCase(CONTENT_TYPE_APPLICATION) && contentTypeHeader.getContentSubType().equalsIgnoreCase(CONTENT_SUBTYPE_SDP)) {
                    if (!interlockProvisionalResponses) {
                        throw new SipException("cannot send response -- unacked provisional");
                    }
                    try {
                        boolean acquired = this.provisionalResponseSem.tryAcquire(1L, TimeUnit.SECONDS);
                        if (!acquired) {
                            throw new SipException("cannot send response -- unacked provisional");
                        }
                        break block39;
                    }
                    catch (InterruptedException ex) {
                        logger.logError("Interrupted acuqiring PRACK sem");
                        throw new SipException("Cannot aquire PRACK sem");
                    }
                }
                if (this.pendingReliableResponseAsBytes != null && sipResponse.isFinalResponse()) {
                    this.sipStack.getTimer().cancel((SIPStackTimerTask)this.provisionalResponseTask);
                    this.provisionalResponseTask = null;
                }
            }
            if (dialog != null) {
                if (statusCode / 100 == 2 && SIPTransactionStack.isDialogCreated((String)responseMethod)) {
                    if (dialog.getLocalTag() == null && sipResponse.getToTag() == null) {
                        sipResponse.getTo().setTag(Utils.getInstance().generateTag());
                    } else if (dialog.getLocalTag() != null && sipResponse.getToTag() == null) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("assigning toTag : serverTransaction = " + this + " dialog " + dialog + " tag = " + dialog.getLocalTag());
                        }
                        sipResponse.setToTag(dialog.getLocalTag());
                    } else if (dialog.getLocalTag() != null && sipResponse.getToTag() != null && !dialog.getLocalTag().equals(sipResponse.getToTag())) {
                        throw new SipException("Tag mismatch dialogTag is " + dialog.getLocalTag() + " responseTag is " + sipResponse.getToTag());
                    }
                }
                if (!sipResponse.getCallId().getCallId().equals(dialog.getCallId().getCallId())) {
                    throw new SipException("Dialog mismatch!");
                }
            }
            String fromTag = this.originalRequestFromTag;
            if (this.getRequest() != null) {
                fromTag = ((SIPRequest)this.getRequest()).getFromTag();
            }
            if (fromTag != null && sipResponse.getFromTag() != null && !sipResponse.getFromTag().equals(fromTag)) {
                throw new SipException("From tag of request does not match response from tag");
            }
            if (fromTag != null) {
                sipResponse.getFrom().setTag(fromTag);
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("WARNING -- Null From tag in request!!");
            }
            if (dialog != null && statusCode != 100) {
                dialog.setResponseTags(sipResponse);
                DialogState oldState = dialog.getState();
                dialog.setLastResponse((SIPTransaction)this, (SIPResponse)response);
                if (oldState == null && dialog.getState() == DialogState.TERMINATED) {
                    DialogTerminatedEvent event = new DialogTerminatedEvent((Object)dialog.getSipProvider(), (Dialog)dialog);
                    dialog.getSipProvider().handleEvent((EventObject)event, (SIPTransaction)this);
                }
            } else if (dialog == null && this.isInviteTransaction() && this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask == null && response.getStatusCode() / 100 == 2) {
                String dialogId = ((SIPResponse)response).getDialogId(true);
                this.retransmissionAlertTimerTask = new RetransmissionAlertTimerTask(this, dialogId);
                this.sipStack.retransmissionAlertTransactions.put(dialogId, this);
                this.sipStack.getTimer().scheduleWithFixedDelay((SIPStackTimerTask)this.retransmissionAlertTimerTask, 0L, 500L);
            }
            this.sendMessage((SIPMessage)((SIPResponse)response));
            if (dialog != null) {
                dialog.startRetransmitTimer(this, (Response)((SIPResponse)response));
            }
        }
        catch (IOException ex) {
            if (logger.isLoggingEnabled()) {
                logger.logException((Throwable)ex);
            }
            this.setState(5);
            this.raiseErrorEvent(2);
            throw new SipException(ex.getMessage(), (Throwable)ex);
        }
        catch (ParseException ex1) {
            if (logger.isLoggingEnabled()) {
                logger.logException((Throwable)ex1);
            }
            this.setState(5);
            throw new SipException(ex1.getMessage(), (Throwable)ex1);
        }
    }

    protected int getRealState() {
        return super.getInternalState();
    }

    public TransactionState getState() {
        if (this.isInviteTransaction() && 1 == super.getInternalState()) {
            return TransactionState.PROCEEDING;
        }
        return super.getState();
    }

    public void setState(int newState) {
        if (newState == 5 && this.isReliable() && !this.getSIPStack().cacheServerConnections) {
            this.collectionTime = 64;
            this.terminationSemaphore.release();
        }
        super.setState(newState);
    }

    protected void startTransactionTimer() {
        if ((this.getMethod().equalsIgnoreCase("INVITE") || this.getMethod().equalsIgnoreCase("CANCEL") || this.getMethod().equalsIgnoreCase("ACK")) && this.transactionTimerStarted.compareAndSet(false, true) && this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
            TransactionTimer myTimer = new TransactionTimer(this);
            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                this.sipStack.getTimer().scheduleWithFixedDelay((SIPStackTimerTask)myTimer, (long)this.BASE_TIMER_INTERVAL, (long)this.BASE_TIMER_INTERVAL);
            }
            Object var1_1 = null;
        }
    }

    protected void startTransactionTimerJ(long time) {
        if (this.transactionTimerStarted.compareAndSet(false, true) && this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("starting TransactionTimerJ() : " + this.getTransactionId() + " time " + time);
            }
            1 task = new /* Unavailable Anonymous Inner Class!! */;
            if (time > 0L) {
                this.sipStack.getTimer().schedule((SIPStackTimerTask)task, time * 1L * (long)this.BASE_TIMER_INTERVAL);
            } else {
                task.runTask();
            }
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPServerTransaction sst = (SIPServerTransaction)other;
        return this.getBranch().equalsIgnoreCase(sst.getBranch());
    }

    public Dialog getDialog() {
        if (this.dialog == null && this.dialogId != null) {
            return this.sipStack.getDialog(this.dialogId);
        }
        return this.dialog;
    }

    public void setDialog(SIPDialog sipDialog, String dialogId) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setDialog " + this + " dialog = " + sipDialog);
        }
        this.dialog = sipDialog;
        this.dialogId = dialogId;
        if (dialogId != null) {
            sipDialog.setAssigned();
        }
        if (this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask != null) {
            this.sipStack.getTimer().cancel((SIPStackTimerTask)this.retransmissionAlertTimerTask);
            if (this.retransmissionAlertTimerTask.dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(this.retransmissionAlertTimerTask.dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
        this.retransmissionAlertEnabled = false;
    }

    public void terminate() throws ObjectInUseException {
        this.setState(5);
        if (this.retransmissionAlertTimerTask != null) {
            this.sipStack.getTimer().cancel((SIPStackTimerTask)this.retransmissionAlertTimerTask);
            if (this.retransmissionAlertTimerTask.dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(this.retransmissionAlertTimerTask.dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
        if (!this.transactionTimerStarted.get()) {
            this.testAndSetTransactionTerminatedEvent();
            this.sipStack.removeTransaction((SIPTransaction)this);
        }
    }

    protected void sendReliableProvisionalResponse(Response relResponse) throws SipException {
        if (this.pendingReliableResponseAsBytes != null) {
            throw new SipException("Unacknowledged response");
        }
        SIPResponse reliableResponse = (SIPResponse)relResponse;
        this.pendingReliableResponseAsBytes = reliableResponse.encodeAsBytes(this.getTransport());
        this.pendingReliableResponseMethod = reliableResponse.getCSeq().getMethod();
        this.pendingReliableCSeqNumber = reliableResponse.getCSeq().getSeqNumber();
        RSeq rseq = (RSeq)relResponse.getHeader("RSeq");
        if (relResponse.getHeader("RSeq") == null) {
            rseq = new RSeq();
            relResponse.setHeader((Header)rseq);
        }
        try {
            boolean acquired;
            if (this.rseqNumber < 0) {
                this.rseqNumber = (int)(Math.random() * 1000.0);
            }
            ++this.rseqNumber;
            rseq.setSeqNumber((long)this.rseqNumber);
            this.pendingReliableRSeqNumber = rseq.getSeqNumber();
            this.lastResponse = (SIPResponse)relResponse;
            if (this.getDialog() != null && interlockProvisionalResponses && !(acquired = this.provisionalResponseSem.tryAcquire(1L, TimeUnit.SECONDS))) {
                throw new SipException("Unacknowledged reliable response");
            }
            this.provisionalResponseTask = new ProvisionalResponseTask(this);
            this.sipStack.getTimer().scheduleWithFixedDelay((SIPStackTimerTask)this.provisionalResponseTask, 0L, 500L);
            this.sendMessage((SIPMessage)relResponse);
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException((Exception)ex);
        }
    }

    public byte[] getReliableProvisionalResponse() {
        return this.pendingReliableResponseAsBytes;
    }

    public boolean prackRecieved() {
        if (this.pendingReliableResponseAsBytes == null) {
            return false;
        }
        if (this.provisionalResponseTask != null) {
            this.sipStack.getTimer().cancel((SIPStackTimerTask)this.provisionalResponseTask);
            this.provisionalResponseTask = null;
        }
        this.pendingReliableResponseAsBytes = null;
        if (interlockProvisionalResponses && this.getDialog() != null) {
            this.provisionalResponseSem.release();
        }
        return true;
    }

    public void enableRetransmissionAlerts() throws SipException {
        if (this.getDialog() != null) {
            throw new SipException("Dialog associated with tx");
        }
        if (!this.isInviteTransaction()) {
            throw new SipException("Request Method must be INVITE");
        }
        this.retransmissionAlertEnabled = true;
    }

    public boolean isRetransmissionAlertEnabled() {
        return this.retransmissionAlertEnabled;
    }

    public void disableRetransmissionAlerts() {
        if (this.retransmissionAlertTimerTask != null && this.retransmissionAlertEnabled) {
            this.sipStack.getTimer().cancel((SIPStackTimerTask)this.retransmissionAlertTimerTask);
            this.retransmissionAlertEnabled = false;
            String dialogId = this.retransmissionAlertTimerTask.dialogId;
            if (dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
    }

    public void setAckSeen() {
        this.isAckSeen = true;
    }

    public boolean ackSeen() {
        return this.isAckSeen;
    }

    public void setMapped(boolean b) {
        this.isMapped = true;
    }

    public void setPendingSubscribe(SIPClientTransaction pendingSubscribeClientTx) {
        this.pendingSubscribeTransaction = pendingSubscribeClientTx;
    }

    public void releaseSem() {
        if (this.pendingSubscribeTransaction != null) {
            if (!this.sipStack.isDeliverUnsolicitedNotify()) {
                this.pendingSubscribeTransaction.releaseSem();
            }
        } else if (this.inviteTransaction != null && this.getMethod().equals("CANCEL")) {
            this.inviteTransaction.releaseSem();
        }
        super.releaseSem();
    }

    public void setInviteTransaction(SIPServerTransaction st) {
        this.inviteTransaction = st;
    }

    public SIPServerTransaction getCanceledInviteTransaction() {
        return this.inviteTransaction;
    }

    public void scheduleAckRemoval() throws IllegalStateException {
        if (this.getMethod() == null || !this.getMethod().equals("ACK")) {
            throw new IllegalStateException("Method is null[" + (this.getMethod() == null) + "] or method is not ACK[" + this.getMethod() + "]");
        }
        this.startTransactionTimer();
    }

    public void cleanUp() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("removing" + this);
        }
        if (this.isReleaseReferences()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("cleanup : " + this.getTransactionId());
            }
            if (this.originalRequest == null && this.originalRequestBytes != null) {
                try {
                    this.originalRequest = (SIPRequest)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.originalRequestBytes, true, false, null);
                }
                catch (ParseException e) {
                    logger.logError("message " + this.originalRequestBytes + "could not be reparsed !");
                }
            } else if (this.originalRequest != null && this.originalRequestBytes == null) {
                this.originalRequestBytes = this.originalRequest.encodeAsBytes(this.getTransport());
            }
            this.sipStack.removeTransaction((SIPTransaction)this);
            this.cleanUpOnTimer();
            this.originalRequestFromTag = null;
            this.originalRequestSentBy = null;
            if (this.originalRequest != null) {
                this.originalRequest = null;
            }
            if (!this.isReliable() && this.inviteTransaction != null) {
                this.inviteTransaction = null;
            }
            this.lastResponse = null;
        } else {
            this.sipStack.removeTransaction((SIPTransaction)this);
        }
        if (!this.sipStack.cacheServerConnections && --this.getMessageChannel().useCount <= 0) {
            this.close();
        } else if (logger.isLoggingEnabled(32) && !this.sipStack.cacheServerConnections && this.isReliable()) {
            int useCount = this.getMessageChannel().useCount;
            logger.logDebug("Use Count = " + useCount);
        }
    }

    protected void cleanUpOnTimer() {
        if (this.isReleaseReferences()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("cleanup on timer : " + this.getTransactionId());
            }
            if (this.dialog != null && this.getMethod().equals("CANCEL")) {
                this.dialogId = this.dialog.getDialogId();
            }
            this.dialog = null;
            if (this.inviteTransaction != null && !this.getMethod().equals("CANCEL")) {
                this.inviteTransaction.releaseSem();
                this.inviteTransaction = null;
            }
            if (this.originalRequest != null) {
                this.originalRequest.setTransaction(null);
                this.originalRequest.setInviteTransaction(null);
                if (!this.getMethod().equalsIgnoreCase("INVITE")) {
                    if (this.originalRequestSentBy == null) {
                        this.originalRequestSentBy = this.originalRequest.getTopmostVia().getSentBy();
                    }
                    if (this.originalRequestFromTag == null) {
                        this.originalRequestFromTag = this.originalRequest.getFromTag();
                    }
                }
                if (this.originalRequestBytes == null) {
                    this.originalRequestBytes = this.originalRequest.encodeAsBytes(this.getTransport());
                }
                if (!this.getMethod().equalsIgnoreCase("INVITE") && !this.getMethod().equalsIgnoreCase("CANCEL")) {
                    this.originalRequest = null;
                }
            }
            if (this.lastResponse != null) {
                this.lastResponseAsBytes = this.lastResponse.encodeAsBytes(this.getTransport());
                this.lastResponse = null;
            }
            this.pendingReliableResponseAsBytes = null;
            this.pendingReliableResponseMethod = null;
            this.pendingSubscribeTransaction = null;
            this.provisionalResponseSem = null;
            this.retransmissionAlertTimerTask = null;
            this.requestOf = null;
            this.messageProcessor = null;
        }
    }

    public String getPendingReliableResponseMethod() {
        return this.pendingReliableResponseMethod;
    }

    public long getPendingReliableCSeqNumber() {
        return this.pendingReliableCSeqNumber;
    }

    public long getPendingReliableRSeqNumber() {
        return this.pendingReliableRSeqNumber;
    }

    public void waitForTermination() {
        try {
            this.terminationSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ void access$000(SIPServerTransaction x0) {
        x0.fireReliableResponseRetransmissionTimer();
    }

    static /* synthetic */ ListenerExecutionMaxTimer access$102(SIPServerTransaction x0, ListenerExecutionMaxTimer x1) {
        x0.listenerExecutionMaxTimer = x1;
        return x0.listenerExecutionMaxTimer;
    }

    static /* synthetic */ StackLogger access$200() {
        return logger;
    }

    static /* synthetic */ ListenerExecutionMaxTimer access$100(SIPServerTransaction x0) {
        return x0.listenerExecutionMaxTimer;
    }
}

