/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.javax.sip.DialogTimeoutEvent;
import com.coraltele.javax.sip.stack.SIPClientTransaction;
import com.coraltele.javax.sip.stack.SIPDialog;
import java.util.EventObject;

public class SIPDialogErrorEvent
extends EventObject {
    public static final int DIALOG_ACK_NOT_RECEIVED_TIMEOUT = 1;
    public static final int DIALOG_ACK_NOT_SENT_TIMEOUT = 2;
    public static final int DIALOG_REINVITE_TIMEOUT = 3;
    public static final int EARLY_STATE_TIMEOUT = 4;
    public static final int DIALOG_ERROR_INTERNAL_COULD_NOT_TAKE_ACK_SEM = 5;
    private int errorID;
    private SIPClientTransaction clientTransaction;

    SIPDialogErrorEvent(SIPDialog sourceDialog, int dialogErrorID) {
        super(sourceDialog);
        this.errorID = dialogErrorID;
    }

    public SIPDialogErrorEvent(SIPDialog sourceDialog, DialogTimeoutEvent.Reason reason) {
        super(sourceDialog);
        if (reason == DialogTimeoutEvent.Reason.AckNotReceived) {
            this.errorID = 1;
        } else if (reason == DialogTimeoutEvent.Reason.AckNotSent) {
            this.errorID = 2;
        } else if (reason == DialogTimeoutEvent.Reason.ReInviteTimeout) {
            this.errorID = 3;
        } else if (reason == DialogTimeoutEvent.Reason.CannotAcquireAckSemaphoreForOk) {
            this.errorID = 5;
        } else if (reason == DialogTimeoutEvent.Reason.EarlyStateTimeout) {
            this.errorID = 4;
        }
    }

    public SIPDialogErrorEvent(SIPDialog sourceDialog, SIPClientTransaction clientTransaction, DialogTimeoutEvent.Reason reason) {
        this(sourceDialog, reason);
        this.clientTransaction = clientTransaction;
    }

    public int getErrorID() {
        return this.errorID;
    }

    public SIPClientTransaction getClientTransaction() {
        return this.clientTransaction;
    }

    public void setClientTransaction(SIPClientTransaction clientTransaction) {
        this.clientTransaction = clientTransaction;
    }
}

