/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.InternalErrorHandler;
import com.coraltele.core.NameValueList;
import com.coraltele.core.StackLogger;
import com.coraltele.interfaces.sip.ClientTransaction;
import com.coraltele.interfaces.sip.Dialog;
import com.coraltele.interfaces.sip.DialogDoesNotExistException;
import com.coraltele.interfaces.sip.DialogState;
import com.coraltele.interfaces.sip.IOExceptionEvent;
import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.SipException;
import com.coraltele.interfaces.sip.Transaction;
import com.coraltele.interfaces.sip.TransactionDoesNotExistException;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.address.Hop;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.EventHeader;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.header.MaxForwardsHeader;
import com.coraltele.interfaces.sip.header.OptionTag;
import com.coraltele.interfaces.sip.header.ProxyAuthorizationHeader;
import com.coraltele.interfaces.sip.header.RequireHeader;
import com.coraltele.interfaces.sip.header.ToHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.DialogExt;
import com.coraltele.javax.sip.ListeningPointImpl;
import com.coraltele.javax.sip.SipProviderImpl;
import com.coraltele.javax.sip.Utils;
import com.coraltele.javax.sip.address.AddressImpl;
import com.coraltele.javax.sip.address.SipUri;
import com.coraltele.javax.sip.header.Authorization;
import com.coraltele.javax.sip.header.CSeq;
import com.coraltele.javax.sip.header.Contact;
import com.coraltele.javax.sip.header.ContactList;
import com.coraltele.javax.sip.header.Event;
import com.coraltele.javax.sip.header.From;
import com.coraltele.javax.sip.header.MaxForwards;
import com.coraltele.javax.sip.header.RAck;
import com.coraltele.javax.sip.header.RSeq;
import com.coraltele.javax.sip.header.RecordRoute;
import com.coraltele.javax.sip.header.RecordRouteList;
import com.coraltele.javax.sip.header.Require;
import com.coraltele.javax.sip.header.Route;
import com.coraltele.javax.sip.header.RouteList;
import com.coraltele.javax.sip.header.SIPHeader;
import com.coraltele.javax.sip.header.TimeStamp;
import com.coraltele.javax.sip.header.To;
import com.coraltele.javax.sip.header.Via;
import com.coraltele.javax.sip.message.MessageFactoryImpl;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.parser.AddressParser;
import com.coraltele.javax.sip.parser.CallIDParser;
import com.coraltele.javax.sip.parser.ContactParser;
import com.coraltele.javax.sip.parser.RecordRouteParser;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.SIPClientTransaction;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.javax.sip.stack.SIPDialogErrorEvent;
import com.coraltele.javax.sip.stack.SIPDialogEventListener;
import com.coraltele.javax.sip.stack.SIPServerTransaction;
import com.coraltele.javax.sip.stack.SIPStackTimerTask;
import com.coraltele.javax.sip.stack.SIPTransaction;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * Exception performing whole class analysis ignored.
 */
public class SIPDialog
implements Dialog,
DialogExt {
    private static StackLogger logger = CommonLogger.getLogger(SIPDialog.class);
    private static final long serialVersionUID = -1429794423085204069L;
    private transient boolean dialogTerminatedEventDelivered;
    private transient String stackTrace;
    protected String method;
    protected transient boolean isAssigned;
    protected boolean reInviteFlag;
    private transient Object applicationData;
    private transient SIPRequest originalRequest;
    protected transient String originalRequestRecordRouteHeadersString;
    protected transient RecordRouteList originalRequestRecordRouteHeaders;
    protected String lastResponseDialogId;
    private Via lastResponseTopMostVia;
    protected Integer lastResponseStatusCode;
    protected long lastResponseCSeqNumber;
    protected String lastResponseMethod;
    protected String lastResponseFromTag;
    protected String lastResponseToTag;
    protected SIPTransaction firstTransaction;
    protected SIPTransaction lastTransaction;
    protected String dialogId;
    protected transient String earlyDialogId;
    protected long localSequenceNumber = 0L;
    protected long remoteSequenceNumber = -1L;
    protected String myTag;
    protected String hisTag;
    protected RouteList routeList;
    private transient SIPTransactionStack sipStack;
    private int dialogState = -1;
    protected transient SIPRequest lastAckSent;
    protected Long lastAckReceivedCSeqNumber;
    protected transient boolean ackProcessed;
    protected transient DialogTimerTask timerTask;
    protected transient long nextSeqno;
    private transient int retransmissionTicksLeft;
    private transient int prevRetransmissionTicks;
    protected long originalLocalSequenceNumber;
    private transient int ackLine;
    public transient long auditTag = 0L;
    protected Address localParty;
    protected String localPartyStringified;
    protected Address remoteParty;
    protected String remotePartyStringified;
    protected CallIdHeader callIdHeader;
    protected String callIdHeaderString;
    public static final int NULL_STATE = -1;
    public static final int EARLY_STATE = 0;
    public static final int CONFIRMED_STATE = 1;
    public static final int TERMINATED_STATE = 3;
    private static final int DIALOG_LINGER_TIME = 8;
    protected boolean serverTransactionFlag;
    private transient SipProviderImpl sipProvider;
    protected boolean terminateOnBye = true;
    protected transient boolean byeSent;
    protected Address remoteTarget;
    protected String remoteTargetStringified;
    protected EventHeader eventHeader;
    protected transient long lastInviteOkReceived;
    private transient Semaphore ackSem = new Semaphore(1);
    protected transient int reInviteWaitTime = 100;
    private transient DialogDeleteTask dialogDeleteTask;
    private transient DialogDeleteIfNoAckSentTask dialogDeleteIfNoAckSentTask;
    protected transient boolean isAcknowledged;
    private transient long highestSequenceNumberAcknowledged = -1L;
    protected boolean isBackToBackUserAgent;
    protected boolean sequenceNumberValidation = true;
    private transient Set<SIPDialogEventListener> eventListeners;
    private Semaphore timerTaskLock = new Semaphore(1);
    protected boolean firstTransactionSecure;
    protected boolean firstTransactionSeen;
    protected String firstTransactionMethod;
    protected String firstTransactionId;
    protected boolean firstTransactionIsServerTransaction;
    protected String firstTransactionMergeId;
    protected int firstTransactionPort = 5060;
    protected Contact contactHeader;
    protected String contactHeaderStringified;
    private boolean pendingRouteUpdateOn202Response;
    protected ProxyAuthorizationHeader proxyAuthorizationHeader;
    private boolean releaseReferences;
    private EarlyStateTimerTask earlyStateTimerTask;
    private int earlyDialogTimeout = 180;
    private int ackSemTakenFor;
    private Set<String> responsesReceivedInForkingCase = new HashSet(0);

    private SIPDialog(SipProviderImpl provider) {
        this.routeList = new RouteList();
        this.sipProvider = provider;
        this.eventListeners = new CopyOnWriteArraySet();
        this.earlyDialogTimeout = ((SIPTransactionStack)provider.getSipStack()).getEarlyDialogTimeout();
    }

    private void recordStackTrace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        new Exception().printStackTrace(writer);
        String stackTraceSignature = Integer.toString(Math.abs(new Random().nextInt()));
        logger.logDebug("TraceRecord = " + stackTraceSignature);
        this.stackTrace = "TraceRecord = " + stackTraceSignature + ":" + stringWriter.getBuffer().toString();
    }

    public SIPDialog(SIPTransaction transaction) {
        this(transaction.getSipProvider());
        SIPRequest sipRequest = (SIPRequest)transaction.getRequest();
        this.callIdHeader = sipRequest.getCallId();
        this.earlyDialogId = sipRequest.getDialogId(false);
        if (transaction == null) {
            throw new NullPointerException("Null tx");
        }
        this.sipStack = transaction.sipStack;
        this.sipProvider = transaction.getSipProvider();
        if (this.sipProvider == null) {
            throw new NullPointerException("Null Provider!");
        }
        this.isBackToBackUserAgent = this.sipStack.isBackToBackUserAgent;
        this.addTransaction(transaction);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Creating a dialog : " + this);
            logger.logDebug("provider port = " + this.sipProvider.getListeningPoint().getPort());
            logger.logStackTrace();
        }
        this.addEventListener((SIPDialogEventListener)this.sipStack);
        this.releaseReferences = this.sipStack.isAggressiveCleanup();
    }

    public SIPDialog(SIPClientTransaction transaction, SIPResponse sipResponse) {
        this((SIPTransaction)transaction);
        if (sipResponse == null) {
            throw new NullPointerException("Null SipResponse");
        }
        this.setLastResponse((SIPTransaction)transaction, sipResponse);
        this.isBackToBackUserAgent = this.sipStack.isBackToBackUserAgent;
    }

    public SIPDialog(SipProviderImpl sipProvider, SIPResponse sipResponse) {
        this(sipProvider);
        this.sipStack = (SIPTransactionStack)sipProvider.getSipStack();
        this.setLastResponse(null, sipResponse);
        this.originalLocalSequenceNumber = this.localSequenceNumber = sipResponse.getCSeq().getSeqNumber();
        this.setLocalTag(sipResponse.getFrom().getTag());
        this.setRemoteTag(sipResponse.getTo().getTag());
        this.localParty = sipResponse.getFrom().getAddress();
        this.remoteParty = sipResponse.getTo().getAddress();
        this.method = sipResponse.getCSeq().getMethod();
        this.callIdHeader = sipResponse.getCallId();
        this.serverTransactionFlag = false;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Creating a dialog : " + this);
            logger.logStackTrace();
        }
        this.isBackToBackUserAgent = this.sipStack.isBackToBackUserAgent;
        this.addEventListener((SIPDialogEventListener)this.sipStack);
        this.releaseReferences = this.sipStack.isAggressiveCleanup();
    }

    private void printRouteList() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("this : " + this);
            logger.logDebug("printRouteList : " + this.routeList.encode());
        }
    }

    private void raiseIOException(String host, int port, String protocol) {
        IOExceptionEvent ioError = new IOExceptionEvent((Object)this, host, port, protocol);
        this.sipProvider.handleEvent((EventObject)ioError, null);
        this.setState(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseErrorEvent(int dialogTimeoutError, SIPClientTransaction clientTransaction) {
        SIPDialogErrorEvent newErrorEvent = new SIPDialogErrorEvent(this, dialogTimeoutError);
        newErrorEvent.setClientTransaction(clientTransaction);
        Set set = this.eventListeners;
        synchronized (set) {
            for (SIPDialogEventListener nextListener : this.eventListeners) {
                nextListener.dialogErrorEvent(newErrorEvent);
            }
        }
        this.eventListeners.clear();
        if (dialogTimeoutError != 2 && dialogTimeoutError != 1 && dialogTimeoutError != 4 && dialogTimeoutError != 3) {
            this.delete();
        }
        this.stopTimer();
    }

    private void raiseErrorEvent(int dialogTimeoutError) {
        this.raiseErrorEvent(dialogTimeoutError, null);
    }

    protected void setRemoteParty(SIPMessage sipMessage) {
        this.remoteParty = !this.isServer() ? sipMessage.getTo().getAddress() : sipMessage.getFrom().getAddress();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("settingRemoteParty " + this.remoteParty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoute(RecordRouteList recordRouteList) {
        try {
            AddressImpl address;
            Route route;
            RecordRoute rr;
            boolean addRoute;
            ListIterator li;
            if (!this.isServer()) {
                this.routeList = new RouteList();
                li = recordRouteList.listIterator(recordRouteList.size());
                addRoute = true;
                while (li.hasPrevious()) {
                    rr = (RecordRoute)li.previous();
                    if (!addRoute) continue;
                    route = new Route();
                    address = (AddressImpl)((AddressImpl)rr.getAddress()).clone();
                    route.setAddress((Address)address);
                    route.setParameters((NameValueList)rr.getParameters().clone());
                    this.routeList.add((SIPHeader)route);
                }
            } else {
                this.routeList = new RouteList();
                li = recordRouteList.listIterator();
                addRoute = true;
                while (li.hasNext()) {
                    rr = (RecordRoute)li.next();
                    if (!addRoute) continue;
                    route = new Route();
                    address = (AddressImpl)((AddressImpl)rr.getAddress()).clone();
                    route.setAddress((Address)address);
                    route.setParameters((NameValueList)rr.getParameters().clone());
                    this.routeList.add((SIPHeader)route);
                }
            }
        }
        finally {
            if (logger.isLoggingEnabled()) {
                Iterator it = this.routeList.iterator();
                while (it.hasNext()) {
                    SipURI sipUri = (SipURI)((Route)it.next()).getAddress().getURI();
                    if (!sipUri.hasLrParam()) {
                        if (!logger.isLoggingEnabled()) continue;
                        logger.logWarning("NON LR route in Route set detected for dialog : " + this);
                        logger.logStackTrace();
                        continue;
                    }
                    if (!logger.isLoggingEnabled(32)) continue;
                    logger.logDebug("route = " + sipUri);
                }
            }
        }
    }

    public void setRemoteTarget(ContactHeader contact) {
        this.remoteTarget = contact.getAddress();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Dialog.setRemoteTarget: " + this.remoteTarget);
            logger.logStackTrace();
        }
    }

    private synchronized void addRoute(SIPResponse sipResponse) {
        try {
            ContactList contactList;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("setContact: dialogState: " + this + "state = " + this.getState());
            }
            if (sipResponse.getStatusCode() == 100) {
                return;
            }
            if (this.dialogState == 3) {
                return;
            }
            if (this.dialogState == 1) {
                if (sipResponse.getStatusCode() / 100 == 2 && !this.isServer() && (contactList = sipResponse.getContactHeaders()) != null && SIPRequest.isTargetRefresh((String)sipResponse.getCSeq().getMethod())) {
                    this.setRemoteTarget((ContactHeader)contactList.getFirst());
                }
                if (!this.pendingRouteUpdateOn202Response) {
                    return;
                }
            }
            if (!this.isServer() || this.pendingRouteUpdateOn202Response) {
                if (this.getState() != DialogState.CONFIRMED && this.getState() != DialogState.TERMINATED || this.pendingRouteUpdateOn202Response) {
                    RecordRouteList rrlist = sipResponse.getRecordRouteHeaders();
                    if (rrlist != null) {
                        this.addRoute(rrlist);
                    } else {
                        this.routeList = new RouteList();
                    }
                }
                if ((contactList = sipResponse.getContactHeaders()) != null) {
                    this.setRemoteTarget((ContactHeader)contactList.getFirst());
                }
            }
        }
        finally {
            if (logger.isLoggingEnabled(32)) {
                logger.logStackTrace();
            }
        }
    }

    private synchronized RouteList getRouteList() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("getRouteList " + this);
        }
        RouteList retval = new RouteList();
        retval = new RouteList();
        if (this.routeList != null) {
            ListIterator li = this.routeList.listIterator();
            while (li.hasNext()) {
                Route route = (Route)li.next();
                retval.add((SIPHeader)((Route)route.clone()));
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("----- ");
            logger.logDebug("getRouteList for " + this);
            if (retval != null) {
                logger.logDebug("RouteList = " + retval.encode());
            }
            if (this.routeList != null) {
                logger.logDebug("myRouteList = " + this.routeList.encode());
            }
            logger.logDebug("----- ");
        }
        return retval;
    }

    public void setRouteList(RouteList routeList) {
        this.routeList = routeList;
    }

    private void sendAck(Request request, boolean throwIOExceptionAsSipException) throws SipException {
        SIPRequest ackRequest = (SIPRequest)request;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendAck" + this);
        }
        if (!ackRequest.getMethod().equals("ACK")) {
            throw new SipException("Bad request method -- should be ACK");
        }
        if (this.getState() == null || this.getState().getValue() == 0) {
            if (logger.isLoggingEnabled(4)) {
                logger.logError("Bad Dialog State for " + this + " dialogID = " + this.getDialogId());
            }
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (!this.getCallId().getCallId().equals(((SIPRequest)request).getCallId().getCallId())) {
            if (logger.isLoggingEnabled(32)) {
                logger.logError("CallID " + this.getCallId());
                logger.logError("RequestCallID = " + ackRequest.getCallId().getCallId());
                logger.logError("dialog =  " + this);
            }
            throw new SipException("Bad call ID in request");
        }
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("setting from tag For outgoing ACK= " + this.getLocalTag());
                logger.logDebug("setting To tag for outgoing ACK = " + this.getRemoteTag());
                logger.logDebug("ack = " + ackRequest);
            }
            if (this.getLocalTag() != null) {
                ackRequest.getFrom().setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                ackRequest.getTo().setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            throw new SipException(ex.getMessage());
        }
        boolean releaseAckSem = false;
        long cseqNo = ((SIPRequest)request).getCSeq().getSeqNumber();
        if (!this.isAckSent(cseqNo)) {
            releaseAckSem = true;
        }
        this.setLastAckSent((SIPRequest)ackRequest.clone());
        Hop hop = this.sipStack.getNextHop(ackRequest);
        if (hop == null) {
            throw new SipException("No route!");
        }
        try {
            ListeningPointImpl lp;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("hop = " + hop);
            }
            if ((lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(hop.getTransport())) == null) {
                throw new SipException("No listening point for this provider registered at " + hop);
            }
            InetAddress inetAddress = InetAddress.getByName(hop.getHost());
            MessageChannel messageChannel = lp.getMessageProcessor().createMessageChannel(inetAddress, hop.getPort());
            messageChannel.sendMessage((SIPMessage)ackRequest);
            this.isAcknowledged = true;
            this.highestSequenceNumberAcknowledged = Math.max(this.highestSequenceNumberAcknowledged, ackRequest.getCSeq().getSeqNumber());
            if (releaseAckSem && this.isBackToBackUserAgent) {
                this.releaseAckSem();
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Not releasing ack sem for " + this + " isAckSent " + releaseAckSem);
            }
        }
        catch (IOException ex) {
            if (throwIOExceptionAsSipException) {
                throw new SipException("Could not send ack", (Throwable)ex);
            }
            this.raiseIOException(hop.getHost(), hop.getPort(), hop.getTransport());
        }
        catch (SipException ex) {
            if (logger.isLoggingEnabled()) {
                logger.logException((Throwable)ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (logger.isLoggingEnabled()) {
                logger.logException((Throwable)ex);
            }
            throw new SipException("Could not create message channel", (Throwable)ex);
        }
        if (this.dialogDeleteTask != null) {
            this.getStack().getTimer().cancel((SIPStackTimerTask)this.dialogDeleteTask);
            this.dialogDeleteTask = null;
        }
    }

    void setStack(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    SIPTransactionStack getStack() {
        return this.sipStack;
    }

    boolean isTerminatedOnBye() {
        return this.terminateOnBye;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ackReceived(long cseqNumber) {
        if (this.isAckSeen()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Ack already seen for response -- dropping");
            }
            return;
        }
        SIPServerTransaction tr = this.getInviteTransaction();
        if (tr != null) {
            if (tr.getCSeq() == cseqNumber) {
                this.acquireTimerTaskSem();
                try {
                    if (this.timerTask != null) {
                        this.getStack().getTimer().cancel((SIPStackTimerTask)this.timerTask);
                        this.timerTask = null;
                    }
                }
                finally {
                    this.releaseTimerTaskSem();
                }
                if (this.dialogDeleteTask != null) {
                    this.getStack().getTimer().cancel((SIPStackTimerTask)this.dialogDeleteTask);
                    this.dialogDeleteTask = null;
                }
                this.lastAckReceivedCSeqNumber = cseqNumber;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("ackReceived for " + tr.getMethod());
                    this.ackLine = logger.getLineCount();
                    this.printDebugInfo();
                }
                if (this.isBackToBackUserAgent) {
                    this.releaseAckSem();
                }
                this.setState(1);
            }
        } else if (logger.isLoggingEnabled(32)) {
            logger.logDebug("tr is null -- not updating the ack state");
        }
    }

    synchronized boolean testAndSetIsDialogTerminatedEventDelivered() {
        boolean retval = this.dialogTerminatedEventDelivered;
        this.dialogTerminatedEventDelivered = true;
        return retval;
    }

    public void addEventListener(SIPDialogEventListener newListener) {
        this.eventListeners.add(newListener);
    }

    public void removeEventListener(SIPDialogEventListener oldListener) {
        this.eventListeners.remove(oldListener);
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public synchronized void requestConsumed() {
        this.nextSeqno = this.getRemoteSeqNumber() + 1L;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Request Consumed -- next consumable Request Seqno = " + this.nextSeqno);
        }
    }

    public synchronized boolean isRequestConsumable(SIPRequest dialogRequest) {
        if (dialogRequest.getMethod().equals("ACK")) {
            throw new RuntimeException("Illegal method");
        }
        if (!this.isSequnceNumberValidation()) {
            return true;
        }
        return this.remoteSequenceNumber < dialogRequest.getCSeq().getSeqNumber();
    }

    public void doDeferredDelete() {
        if (this.sipStack.getTimer() == null) {
            this.setState(3);
        } else {
            this.dialogDeleteTask = new DialogDeleteTask(this);
            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                this.sipStack.getTimer().schedule((SIPStackTimerTask)this.dialogDeleteTask, 32000L);
            } else {
                this.delete();
            }
        }
    }

    public void setState(int state) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::setState:Setting dialog state for " + this + "newState = " + state);
            logger.logStackTrace();
            if (state != -1 && state != this.dialogState && logger.isLoggingEnabled()) {
                logger.logDebug("SIPDialog::setState:" + this + "  old dialog state is " + this.getState());
                logger.logDebug("SIPDialog::setState:" + this + "  New dialog state is " + DialogState.getObject((int)state));
            }
        }
        if (state == 0) {
            this.addEventListener((SIPDialogEventListener)this.getSipProvider());
        }
        this.dialogState = state;
        if (state == 3) {
            this.removeEventListener((SIPDialogEventListener)this.getSipProvider());
            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                this.sipStack.getTimer().schedule((SIPStackTimerTask)new LingerTimer(this), 8000L);
            }
            this.stopTimer();
        }
    }

    public void printDebugInfo() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("isServer = " + this.isServer());
            logger.logDebug("localTag = " + this.getLocalTag());
            logger.logDebug("remoteTag = " + this.getRemoteTag());
            logger.logDebug("localSequenceNumer = " + this.getLocalSeqNumber());
            logger.logDebug("remoteSequenceNumer = " + this.getRemoteSeqNumber());
            logger.logDebug("ackLine:" + this.getRemoteTag() + " " + this.ackLine);
        }
    }

    public boolean isAckSeen() {
        if (this.lastAckReceivedCSeqNumber == null && this.lastResponseStatusCode == 200) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::isAckSeen:" + this + "lastAckReceived is null -- returning false");
            }
            return false;
        }
        if (this.lastResponseMethod == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::isAckSeen:" + this + "lastResponse is null -- returning false");
            }
            return false;
        }
        if (this.lastAckReceivedCSeqNumber == null && this.lastResponseStatusCode / 100 > 2) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::isAckSeen:" + this + "lastResponse statusCode " + this.lastResponseStatusCode);
            }
            return true;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::isAckSeen:lastAckReceivedCSeqNumber = " + this.lastAckReceivedCSeqNumber + " remoteCSeqNumber = " + this.getRemoteSeqNumber());
        }
        return this.lastAckReceivedCSeqNumber != null && this.lastAckReceivedCSeqNumber >= this.getRemoteSeqNumber();
    }

    public SIPRequest getLastAckSent() {
        return this.lastAckSent;
    }

    public boolean isAckSent(long cseqNo) {
        if (this.getLastTransaction() == null) {
            return true;
        }
        if (this.getLastTransaction() instanceof ClientTransaction) {
            if (this.getLastAckSent() == null) {
                return false;
            }
            return cseqNo <= this.getLastAckSent().getCSeq().getSeqNumber();
        }
        return true;
    }

    @Deprecated
    public Transaction getFirstTransaction() {
        throw new UnsupportedOperationException("This method has been deprecated and is no longer supported");
    }

    public Transaction getFirstTransactionInt() {
        if (this.firstTransaction != null) {
            return this.firstTransaction;
        }
        return this.sipStack.findTransaction(this.firstTransactionId, this.firstTransactionIsServerTransaction);
    }

    public Iterator getRouteSet() {
        if (this.routeList == null) {
            return new LinkedList().listIterator();
        }
        return this.getRouteList().listIterator();
    }

    public synchronized void addRoute(SIPRequest sipRequest) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setContact: dialogState: " + this + "state = " + this.getState());
        }
        if (this.dialogState == 1 && SIPRequest.isTargetRefresh((String)sipRequest.getMethod())) {
            this.doTargetRefresh((SIPMessage)sipRequest);
        }
        if (this.dialogState == 1 || this.dialogState == 3) {
            return;
        }
        if (sipRequest.getToTag() != null) {
            return;
        }
        RecordRouteList rrlist = sipRequest.getRecordRouteHeaders();
        if (rrlist != null) {
            this.addRoute(rrlist);
        } else {
            this.routeList = new RouteList();
        }
        ContactList contactList = sipRequest.getContactHeaders();
        if (contactList != null) {
            this.setRemoteTarget((ContactHeader)contactList.getFirst());
        }
    }

    public void setDialogId(String dialogId) {
        if (this.firstTransaction != null) {
            this.firstTransaction.setDialog(this, dialogId);
        }
        this.dialogId = dialogId;
    }

    public static SIPDialog createFromNOTIFY(SIPClientTransaction subscribeTx, SIPTransaction notifyST) {
        SIPDialog d = new SIPDialog(notifyST);
        d.serverTransactionFlag = false;
        d.lastTransaction = subscribeTx;
        d.storeFirstTransactionInfo(d, (SIPTransaction)subscribeTx);
        d.terminateOnBye = false;
        d.localSequenceNumber = subscribeTx.getCSeq();
        SIPRequest not = (SIPRequest)notifyST.getRequest();
        d.remoteSequenceNumber = not.getCSeq().getSeqNumber();
        d.setDialogId(not.getDialogId(true));
        d.setLocalTag(not.getToTag());
        d.setRemoteTag(not.getFromTag());
        d.setLastResponse((SIPTransaction)subscribeTx, subscribeTx.getLastResponse());
        d.localParty = not.getTo().getAddress();
        d.remoteParty = not.getFrom().getAddress();
        d.addRoute(not);
        d.setState(1);
        return d;
    }

    public boolean isServer() {
        if (!this.firstTransactionSeen) {
            return this.serverTransactionFlag;
        }
        return this.firstTransactionIsServerTransaction;
    }

    protected boolean isReInvite() {
        return this.reInviteFlag;
    }

    public String getDialogId() {
        if (this.dialogId == null && this.lastResponseDialogId != null) {
            this.dialogId = this.lastResponseDialogId;
        }
        return this.dialogId;
    }

    protected void storeFirstTransactionInfo(SIPDialog dialog, SIPTransaction transaction) {
        dialog.firstTransactionSeen = true;
        dialog.firstTransaction = transaction;
        dialog.firstTransactionIsServerTransaction = transaction.isServerTransaction();
        dialog.firstTransactionSecure = dialog.firstTransactionIsServerTransaction ? transaction.getRequest().getRequestURI().getScheme().equalsIgnoreCase("sips") : ((SIPClientTransaction)transaction).getOriginalRequestScheme().equalsIgnoreCase("sips");
        dialog.firstTransactionPort = transaction.getPort();
        dialog.firstTransactionId = transaction.getBranchId();
        dialog.firstTransactionMethod = transaction.getMethod();
        if (transaction instanceof SIPServerTransaction && dialog.firstTransactionMethod.equals("INVITE")) {
            this.sipStack.removeMergeDialog(this.firstTransactionMergeId);
            dialog.firstTransactionMergeId = ((SIPRequest)transaction.getRequest()).getMergeId();
            this.sipStack.putMergeDialog(this);
        }
        if (transaction.isServerTransaction()) {
            SIPServerTransaction st = (SIPServerTransaction)transaction;
            SIPResponse response = st.getLastResponse();
            dialog.contactHeader = response != null ? response.getContactHeader() : null;
        } else {
            SIPClientTransaction ct = (SIPClientTransaction)transaction;
            if (ct != null) {
                dialog.contactHeader = ct.getOriginalRequestContact();
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("firstTransaction = " + dialog.firstTransaction);
            logger.logDebug("firstTransactionIsServerTransaction = " + this.firstTransactionIsServerTransaction);
            logger.logDebug("firstTransactionSecure = " + this.firstTransactionSecure);
            logger.logDebug("firstTransactionPort = " + this.firstTransactionPort);
            logger.logDebug("firstTransactionId = " + this.firstTransactionId);
            logger.logDebug("firstTransactionMethod = " + this.firstTransactionMethod);
            logger.logDebug("firstTransactionMergeId = " + this.firstTransactionMergeId);
        }
    }

    public boolean addTransaction(SIPTransaction transaction) {
        SIPRequest sipRequest = transaction.getOriginalRequest();
        if (this.firstTransactionSeen && !this.firstTransactionId.equals(transaction.getBranchId()) && transaction.getMethod().equals(this.firstTransactionMethod)) {
            this.setReInviteFlag(true);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SipDialog.addTransaction() " + this + " transaction = " + transaction);
        }
        if (!this.firstTransactionSeen) {
            this.storeFirstTransactionInfo(this, transaction);
            if (sipRequest.getMethod().equals("SUBSCRIBE")) {
                this.eventHeader = (EventHeader)sipRequest.getHeader("Event");
            }
            this.setLocalParty((SIPMessage)sipRequest);
            this.setRemoteParty((SIPMessage)sipRequest);
            this.setCallId(sipRequest);
            if (this.originalRequest == null && transaction.isInviteTransaction()) {
                this.originalRequest = sipRequest;
            } else if (this.originalRequest != null) {
                this.originalRequestRecordRouteHeaders = sipRequest.getRecordRouteHeaders();
            }
            if (this.method == null) {
                this.method = sipRequest.getMethod();
            }
            if (transaction instanceof SIPServerTransaction) {
                this.hisTag = sipRequest.getFrom().getTag();
            } else {
                this.setLocalSequenceNumber(sipRequest.getCSeq().getSeqNumber());
                this.originalLocalSequenceNumber = this.localSequenceNumber;
                this.setLocalTag(sipRequest.getFrom().getTag());
                if (this.myTag == null && logger.isLoggingEnabled()) {
                    logger.logError("The request's From header is missing the required Tag parameter.");
                }
            }
        } else if (transaction.getMethod().equals(this.firstTransactionMethod) && this.firstTransactionIsServerTransaction != transaction.isServerTransaction()) {
            this.storeFirstTransactionInfo(this, transaction);
            this.setLocalParty((SIPMessage)sipRequest);
            this.setRemoteParty((SIPMessage)sipRequest);
            this.setCallId(sipRequest);
            if (transaction.isInviteTransaction()) {
                this.originalRequest = sipRequest;
            } else {
                this.originalRequestRecordRouteHeaders = sipRequest.getRecordRouteHeaders();
            }
            this.method = sipRequest.getMethod();
        } else if (this.firstTransaction == null && transaction.isInviteTransaction()) {
            this.firstTransaction = transaction;
        }
        if (transaction instanceof SIPServerTransaction) {
            this.setRemoteSequenceNumber(sipRequest.getCSeq().getSeqNumber());
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("isBackToBackUserAgent = " + this.isBackToBackUserAgent);
        }
        if (transaction.isInviteTransaction()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::setLastTransaction:dialog= " + this + " lastTransaction = " + transaction);
            }
            this.lastTransaction = transaction;
        }
        try {
            if (transaction.getRequest().getMethod().equals("REFER") && transaction instanceof SIPServerTransaction) {
                long lastReferCSeq = ((SIPRequest)transaction.getRequest()).getCSeq().getSeqNumber();
                this.eventHeader = new Event();
                this.eventHeader.setEventType("refer");
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("SIPDialog::setLastTransaction:lastReferCSeq = " + lastReferCSeq);
                }
                this.eventHeader.setEventId(Long.toString(lastReferCSeq));
            }
        }
        catch (Exception ex) {
            logger.logFatalError("Unexpected exception in REFER processing");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Transaction Added " + this + this.myTag + "/" + this.hisTag);
            logger.logDebug("TID = " + transaction.getTransactionId() + "/" + transaction.isServerTransaction());
            logger.logStackTrace();
        }
        return true;
    }

    protected void setRemoteTag(String hisTag) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setRemoteTag(): " + this + " remoteTag = " + this.hisTag + " new tag = " + hisTag);
        }
        if (this.hisTag != null && hisTag != null && !hisTag.equals(this.hisTag)) {
            if (this.getState() != DialogState.EARLY) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dialog is already established -- ignoring remote tag re-assignment");
                }
                return;
            }
            if (this.sipStack.isRemoteTagReassignmentAllowed()) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("UNSAFE OPERATION !  tag re-assignment " + this.hisTag + " trying to set to " + hisTag + " can cause unexpected effects ");
                }
                boolean removed = false;
                if (this.sipStack.getDialog(this.dialogId) == this) {
                    this.sipStack.removeDialog(this.dialogId);
                    removed = true;
                }
                this.dialogId = null;
                this.hisTag = hisTag;
                if (removed) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("ReInserting Dialog");
                    }
                    this.sipStack.putDialog(this);
                }
            }
        } else if (hisTag != null) {
            this.hisTag = hisTag;
        } else if (logger.isLoggingEnabled()) {
            logger.logWarning("setRemoteTag : called with null argument ");
        }
    }

    public SIPTransaction getLastTransaction() {
        return this.lastTransaction;
    }

    public SIPServerTransaction getInviteTransaction() {
        DialogTimerTask t = this.timerTask;
        if (t != null) {
            return t.transaction;
        }
        return null;
    }

    public void setLocalSequenceNumber(long lCseq) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setLocalSequenceNumber: original  " + this.localSequenceNumber + " new  = " + lCseq);
        }
        if (lCseq <= this.localSequenceNumber) {
            throw new RuntimeException("Sequence number should not decrease !");
        }
        this.localSequenceNumber = lCseq;
    }

    public void setRemoteSequenceNumber(long rCseq) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setRemoteSeqno " + this + "/" + rCseq);
        }
        this.remoteSequenceNumber = rCseq;
    }

    public void incrementLocalSequenceNumber() {
        ++this.localSequenceNumber;
    }

    public int getRemoteSequenceNumber() {
        return (int)this.remoteSequenceNumber;
    }

    public int getLocalSequenceNumber() {
        return (int)this.localSequenceNumber;
    }

    public long getOriginalLocalSequenceNumber() {
        return this.originalLocalSequenceNumber;
    }

    public long getLocalSeqNumber() {
        return this.localSequenceNumber;
    }

    public long getRemoteSeqNumber() {
        return this.remoteSequenceNumber;
    }

    public String getLocalTag() {
        return this.myTag;
    }

    public String getRemoteTag() {
        return this.hisTag;
    }

    public void setLocalTag(String mytag) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("set Local tag " + mytag + " dialog = " + this);
            logger.logStackTrace();
        }
        this.myTag = mytag;
    }

    public void delete() {
        this.setState(3);
    }

    public CallIdHeader getCallId() {
        if (this.callIdHeader == null && this.callIdHeaderString != null) {
            try {
                this.callIdHeader = (CallIdHeader)new CallIDParser(this.callIdHeaderString).parse();
            }
            catch (ParseException e) {
                logger.logError("error reparsing the call id header", (Exception)e);
            }
        }
        return this.callIdHeader;
    }

    private void setCallId(SIPRequest sipRequest) {
        this.callIdHeader = sipRequest.getCallId();
    }

    public Address getLocalParty() {
        if (this.localParty == null && this.localPartyStringified != null) {
            try {
                this.localParty = new AddressParser(this.localPartyStringified).address(true);
            }
            catch (ParseException e) {
                logger.logError("error reparsing the localParty", (Exception)e);
            }
        }
        return this.localParty;
    }

    protected void setLocalParty(SIPMessage sipMessage) {
        this.localParty = !this.isServer() ? sipMessage.getFrom().getAddress() : sipMessage.getTo().getAddress();
    }

    public Address getRemoteParty() {
        if (this.remoteParty == null && this.remotePartyStringified != null) {
            try {
                this.remoteParty = new AddressParser(this.remotePartyStringified).address(true);
            }
            catch (ParseException e) {
                logger.logError("error reparsing the remoteParty", (Exception)e);
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("gettingRemoteParty " + this.remoteParty);
        }
        return this.remoteParty;
    }

    public Address getRemoteTarget() {
        if (this.remoteTarget == null && this.remoteTargetStringified != null) {
            try {
                this.remoteTarget = new AddressParser(this.remoteTargetStringified).address(true);
            }
            catch (ParseException e) {
                logger.logError("error reparsing the remoteTarget", (Exception)e);
            }
        }
        return this.remoteTarget;
    }

    public DialogState getState() {
        if (this.dialogState == -1) {
            return null;
        }
        return DialogState.getObject((int)this.dialogState);
    }

    public boolean isSecure() {
        return this.firstTransactionSecure;
    }

    public void sendAck(Request request) throws SipException {
        this.sendAck(request, true);
    }

    public Request createRequest(String method) throws SipException {
        if (method.equals("ACK") || method.equals("PRACK")) {
            throw new SipException("Invalid method specified for createRequest:" + method);
        }
        if (this.lastResponseTopMostVia != null) {
            return this.createRequest(method, this.lastResponseTopMostVia.getTransport());
        }
        throw new SipException("Dialog not yet established -- no response!");
    }

    private SIPRequest createRequest(String method, String topMostViaTransport) throws SipException {
        if (method == null || topMostViaTransport == null) {
            throw new NullPointerException("null argument");
        }
        if (method.equals("CANCEL")) {
            throw new SipException("Dialog.createRequest(): Invalid request");
        }
        if (this.getState() == null || this.getState().getValue() == 3 && !method.equalsIgnoreCase("BYE") || this.isServer() && this.getState().getValue() == 0 && method.equalsIgnoreCase("BYE")) {
            throw new SipException("Dialog  " + this.getDialogId() + " not yet established or terminated " + this.getState());
        }
        SipUri sipUri = null;
        if (this.getRemoteTarget() != null) {
            sipUri = (SipUri)this.getRemoteTarget().getURI().clone();
        } else {
            sipUri = (SipUri)this.getRemoteParty().getURI().clone();
            sipUri.clearUriParms();
        }
        CSeq cseq = new CSeq();
        try {
            cseq.setMethod(method);
            cseq.setSeqNumber(this.getLocalSeqNumber());
        }
        catch (Exception ex) {
            if (logger.isLoggingEnabled()) {
                logger.logError("Unexpected error");
            }
            InternalErrorHandler.handleException((Exception)ex);
        }
        ListeningPointImpl lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(topMostViaTransport);
        if (lp == null) {
            if (logger.isLoggingEnabled()) {
                logger.logError("Cannot find listening point for transport " + topMostViaTransport);
            }
            throw new SipException("Cannot find listening point for transport " + topMostViaTransport);
        }
        Via via = lp.getViaHeader();
        From from = new From();
        from.setAddress(this.getLocalParty());
        To to = new To();
        to.setAddress(this.getRemoteParty());
        SIPRequest sipRequest = this.createRequest(sipUri, via, cseq, from, to);
        if (SIPRequest.isTargetRefresh((String)method)) {
            ContactHeader contactHeader = ((ListeningPointImpl)this.sipProvider.getListeningPoint(lp.getTransport())).createContactHeader();
            ((SipURI)contactHeader.getAddress().getURI()).setSecure(this.isSecure());
            sipRequest.setHeader((Header)contactHeader);
        }
        try {
            cseq = (CSeq)sipRequest.getCSeq();
            cseq.setSeqNumber(this.localSequenceNumber + 1L);
        }
        catch (InvalidArgumentException ex) {
            InternalErrorHandler.handleException((Exception)((Object)ex));
        }
        if (method.equals("SUBSCRIBE") && this.eventHeader != null) {
            sipRequest.addHeader((Header)this.eventHeader);
        }
        if (method.equals("NOTIFY") && this.eventHeader != null) {
            sipRequest.addHeader((Header)this.eventHeader);
        }
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            } else {
                from.removeTag();
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            } else {
                to.removeTag();
            }
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException((Exception)ex);
        }
        this.updateRequest(sipRequest);
        return sipRequest;
    }

    public SIPRequest createRequest(SipUri requestURI, Via via, CSeq cseq, From from, To to) {
        SIPRequest newRequest = new SIPRequest();
        String method = cseq.getMethod();
        newRequest.setMethod(method);
        newRequest.setRequestURI((URI)requestURI);
        this.setBranch(via, method);
        newRequest.setHeader((Header)via);
        newRequest.setHeader((Header)cseq);
        newRequest.setHeader((Header)from);
        newRequest.setHeader((Header)to);
        newRequest.setHeader((Header)this.getCallId());
        try {
            newRequest.attachHeader((SIPHeader)new MaxForwards(70), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
            newRequest.setHeader((Header)MessageFactoryImpl.getDefaultUserAgentHeader());
        }
        return newRequest;
    }

    private final void setBranch(Via via, String method) {
        String branch;
        if (method.equals("ACK")) {
            branch = this.getLastResponseStatusCode() >= 300 ? this.lastResponseTopMostVia.getBranch() : Utils.getInstance().generateBranchId();
        } else if (method.equals("CANCEL")) {
            branch = this.lastResponseTopMostVia.getBranch();
        } else {
            return;
        }
        try {
            via.setBranch(branch);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void sendRequest(ClientTransaction clientTransactionId) throws TransactionDoesNotExistException, SipException {
        this.sendRequest(clientTransactionId, !this.isBackToBackUserAgent);
    }

    public void sendRequest(ClientTransaction clientTransactionId, boolean allowInterleaving) throws TransactionDoesNotExistException, SipException {
        if (clientTransactionId == null) {
            throw new NullPointerException("null parameter");
        }
        if (!allowInterleaving && clientTransactionId.getRequest().getMethod().equals("INVITE")) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::sendRequest " + this + " clientTransaction = " + clientTransactionId);
            }
            this.sipStack.getReinviteExecutor().execute((Runnable)new ReInviteSender(this, clientTransactionId));
            return;
        }
        SIPRequest dialogRequest = ((SIPClientTransaction)clientTransactionId).getOriginalRequest();
        this.proxyAuthorizationHeader = (ProxyAuthorizationHeader)dialogRequest.getHeader("Proxy-Authorization");
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::sendRequest:dialog.sendRequest  dialog = " + this + "\ndialogRequest = \n" + dialogRequest);
        }
        if (dialogRequest.getMethod().equals("ACK") || dialogRequest.getMethod().equals("CANCEL")) {
            throw new SipException("Bad Request Method. " + dialogRequest.getMethod());
        }
        if (this.byeSent && this.isTerminatedOnBye() && !dialogRequest.getMethod().equals("BYE")) {
            if (logger.isLoggingEnabled()) {
                logger.logError("BYE already sent for " + this);
            }
            throw new SipException("Cannot send request; BYE already sent");
        }
        if (dialogRequest.getTopmostVia() == null) {
            Via via = ((SIPClientTransaction)clientTransactionId).getOutgoingViaHeader();
            dialogRequest.addHeader((Header)via);
        }
        if (!this.getCallId().getCallId().equalsIgnoreCase(dialogRequest.getCallId().getCallId())) {
            if (logger.isLoggingEnabled()) {
                logger.logError("CallID " + this.getCallId());
                logger.logError("SIPDialog::sendRequest:RequestCallID = " + dialogRequest.getCallId().getCallId());
                logger.logError("dialog =  " + this);
            }
            throw new SipException("Bad call ID in request");
        }
        ((SIPClientTransaction)clientTransactionId).setDialog(this, this.dialogId);
        this.addTransaction((SIPTransaction)clientTransactionId);
        ((SIPClientTransaction)clientTransactionId).isMapped = true;
        From from = (From)dialogRequest.getFrom();
        To to = (To)dialogRequest.getTo();
        if (this.getLocalTag() != null && from.getTag() != null && !from.getTag().equals(this.getLocalTag())) {
            throw new SipException("From tag mismatch expecting  " + this.getLocalTag());
        }
        if (this.getRemoteTag() != null && to.getTag() != null && !to.getTag().equals(this.getRemoteTag()) && logger.isLoggingEnabled()) {
            logger.logWarning("SIPDialog::sendRequest:To header tag mismatch expecting " + this.getRemoteTag());
        }
        if (this.getLocalTag() == null && dialogRequest.getMethod().equals("NOTIFY")) {
            if (!this.getMethod().equals("SUBSCRIBE")) {
                throw new SipException("Trying to send NOTIFY without SUBSCRIBE Dialog!");
            }
            this.setLocalTag(from.getTag());
        }
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException((Exception)ex);
        }
        Hop hop = ((SIPClientTransaction)clientTransactionId).getNextHop();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::sendRequest:Using hop = " + hop.getHost() + " : " + hop.getPort());
        }
        try {
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.getSipProvider().getListeningPoint(hop.getTransport()).getPort(), hop);
            MessageChannel oldChannel = ((SIPClientTransaction)clientTransactionId).getMessageChannel();
            oldChannel.uncache();
            if (!this.sipStack.cacheClientConnections) {
                --oldChannel.useCount;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("SIPDialog::sendRequest:oldChannel: useCount " + oldChannel.useCount);
                }
            }
            if (messageChannel == null) {
                Hop outboundProxy;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Null message channel using outbound proxy !");
                }
                if ((outboundProxy = this.sipStack.getRouter(dialogRequest).getOutboundProxy()) == null) {
                    throw new SipException("No route found! hop=" + hop);
                }
                messageChannel = this.sipStack.createRawMessageChannel(this.getSipProvider().getListeningPoint(outboundProxy.getTransport()).getIPAddress(), this.firstTransactionPort, outboundProxy);
                if (messageChannel != null) {
                    ((SIPClientTransaction)clientTransactionId).setEncapsulatedChannel(messageChannel);
                }
            } else {
                ((SIPClientTransaction)clientTransactionId).setEncapsulatedChannel(messageChannel);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("SIPDialog::sendRequest:using message channel " + messageChannel);
                }
            }
            if (messageChannel != null) {
                ++messageChannel.useCount;
            }
            if (!this.sipStack.cacheClientConnections && oldChannel != null && oldChannel.useCount <= 0) {
                oldChannel.close();
            }
        }
        catch (Exception ex) {
            if (logger.isLoggingEnabled()) {
                logger.logException((Throwable)ex);
            }
            throw new SipException("Could not create message channel", (Throwable)ex);
        }
        try {
            dialogRequest.getCSeq().setSeqNumber(dialogRequest.getCSeq().getSeqNumber());
        }
        catch (InvalidArgumentException ex) {
            logger.logFatalError(ex.getMessage());
        }
        try {
            ((SIPClientTransaction)clientTransactionId).sendMessage((SIPMessage)dialogRequest);
            if (dialogRequest.getMethod().equals("BYE")) {
                this.byeSent = true;
                if (this.isTerminatedOnBye()) {
                    this.setState(3);
                }
            }
        }
        catch (IOException ex) {
            throw new SipException("error sending message", (Throwable)ex);
        }
    }

    private boolean toRetransmitFinalResponse(int T2) {
        if (--this.retransmissionTicksLeft == 0) {
            this.retransmissionTicksLeft = 2 * this.prevRetransmissionTicks <= T2 ? 2 * this.prevRetransmissionTicks : this.prevRetransmissionTicks;
            this.prevRetransmissionTicks = this.retransmissionTicksLeft;
            return true;
        }
        return false;
    }

    protected void setRetransmissionTicks() {
        this.retransmissionTicksLeft = 1;
        this.prevRetransmissionTicks = 1;
    }

    public void resendAck() throws SipException {
        if (this.getLastAckSent() != null) {
            if (this.getLastAckSent().getHeader("Timestamp") != null && this.sipStack.generateTimeStampHeader) {
                TimeStamp ts = new TimeStamp();
                try {
                    ts.setTimeStamp((float)System.currentTimeMillis());
                    this.getLastAckSent().setHeader((Header)ts);
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    // empty catch block
                }
            }
            this.sendAck((Request)this.getLastAckSent(), false);
        } else if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::resendAck:lastAck sent is NULL hence not resending ACK");
        }
    }

    public String getMethod() {
        return this.method;
    }

    protected void startTimer(SIPServerTransaction transaction) {
        if (this.timerTask != null && this.timerTask.transaction == transaction) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Timer already running for " + this.getDialogId());
            }
            return;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Starting dialog timer for " + this.getDialogId());
        }
        this.acquireTimerTaskSem();
        try {
            if (this.timerTask != null) {
                this.timerTask.transaction = transaction;
            } else {
                this.timerTask = new DialogTimerTask(this, transaction);
                if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                    this.sipStack.getTimer().scheduleWithFixedDelay((SIPStackTimerTask)this.timerTask, 500L, 500L);
                }
            }
        }
        finally {
            this.releaseTimerTaskSem();
        }
        this.setRetransmissionTicks();
    }

    protected void stopTimer() {
        try {
            this.acquireTimerTaskSem();
            try {
                if (this.timerTask != null) {
                    this.getStack().getTimer().cancel((SIPStackTimerTask)this.timerTask);
                    this.timerTask = null;
                }
                if (this.earlyStateTimerTask != null) {
                    this.getStack().getTimer().cancel((SIPStackTimerTask)this.earlyStateTimerTask);
                    this.earlyStateTimerTask = null;
                }
            }
            finally {
                this.releaseTimerTaskSem();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Request createPrack(Response relResponse) throws DialogDoesNotExistException, SipException {
        if (this.getState() == null || this.getState().equals((Object)DialogState.TERMINATED)) {
            throw new DialogDoesNotExistException("Dialog not initialized or terminated");
        }
        if ((RSeq)relResponse.getHeader("RSeq") == null) {
            throw new SipException("Missing RSeq Header");
        }
        try {
            SIPResponse sipResponse = (SIPResponse)relResponse;
            SIPRequest sipRequest = this.createRequest("PRACK", sipResponse.getTopmostVia().getTransport());
            String toHeaderTag = sipResponse.getTo().getTag();
            sipRequest.setToTag(toHeaderTag);
            RAck rack = new RAck();
            RSeq rseq = (RSeq)relResponse.getHeader("RSeq");
            rack.setMethod(sipResponse.getCSeq().getMethod());
            rack.setCSequenceNumber((long)((int)sipResponse.getCSeq().getSeqNumber()));
            rack.setRSequenceNumber(rseq.getSeqNumber());
            sipRequest.setHeader((Header)rack);
            if (this.proxyAuthorizationHeader != null) {
                sipRequest.addHeader((Header)this.proxyAuthorizationHeader);
            }
            return sipRequest;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException((Exception)ex);
            return null;
        }
    }

    private void updateRequest(SIPRequest sipRequest) {
        RouteList rl = this.getRouteList();
        if (rl.size() > 0) {
            sipRequest.setHeader((Header)rl);
        } else {
            sipRequest.removeHeader("Route");
        }
        if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
            sipRequest.setHeader((Header)MessageFactoryImpl.getDefaultUserAgentHeader());
        }
        if (this.proxyAuthorizationHeader != null && sipRequest.getHeader("Proxy-Authorization") == null) {
            sipRequest.setHeader((Header)this.proxyAuthorizationHeader);
        }
    }

    public Request createAck(long cseqno) throws InvalidArgumentException, SipException {
        if (!this.method.equals("INVITE")) {
            throw new SipException("Dialog was not created with an INVITE" + this.method);
        }
        if (cseqno <= 0L) {
            throw new InvalidArgumentException("bad cseq <= 0 ");
        }
        if (cseqno > 0xFFFFFFFFL) {
            throw new InvalidArgumentException("bad cseq > 4294967295");
        }
        if (this.getRemoteTarget() == null) {
            throw new SipException("Cannot create ACK - no remote Target!");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("createAck " + this + " cseqno " + cseqno);
        }
        if (this.lastInviteOkReceived < cseqno) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("WARNING : Attempt to crete ACK without OK " + this);
                logger.logDebug("LAST RESPONSE = " + this.getLastResponseStatusCode());
            }
            throw new SipException("Dialog not yet established -- no OK response! lastInviteOkReceived=" + this.lastInviteOkReceived + " cseqno=" + cseqno);
        }
        try {
            NameValueList originalRequestParameters;
            ListeningPointImpl lp;
            SipURI uri4transport = null;
            if (this.routeList != null && !this.routeList.isEmpty()) {
                Route r = (Route)this.routeList.getFirst();
                uri4transport = (SipURI)r.getAddress().getURI();
            } else {
                uri4transport = (SipURI)this.getRemoteTarget().getURI();
            }
            String transport = uri4transport.getTransportParam();
            if (transport != null) {
                lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(transport);
            } else if (uri4transport.isSecure()) {
                lp = (ListeningPointImpl)this.sipProvider.getListeningPoint("TLS");
            } else {
                lp = (ListeningPointImpl)this.sipProvider.getListeningPoint("UDP");
                if (lp == null) {
                    lp = (ListeningPointImpl)this.sipProvider.getListeningPoint("TCP");
                }
            }
            if (lp == null) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("remoteTargetURI " + this.getRemoteTarget().getURI());
                    logger.logError("uri4transport = " + uri4transport);
                    logger.logError("No LP found for transport=" + transport);
                }
                throw new SipException("Cannot create ACK - no ListeningPoint for transport towards next hop found:" + transport);
            }
            SIPRequest sipRequest = new SIPRequest();
            sipRequest.setMethod("ACK");
            sipRequest.setRequestURI((URI)((SipUri)this.getRemoteTarget().getURI().clone()));
            sipRequest.setCallId(this.getCallId());
            sipRequest.setCSeq((CSeqHeader)new CSeq(cseqno, "ACK"));
            ArrayList<Via> vias = new ArrayList<Via>();
            Via via = this.lastResponseTopMostVia;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("lastResponseTopMostVia " + this.lastResponseTopMostVia);
            }
            via.removeParameters();
            if (this.originalRequest != null && this.originalRequest.getTopmostVia() != null && (originalRequestParameters = this.originalRequest.getTopmostVia().getParameters()) != null && originalRequestParameters.size() > 0) {
                via.setParameters((NameValueList)originalRequestParameters.clone());
            }
            via.setBranch(Utils.getInstance().generateBranchId());
            vias.add(via);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Adding via to the ACK we are creating : " + via + " lastResponseTopMostVia " + this.lastResponseTopMostVia);
            }
            sipRequest.setVia(vias);
            From from = new From();
            from.setAddress(this.getLocalParty());
            from.setTag(this.myTag);
            sipRequest.setFrom((FromHeader)from);
            To to = new To();
            to.setAddress(this.getRemoteParty());
            if (this.hisTag != null) {
                to.setTag(this.hisTag);
            }
            sipRequest.setTo((ToHeader)to);
            sipRequest.setMaxForwards((MaxForwardsHeader)new MaxForwards(70));
            if (this.originalRequest != null) {
                Authorization authorization = this.originalRequest.getAuthorization();
                if (authorization != null) {
                    sipRequest.setHeader((Header)authorization);
                }
                this.originalRequestRecordRouteHeaders = this.originalRequest.getRecordRouteHeaders();
                this.originalRequest = null;
            }
            this.updateRequest(sipRequest);
            return sipRequest;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException((Exception)ex);
            throw new SipException("unexpected exception ", (Throwable)ex);
        }
    }

    public SipProviderImpl getSipProvider() {
        return this.sipProvider;
    }

    public void setSipProvider(SipProviderImpl sipProvider) {
        this.sipProvider = sipProvider;
    }

    public void setResponseTags(SIPResponse sipResponse) {
        if (this.getLocalTag() != null || this.getRemoteTag() != null) {
            return;
        }
        String responseFromTag = sipResponse.getFromTag();
        if (responseFromTag != null) {
            if (responseFromTag.equals(this.getLocalTag())) {
                sipResponse.setToTag(this.getRemoteTag());
            } else if (responseFromTag.equals(this.getRemoteTag())) {
                sipResponse.setToTag(this.getLocalTag());
            }
        } else if (logger.isLoggingEnabled()) {
            logger.logWarning("No from tag in response! Not RFC 3261 compatible.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastResponse(SIPTransaction transaction, SIPResponse sipResponse) {
        block63: {
            this.callIdHeader = sipResponse.getCallId();
            int statusCode = sipResponse.getStatusCode();
            if (statusCode == 100) {
                if (logger.isLoggingEnabled()) {
                    logger.logWarning("Invalid status code - 100 in setLastResponse - ignoring");
                }
                return;
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logStackTrace();
            }
            try {
                long responseCSeqNumber;
                String cseqMethod;
                this.lastResponseStatusCode = statusCode;
                this.lastResponseTopMostVia = (Via)sipResponse.getTopmostVia().clone();
                this.lastResponseMethod = cseqMethod = sipResponse.getCSeqHeader().getMethod();
                this.lastResponseCSeqNumber = responseCSeqNumber = sipResponse.getCSeq().getSeqNumber();
                if (sipResponse.getToTag() != null) {
                    this.lastResponseToTag = sipResponse.getToTag();
                }
                if (sipResponse.getFromTag() != null) {
                    this.lastResponseFromTag = sipResponse.getFromTag();
                }
                if (transaction != null) {
                    this.lastResponseDialogId = sipResponse.getDialogId(transaction.isServerTransaction());
                }
                this.setAssigned();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("sipDialog: setLastResponse:" + this + " lastResponse = " + this.lastResponseStatusCode + " response " + sipResponse.toString() + " topMostViaHeader " + this.lastResponseTopMostVia);
                }
                if (this.getState() == DialogState.TERMINATED) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("sipDialog: setLastResponse -- dialog is terminated - ignoring ");
                    }
                    if (cseqMethod.equals("INVITE") && statusCode == 200) {
                        this.lastInviteOkReceived = Math.max(responseCSeqNumber, this.lastInviteOkReceived);
                    }
                    return;
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logStackTrace();
                    logger.logDebug("cseqMethod = " + cseqMethod);
                    logger.logDebug("dialogState = " + this.getState());
                    logger.logDebug("method = " + this.getMethod());
                    logger.logDebug("statusCode = " + statusCode);
                    logger.logDebug("transaction = " + transaction);
                }
                if (transaction == null || transaction instanceof ClientTransaction) {
                    if (SIPTransactionStack.isDialogCreated((String)cseqMethod)) {
                        if (this.getState() == null && statusCode / 100 == 1) {
                            this.setState(0);
                            if ((sipResponse.getToTag() != null || this.sipStack.rfc2543Supported) && this.getRemoteTag() == null) {
                                this.setRemoteTag(sipResponse.getToTag());
                                this.setDialogId(sipResponse.getDialogId(false));
                                this.sipStack.putDialog(this);
                                this.addRoute(sipResponse);
                            }
                        } else if (this.getState() != null && this.getState().equals((Object)DialogState.EARLY) && statusCode / 100 == 1) {
                            if (cseqMethod.equals(this.getMethod()) && transaction != null && (sipResponse.getToTag() != null || this.sipStack.rfc2543Supported)) {
                                this.setRemoteTag(sipResponse.getToTag());
                                this.setDialogId(sipResponse.getDialogId(false));
                                this.sipStack.putDialog(this);
                                this.addRoute(sipResponse);
                            }
                        } else if (statusCode / 100 == 2) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("pendingRouteUpdateOn202Response : " + this.pendingRouteUpdateOn202Response);
                            }
                            if (cseqMethod.equals(this.getMethod()) && (sipResponse.getToTag() != null || this.sipStack.rfc2543Supported) && (this.getState() != DialogState.CONFIRMED || this.getState() == DialogState.CONFIRMED && cseqMethod.equals("SUBSCRIBE") && this.pendingRouteUpdateOn202Response && sipResponse.getStatusCode() == 202)) {
                                if (this.getState() != DialogState.CONFIRMED) {
                                    this.setRemoteTag(sipResponse.getToTag());
                                    this.setDialogId(sipResponse.getDialogId(false));
                                    this.sipStack.putDialog(this);
                                    this.addRoute(sipResponse);
                                    this.setState(1);
                                }
                                if (cseqMethod.equals("SUBSCRIBE") && sipResponse.getStatusCode() == 202 && this.pendingRouteUpdateOn202Response) {
                                    this.setRemoteTag(sipResponse.getToTag());
                                    this.addRoute(sipResponse);
                                    this.pendingRouteUpdateOn202Response = false;
                                }
                            }
                            if (cseqMethod.equals("INVITE")) {
                                this.lastInviteOkReceived = Math.max(responseCSeqNumber, this.lastInviteOkReceived);
                            }
                        } else if (statusCode >= 300 && statusCode <= 699 && (this.getState() == null || cseqMethod.equals(this.getMethod()) && this.getState().getValue() == 0)) {
                            this.setState(3);
                        }
                        if (this.getState() == DialogState.CONFIRMED || this.getState() == DialogState.TERMINATED || this.getOriginalRequestRecordRouteHeaders() == null) break block63;
                        ListIterator it = this.getOriginalRequestRecordRouteHeaders().listIterator(this.getOriginalRequestRecordRouteHeaders().size());
                        while (it.hasPrevious()) {
                            RecordRoute rr = (RecordRoute)it.previous();
                            Route route = (Route)this.routeList.getFirst();
                            if (route != null && rr.getAddress().equals((Object)route.getAddress())) {
                                this.routeList.removeFirst();
                                continue;
                            }
                            break block63;
                        }
                        break block63;
                    }
                    if (cseqMethod.equals("NOTIFY") && (this.getMethod().equals("SUBSCRIBE") || this.getMethod().equals("REFER")) && sipResponse.getStatusCode() / 100 == 2 && this.getState() == null) {
                        this.setDialogId(sipResponse.getDialogId(true));
                        this.sipStack.putDialog(this);
                        this.setState(1);
                    } else if (cseqMethod.equals("BYE") && statusCode / 100 == 2 && this.isTerminatedOnBye()) {
                        this.setState(3);
                    }
                    break block63;
                }
                if (cseqMethod.equals("BYE") && statusCode / 100 == 2 && this.isTerminatedOnBye()) {
                    this.setState(3);
                } else {
                    boolean doPutDialog = false;
                    if (this.getLocalTag() == null && sipResponse.getTo().getTag() != null && SIPTransactionStack.isDialogCreated((String)cseqMethod) && cseqMethod.equals(this.getMethod())) {
                        this.setLocalTag(sipResponse.getTo().getTag());
                        doPutDialog = true;
                    }
                    if (statusCode / 100 != 2) {
                        if (statusCode / 100 == 1) {
                            if (doPutDialog) {
                                this.setState(0);
                                this.setDialogId(sipResponse.getDialogId(true));
                                this.sipStack.putDialog(this);
                            }
                        } else if (statusCode == 489 && (cseqMethod.equals("NOTIFY") || cseqMethod.equals("SUBSCRIBE"))) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("RFC 3265 : Not setting dialog to TERMINATED for 489");
                            }
                        } else if (!this.isReInvite() && this.getState() != DialogState.CONFIRMED) {
                            this.setState(3);
                        }
                    } else {
                        if (this.dialogState <= 0 && (cseqMethod.equals("INVITE") || cseqMethod.equals("SUBSCRIBE") || cseqMethod.equals("REFER"))) {
                            this.setState(1);
                        }
                        if (doPutDialog) {
                            this.setDialogId(sipResponse.getDialogId(true));
                            this.sipStack.putDialog(this);
                        }
                    }
                }
            }
            finally {
                if (sipResponse.getCSeq().getMethod().equals("INVITE") && transaction instanceof ClientTransaction && this.getState() != DialogState.TERMINATED) {
                    this.acquireTimerTaskSem();
                    try {
                        if (this.getState() == DialogState.EARLY) {
                            if (this.earlyStateTimerTask != null) {
                                this.sipStack.getTimer().cancel((SIPStackTimerTask)this.earlyStateTimerTask);
                            }
                            logger.logDebug("EarlyStateTimerTask craeted " + this.earlyDialogTimeout * 1000);
                            this.earlyStateTimerTask = new EarlyStateTimerTask(this);
                            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                                this.sipStack.getTimer().schedule((SIPStackTimerTask)this.earlyStateTimerTask, (long)(this.earlyDialogTimeout * 1000));
                            }
                        } else if (this.earlyStateTimerTask != null) {
                            this.sipStack.getTimer().cancel((SIPStackTimerTask)this.earlyStateTimerTask);
                            this.earlyStateTimerTask = null;
                        }
                    }
                    finally {
                        this.releaseTimerTaskSem();
                    }
                }
            }
        }
    }

    public void startRetransmitTimer(SIPServerTransaction sipServerTx, Response response) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("startRetransmitTimer() " + response.getStatusCode() + " method " + sipServerTx.getMethod());
        }
        if (sipServerTx.isInviteTransaction() && response.getStatusCode() / 100 == 2) {
            this.startTimer(sipServerTx);
        }
    }

    private void doTargetRefresh(SIPMessage sipMessage) {
        ContactList contactList = sipMessage.getContactHeaders();
        if (contactList != null) {
            Contact contact = (Contact)contactList.getFirst();
            this.setRemoteTarget((ContactHeader)contact);
        }
    }

    private static final boolean optionPresent(ListIterator l, String option) {
        while (l.hasNext()) {
            OptionTag opt = (OptionTag)l.next();
            if (opt == null || !option.equalsIgnoreCase(opt.getOptionTag())) continue;
            return true;
        }
        return false;
    }

    public Response createReliableProvisionalResponse(int statusCode) throws InvalidArgumentException, SipException {
        if (!this.firstTransactionIsServerTransaction) {
            throw new SipException("Not a Server Dialog!");
        }
        if (statusCode <= 100 || statusCode > 199) {
            throw new InvalidArgumentException("Bad status code ");
        }
        SIPRequest request = this.originalRequest;
        if (!request.getMethod().equals("INVITE")) {
            throw new SipException("Bad method");
        }
        ListIterator list = request.getHeaders("Supported");
        if (!(list != null && SIPDialog.optionPresent((ListIterator)list, (String)"100rel") || (list = request.getHeaders("Require")) != null && SIPDialog.optionPresent((ListIterator)list, (String)"100rel"))) {
            throw new SipException("No Supported/Require 100rel header in the request");
        }
        SIPResponse response = request.createResponse(statusCode);
        Require require = new Require();
        try {
            require.setOptionTag("100rel");
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException((Exception)ex);
        }
        response.addHeader((Header)require);
        RSeq rseq = new RSeq();
        rseq.setSeqNumber(1L);
        RecordRouteList rrl = request.getRecordRouteHeaders();
        if (rrl != null) {
            RecordRouteList rrlclone = (RecordRouteList)rrl.clone();
            response.setHeader((Header)rrlclone);
        }
        return response;
    }

    public boolean handlePrack(SIPRequest prackRequest) {
        if (!this.isServer()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- not a server Dialog");
            }
            return false;
        }
        SIPServerTransaction sipServerTransaction = (SIPServerTransaction)this.getFirstTransactionInt();
        byte[] sipResponse = sipServerTransaction.getReliableProvisionalResponse();
        if (sipResponse == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- ReliableResponse not found");
            }
            return false;
        }
        RAck rack = (RAck)prackRequest.getHeader("RAck");
        if (rack == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- rack header not found");
            }
            return false;
        }
        if (!rack.getMethod().equals(sipServerTransaction.getPendingReliableResponseMethod())) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- CSeq Header does not match PRACK");
            }
            return false;
        }
        if (rack.getCSeqNumberLong() != sipServerTransaction.getPendingReliableCSeqNumber()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- CSeq Header does not match PRACK");
            }
            return false;
        }
        if (rack.getRSequenceNumber() != sipServerTransaction.getPendingReliableRSeqNumber()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- RSeq Header does not match PRACK");
            }
            return false;
        }
        return sipServerTransaction.prackRecieved();
    }

    public void sendReliableProvisionalResponse(Response relResponse) throws SipException {
        if (!this.isServer()) {
            throw new SipException("Not a Server Dialog");
        }
        SIPResponse sipResponse = (SIPResponse)relResponse;
        if (relResponse.getStatusCode() == 100) {
            throw new SipException("Cannot send 100 as a reliable provisional response");
        }
        if (relResponse.getStatusCode() / 100 > 2) {
            throw new SipException("Response code is not a 1xx response - should be in the range 101 to 199 ");
        }
        if (sipResponse.getToTag() == null) {
            throw new SipException("Badly formatted response -- To tag mandatory for Reliable Provisional Response");
        }
        ListIterator requireList = relResponse.getHeaders("Require");
        boolean found = false;
        if (requireList != null) {
            while (requireList.hasNext() && !found) {
                RequireHeader rh = (RequireHeader)requireList.next();
                if (!rh.getOptionTag().equalsIgnoreCase("100rel")) continue;
                found = true;
            }
        }
        if (!found) {
            Require require = new Require("100rel");
            relResponse.addHeader((Header)require);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Require header with optionTag 100rel is needed -- adding one");
            }
        }
        SIPServerTransaction serverTransaction = (SIPServerTransaction)this.getFirstTransactionInt();
        this.setLastResponse((SIPTransaction)serverTransaction, sipResponse);
        this.setDialogId(sipResponse.getDialogId(true));
        serverTransaction.sendReliableProvisionalResponse(relResponse);
        this.startRetransmitTimer(serverTransaction, relResponse);
    }

    public void terminateOnBye(boolean terminateFlag) throws SipException {
        this.terminateOnBye = terminateFlag;
    }

    public void setAssigned() {
        this.isAssigned = true;
    }

    public boolean isAssigned() {
        return this.isAssigned;
    }

    public Contact getMyContactHeader() {
        if (this.contactHeader == null && this.contactHeaderStringified != null) {
            try {
                this.contactHeader = (Contact)new ContactParser(this.contactHeaderStringified).parse();
            }
            catch (ParseException e) {
                logger.logError("error reparsing the contact header", (Exception)e);
            }
        }
        return this.contactHeader;
    }

    public boolean handleAck(SIPServerTransaction ackTransaction) {
        if (this.isAckSeen() && this.getRemoteSeqNumber() == ackTransaction.getCSeq()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::handleAck: ACK already seen by dialog -- dropping Ack retransmission");
            }
            this.acquireTimerTaskSem();
            try {
                if (this.timerTask != null) {
                    this.getStack().getTimer().cancel((SIPStackTimerTask)this.timerTask);
                    this.timerTask = null;
                }
            }
            finally {
                this.releaseTimerTaskSem();
            }
            return false;
        }
        if (this.getState() == DialogState.TERMINATED) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::handleAck: Dialog is terminated -- dropping ACK");
            }
            return false;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::handleAck: lastResponseCSeqNumber = " + this.lastInviteOkReceived + " ackTxCSeq " + ackTransaction.getCSeq());
        }
        if (this.lastResponseStatusCode != null && this.lastResponseStatusCode / 100 == 2 && this.lastResponseMethod.equals("INVITE") && this.lastResponseCSeqNumber == ackTransaction.getCSeq()) {
            ackTransaction.setDialog(this, this.lastResponseDialogId);
            this.ackReceived(ackTransaction.getCSeq());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::handleACK: ACK for 2XX response --- sending to TU ");
            }
            return true;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(" INVITE transaction not found");
        }
        if (this.isBackToBackUserAgent()) {
            this.releaseAckSem();
        }
        return false;
    }

    String getEarlyDialogId() {
        return this.earlyDialogId;
    }

    void releaseAckSem() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("releaseAckSem-enter]]" + this + " sem=" + this.ackSem + " b2bua=" + this.isBackToBackUserAgent);
            logger.logStackTrace();
        }
        if (this.isBackToBackUserAgent) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("releaseAckSem]]" + this + " sem=" + this.ackSem);
                logger.logStackTrace();
            }
            if (this.ackSem.availablePermits() == 0) {
                this.ackSem.release();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("releaseAckSem]]" + this + " sem=" + this.ackSem);
                }
            }
        }
    }

    boolean isBlockedForReInvite() {
        return this.ackSem.availablePermits() == 0;
    }

    boolean takeAckSem() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("[takeAckSem " + this + " sem=" + this.ackSem);
        }
        try {
            if (!this.ackSem.tryAcquire(2L, TimeUnit.SECONDS)) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("Cannot aquire ACK semaphore ");
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Semaphore previously acquired at " + this.stackTrace + " sem=" + this.ackSem);
                    logger.logStackTrace();
                }
                return false;
            }
            if (logger.isLoggingEnabled(32)) {
                this.recordStackTrace();
            }
        }
        catch (InterruptedException ex) {
            logger.logError("Cannot aquire ACK semaphore");
            return false;
        }
        return true;
    }

    private void setLastAckSent(SIPRequest lastAckSent) {
        this.lastAckSent = lastAckSent;
        this.lastAckSent.setTransaction(null);
    }

    public boolean isAtleastOneAckSent() {
        return this.isAcknowledged;
    }

    public boolean isBackToBackUserAgent() {
        return this.isBackToBackUserAgent;
    }

    public synchronized void doDeferredDeleteIfNoAckSent(long seqno) {
        if (this.sipStack.getTimer() == null) {
            this.setState(3);
        } else if (this.dialogDeleteIfNoAckSentTask == null) {
            this.dialogDeleteIfNoAckSentTask = new DialogDeleteIfNoAckSentTask(this, seqno);
            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                this.sipStack.getTimer().schedule((SIPStackTimerTask)this.dialogDeleteIfNoAckSentTask, (long)(this.sipStack.getAckTimeoutFactor() * 500));
            }
        }
    }

    public void setBackToBackUserAgent() {
        this.isBackToBackUserAgent = true;
    }

    public EventHeader getEventHeader() {
        return this.eventHeader;
    }

    void setEventHeader(EventHeader eventHeader) {
        this.eventHeader = eventHeader;
    }

    void setServerTransactionFlag(boolean serverTransactionFlag) {
        this.serverTransactionFlag = serverTransactionFlag;
    }

    protected void setReInviteFlag(boolean reInviteFlag) {
        this.reInviteFlag = reInviteFlag;
    }

    public boolean isSequnceNumberValidation() {
        return this.sequenceNumberValidation;
    }

    public void disableSequenceNumberValidation() {
        this.sequenceNumberValidation = false;
    }

    public void acquireTimerTaskSem() {
        boolean acquired = false;
        try {
            acquired = this.timerTaskLock.tryAcquire(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            acquired = false;
        }
        if (!acquired) {
            throw new IllegalStateException("Impossible to acquire the dialog timer task lock");
        }
    }

    public void releaseTimerTaskSem() {
        this.timerTaskLock.release();
    }

    public String getMergeId() {
        return this.firstTransactionMergeId;
    }

    public void setPendingRouteUpdateOn202Response(SIPRequest sipRequest) {
        this.pendingRouteUpdateOn202Response = true;
        String fromTag = sipRequest.getFromHeader().getTag();
        if (fromTag != null) {
            this.setRemoteTag(fromTag);
        }
    }

    public String getLastResponseMethod() {
        return this.lastResponseMethod;
    }

    public Integer getLastResponseStatusCode() {
        return this.lastResponseStatusCode;
    }

    public long getLastResponseCSeqNumber() {
        return this.lastResponseCSeqNumber;
    }

    protected void cleanUpOnAck() {
        if (this.isReleaseReferences()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("cleanupOnAck : " + this.getDialogId());
            }
            if (this.originalRequest != null) {
                if (this.originalRequestRecordRouteHeaders != null) {
                    this.originalRequestRecordRouteHeadersString = this.originalRequestRecordRouteHeaders.toString();
                }
                this.originalRequestRecordRouteHeaders = null;
                this.originalRequest = null;
            }
            if (this.firstTransaction != null) {
                if (this.firstTransaction.getOriginalRequest() != null) {
                    this.firstTransaction.getOriginalRequest().cleanUp();
                }
                this.firstTransaction = null;
            }
            if (this.lastTransaction != null) {
                if (this.lastTransaction.getOriginalRequest() != null) {
                    this.lastTransaction.getOriginalRequest().cleanUp();
                }
                this.lastTransaction = null;
            }
            if (this.callIdHeader != null) {
                this.callIdHeaderString = this.callIdHeader.toString();
                this.callIdHeader = null;
            }
            if (this.contactHeader != null) {
                this.contactHeaderStringified = this.contactHeader.toString();
                this.contactHeader = null;
            }
            if (this.remoteTarget != null) {
                this.remoteTargetStringified = this.remoteTarget.toString();
                this.remoteTarget = null;
            }
            if (this.remoteParty != null) {
                this.remotePartyStringified = this.remoteParty.toString();
                this.remoteParty = null;
            }
            if (this.localParty != null) {
                this.localPartyStringified = this.localParty.toString();
                this.localParty = null;
            }
        }
    }

    protected void cleanUp() {
        if (this.isReleaseReferences()) {
            this.cleanUpOnAck();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("dialog cleanup : " + this.getDialogId());
            }
            if (this.eventListeners != null) {
                this.eventListeners.clear();
            }
            this.timerTaskLock = null;
            this.ackSem = null;
            this.contactHeader = null;
            this.eventHeader = null;
            this.firstTransactionId = null;
            this.firstTransactionMethod = null;
            this.lastResponseDialogId = null;
            this.lastResponseMethod = null;
            this.lastResponseTopMostVia = null;
            if (this.originalRequestRecordRouteHeaders != null) {
                this.originalRequestRecordRouteHeaders.clear();
                this.originalRequestRecordRouteHeaders = null;
                this.originalRequestRecordRouteHeadersString = null;
            }
            if (this.routeList != null) {
                this.routeList.clear();
                this.routeList = null;
            }
            this.responsesReceivedInForkingCase.clear();
        }
    }

    protected RecordRouteList getOriginalRequestRecordRouteHeaders() {
        if (this.originalRequestRecordRouteHeaders == null && this.originalRequestRecordRouteHeadersString != null) {
            try {
                this.originalRequestRecordRouteHeaders = (RecordRouteList)new RecordRouteParser(this.originalRequestRecordRouteHeadersString).parse();
            }
            catch (ParseException e) {
                logger.logError("error reparsing the originalRequest RecordRoute Headers", (Exception)e);
            }
            this.originalRequestRecordRouteHeadersString = null;
        }
        return this.originalRequestRecordRouteHeaders;
    }

    public Via getLastResponseTopMostVia() {
        return this.lastResponseTopMostVia;
    }

    public boolean isReleaseReferences() {
        return this.releaseReferences;
    }

    public void setReleaseReferences(boolean releaseReferences) {
        this.releaseReferences = releaseReferences;
    }

    public void setEarlyDialogTimeoutSeconds(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("Invalid value " + seconds);
        }
        this.earlyDialogTimeout = seconds;
    }

    public void checkRetransmissionForForking(SIPResponse response) {
        int statusCode = response.getStatusCode();
        String responseMethod = response.getCSeqHeader().getMethod();
        long responseCSeqNumber = response.getCSeq().getSeqNumber();
        boolean isRetransmission = !this.responsesReceivedInForkingCase.add(statusCode + "/" + responseCSeqNumber + "/" + responseMethod);
        response.setRetransmission(isRetransmission);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("marking response as retransmission " + isRetransmission + " for dialog " + this);
        }
    }

    static /* synthetic */ void access$000(SIPDialog x0, int x1) {
        x0.raiseErrorEvent(x1);
    }

    static /* synthetic */ StackLogger access$100() {
        return logger;
    }

    static /* synthetic */ SipProviderImpl access$200(SIPDialog x0) {
        return x0.sipProvider;
    }

    static /* synthetic */ void access$300(SIPDialog x0, int x1, SIPClientTransaction x2) {
        x0.raiseErrorEvent(x1, x2);
    }

    static /* synthetic */ SIPTransactionStack access$400(SIPDialog x0) {
        return x0.sipStack;
    }

    static /* synthetic */ boolean access$500(SIPDialog x0, int x1) {
        return x0.toRetransmitFinalResponse(x1);
    }

    static /* synthetic */ void access$600(SIPDialog x0, String x1, int x2, String x3) {
        x0.raiseIOException(x1, x2, x3);
    }

    static /* synthetic */ int access$700(SIPDialog x0) {
        return x0.dialogState;
    }

    static /* synthetic */ long access$800(SIPDialog x0) {
        return x0.highestSequenceNumberAcknowledged;
    }

    static /* synthetic */ DialogDeleteIfNoAckSentTask access$902(SIPDialog x0, DialogDeleteIfNoAckSentTask x1) {
        x0.dialogDeleteIfNoAckSentTask = x1;
        return x0.dialogDeleteIfNoAckSentTask;
    }
}

