/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.javax.sip.stack.MessageProcessor;
import com.coraltele.javax.sip.stack.MessageProcessorFactory;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import com.coraltele.javax.sip.stack.TCPMessageProcessor;
import com.coraltele.javax.sip.stack.TLSMessageProcessor;
import com.coraltele.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;

public class OIOMessageProcessorFactory
implements MessageProcessorFactory {
    public MessageProcessor createMessageProcessor(SIPTransactionStack sipStack, InetAddress ipAddress, int port, String transport) throws IOException {
        if (transport.equalsIgnoreCase("UDP")) {
            UDPMessageProcessor udpMessageProcessor = new UDPMessageProcessor(ipAddress, sipStack, port);
            sipStack.udpFlag = true;
            return udpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("TCP")) {
            TCPMessageProcessor tcpMessageProcessor = new TCPMessageProcessor(ipAddress, sipStack, port);
            return tcpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("TLS")) {
            TLSMessageProcessor tlsMessageProcessor = new TLSMessageProcessor(ipAddress, sipStack, port);
            return tlsMessageProcessor;
        }
        if (transport.equalsIgnoreCase("SCTP")) {
            try {
                Class<?> mpc = ClassLoader.getSystemClassLoader().loadClass("gov.nist.javax.sip.stack.sctp.SCTPMessageProcessor");
                MessageProcessor mp = (MessageProcessor)mpc.newInstance();
                mp.initialize(ipAddress, port, sipStack);
                return mp;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("SCTP not supported (needs Java 7 and SCTP jar in classpath)");
            }
            catch (InstantiationException ie) {
                throw new IllegalArgumentException("Error initializing SCTP", ie);
            }
            catch (IllegalAccessException ie) {
                throw new IllegalArgumentException("Error initializing SCTP", ie);
            }
        }
        throw new IllegalArgumentException("bad transport");
    }
}

