/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.Host;
import com.coraltele.core.HostPort;
import com.coraltele.core.InternalErrorHandler;
import com.coraltele.core.StackLogger;
import com.coraltele.interfaces.sip.address.Hop;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.ServerHeader;
import com.coraltele.javax.sip.address.AddressImpl;
import com.coraltele.javax.sip.header.ContentLength;
import com.coraltele.javax.sip.header.ContentType;
import com.coraltele.javax.sip.header.Via;
import com.coraltele.javax.sip.message.MessageFactoryImpl;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.MessageProcessor;
import com.coraltele.javax.sip.stack.RawMessageChannel;
import com.coraltele.javax.sip.stack.SIPClientTransaction;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import com.coraltele.javax.sip.stack.UDPMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class MessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(MessageChannel.class);
    protected int useCount;
    protected transient MessageProcessor messageProcessor;
    private SIPClientTransaction encapsulatedClientTransaction;

    protected void uncache() {
    }

    public abstract void close();

    public abstract SIPTransactionStack getSIPStack();

    public abstract String getTransport();

    public abstract boolean isReliable();

    public abstract boolean isSecure();

    public abstract void sendMessage(SIPMessage var1) throws IOException;

    public abstract String getPeerAddress();

    protected abstract InetAddress getPeerInetAddress();

    protected abstract String getPeerProtocol();

    public abstract int getPeerPort();

    public abstract int getPeerPacketSourcePort();

    public abstract InetAddress getPeerPacketSourceAddress();

    public abstract String getKey();

    public abstract String getViaHost();

    public abstract int getViaPort();

    protected abstract void sendMessage(byte[] var1, InetAddress var2, int var3, boolean var4) throws IOException;

    public String getHost() {
        return this.getMessageProcessor().getIpAddress().getHostAddress();
    }

    public int getPort() {
        if (this.messageProcessor != null) {
            return this.messageProcessor.getPort();
        }
        return -1;
    }

    public void sendMessage(SIPMessage sipMessage, Hop hop) throws IOException {
        long time = System.currentTimeMillis();
        InetAddress hopAddr = InetAddress.getByName(hop.getHost());
        try {
            for (MessageProcessor messageProcessor : this.getSIPStack().getMessageProcessors()) {
                MessageChannel messageChannel;
                if (!messageProcessor.getIpAddress().equals(hopAddr) || messageProcessor.getPort() != hop.getPort() || !messageProcessor.getTransport().equalsIgnoreCase(hop.getTransport()) || !((messageChannel = messageProcessor.createMessageChannel(hopAddr, hop.getPort())) instanceof RawMessageChannel)) continue;
                RawMessageChannel channel = (RawMessageChannel)messageChannel;
                1 processMessageTask = new /* Unavailable Anonymous Inner Class!! */;
                this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute((Runnable)processMessageTask);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Self routing message");
                }
                return;
            }
            byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
            this.sendMessage(msg, hopAddr, hop.getPort(), sipMessage instanceof SIPRequest);
            sipMessage.setRemoteAddress(hopAddr);
            sipMessage.setRemotePort(hop.getPort());
            sipMessage.setLocalPort(this.getPort());
            sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            if (logger.isLoggingEnabled(4)) {
                logger.logError("Error self routing message cause by: ", ex);
            }
            throw new IOException("Error self routing message");
        }
        finally {
            if (logger.isLoggingEnabled(16)) {
                this.logMessage(sipMessage, hopAddr, hop.getPort(), time);
            }
        }
    }

    public void sendMessage(SIPMessage sipMessage, InetAddress receiverAddress, int receiverPort) throws IOException {
        long time = System.currentTimeMillis();
        byte[] bytes = sipMessage.encodeAsBytes(this.getTransport());
        this.sendMessage(bytes, receiverAddress, receiverPort, sipMessage instanceof SIPRequest);
        sipMessage.setRemoteAddress(receiverAddress);
        sipMessage.setRemotePort(receiverPort);
        sipMessage.setLocalPort(this.getPort());
        sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        this.logMessage(sipMessage, receiverAddress, receiverPort, time);
    }

    public String getRawIpSourceAddress() {
        String sourceAddress = this.getPeerAddress();
        String rawIpSourceAddress = null;
        try {
            InetAddress sourceInetAddress = InetAddress.getByName(sourceAddress);
            rawIpSourceAddress = sourceInetAddress.getHostAddress();
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException((Exception)ex);
        }
        return rawIpSourceAddress;
    }

    public static String getKey(InetAddress inetAddr, int port, String transport) {
        return (transport + ":" + inetAddr.getHostAddress() + ":" + port).toLowerCase();
    }

    public static String getKey(HostPort hostPort, String transport) {
        return (transport + ":" + hostPort.getHost().getHostname() + ":" + hostPort.getPort()).toLowerCase();
    }

    public HostPort getHostPort() {
        HostPort retval = new HostPort();
        retval.setHost(new Host(this.getHost()));
        retval.setPort(this.getPort());
        return retval;
    }

    public HostPort getPeerHostPort() {
        HostPort retval = new HostPort();
        retval.setHost(new Host(this.getPeerAddress()));
        retval.setPort(this.getPeerPort());
        return retval;
    }

    public Via getViaHeader() {
        Via channelViaHeader = new Via();
        try {
            channelViaHeader.setTransport(this.getTransport());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        channelViaHeader.setSentBy(this.getHostPort());
        return channelViaHeader;
    }

    public HostPort getViaHostPort() {
        HostPort retval = new HostPort();
        retval.setHost(new Host(this.getViaHost()));
        retval.setPort(this.getViaPort());
        return retval;
    }

    public void logMessage(SIPMessage sipMessage, InetAddress address, int port, long time) {
        if (!logger.isLoggingEnabled(16)) {
            return;
        }
        if (port == -1) {
            port = 5060;
        }
        this.getSIPStack().serverLogger.logMessage(sipMessage, this.getHost() + ":" + this.getPort(), address.getHostAddress().toString() + ":" + port, true, time);
    }

    public void logResponse(SIPResponse sipResponse, long receptionTime, String status) {
        int peerport = this.getPeerPort();
        if (peerport == 0 && sipResponse.getContactHeaders() != null) {
            ContactHeader contact = (ContactHeader)sipResponse.getContactHeaders().getFirst();
            peerport = ((AddressImpl)contact.getAddress()).getPort();
        }
        String from = this.getPeerAddress().toString() + ":" + peerport;
        String to = this.getHost() + ":" + this.getPort();
        this.getSIPStack().serverLogger.logMessage((SIPMessage)sipResponse, from, to, status, false, receptionTime);
    }

    protected final String createBadReqRes(String badReq, ParseException pe) {
        ServerHeader s;
        StringBuilder buf = new StringBuilder(512);
        buf.append("SIP/2.0 400 Bad Request (" + pe.getLocalizedMessage() + ')');
        if (!MessageChannel.copyViaHeaders((String)badReq, (StringBuilder)buf)) {
            return null;
        }
        if (!MessageChannel.copyHeader((String)"CSeq", (String)badReq, (StringBuilder)buf)) {
            return null;
        }
        if (!MessageChannel.copyHeader((String)"Call-ID", (String)badReq, (StringBuilder)buf)) {
            return null;
        }
        if (!MessageChannel.copyHeader((String)"From", (String)badReq, (StringBuilder)buf)) {
            return null;
        }
        if (!MessageChannel.copyHeader((String)"To", (String)badReq, (StringBuilder)buf)) {
            return null;
        }
        int toStart = buf.indexOf("To");
        if (toStart != -1 && buf.indexOf("tag", toStart) == -1) {
            buf.append(";tag=badreq");
        }
        if ((s = MessageFactoryImpl.getDefaultServerHeader()) != null) {
            buf.append("\r\n" + s.toString());
        }
        int clength = badReq.length();
        if (!(this instanceof UDPMessageChannel) || clength + buf.length() + "Content-Type".length() + ": message/sipfrag\r\n".length() + "Content-Length".length() < 1300) {
            ContentType cth = new ContentType("message", "sipfrag");
            buf.append("\r\n" + cth.toString());
            ContentLength clengthHeader = new ContentLength(clength);
            buf.append("\r\n" + clengthHeader.toString());
            buf.append("\r\n\r\n" + badReq);
        } else {
            ContentLength clengthHeader = new ContentLength(0);
            buf.append("\r\n" + clengthHeader.toString());
        }
        return buf.toString();
    }

    private static final boolean copyHeader(String name, String fromReq, StringBuilder buf) {
        int end;
        int start = fromReq.indexOf(name);
        if (start != -1 && (end = fromReq.indexOf("\r\n", start)) != -1) {
            buf.append(fromReq.subSequence(start - 2, end));
            return true;
        }
        return false;
    }

    private static final boolean copyViaHeaders(String fromReq, StringBuilder buf) {
        int start = fromReq.indexOf("Via");
        boolean found = false;
        while (start != -1) {
            int end = fromReq.indexOf("\r\n", start);
            if (end != -1) {
                buf.append(fromReq.subSequence(start - 2, end));
                found = true;
                start = fromReq.indexOf("Via", end);
                continue;
            }
            return false;
        }
        return found;
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public SIPClientTransaction getEncapsulatedClientTransaction() {
        return this.encapsulatedClientTransaction;
    }

    public void setEncapsulatedClientTransaction(SIPClientTransaction transaction) {
        this.encapsulatedClientTransaction = transaction;
    }

    static /* synthetic */ StackLogger access$000() {
        return logger;
    }
}

