/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.StackLogger;
import com.coraltele.javax.sip.ClientTransactionExt;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.stack.HandshakeCompletedListenerImpl;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import com.coraltele.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;

/*
 * Exception performing whole class analysis ignored.
 */
public class IOHandler {
    private static StackLogger logger = CommonLogger.getLogger(IOHandler.class);
    private SipStackImpl sipStack;
    private static final String TCP = "tcp";
    private static final String TLS = "tls";
    private final ConcurrentHashMap<String, Socket> socketTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Semaphore> socketCreationMap = new ConcurrentHashMap();

    protected static String makeKey(InetAddress addr, int port) {
        return addr.getHostAddress() + ":" + port;
    }

    protected static String makeKey(String addr, int port) {
        return addr + ":" + port;
    }

    protected IOHandler(SIPTransactionStack sipStack) {
        this.sipStack = (SipStackImpl)sipStack;
    }

    protected void putSocket(String key, Socket sock) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("adding socket for key " + key);
        }
        this.socketTable.put(key, sock);
    }

    protected Socket getSocket(String key) {
        return (Socket)this.socketTable.get(key);
    }

    protected void removeSocket(String key) {
        this.socketTable.remove(key);
        this.socketCreationMap.remove(key);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("removed Socket and Semaphore for key " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunks(OutputStream outputStream, byte[] bytes, int length) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            int chunksize = 8192;
            for (int p = 0; p < length; p += chunksize) {
                int chunk = p + chunksize < length ? chunksize : length - p;
                outputStream.write(bytes, p, chunk);
            }
        }
        outputStream.flush();
    }

    public SocketAddress getLocalAddressForTcpDst(InetAddress dst, int dstPort, InetAddress localAddress, int localPort) throws IOException {
        String key = IOHandler.makeKey((InetAddress)dst, (int)dstPort);
        Socket clientSock = this.getSocket(key);
        if (clientSock == null) {
            clientSock = this.sipStack.getNetworkLayer().createSocket(dst, dstPort, localAddress, localPort);
            this.putSocket(key, clientSock);
        }
        return clientSock.getLocalSocketAddress();
    }

    public SocketAddress getLocalAddressForTlsDst(InetAddress dst, int dstPort, InetAddress localAddress, TLSMessageChannel channel) throws IOException {
        String key = IOHandler.makeKey((InetAddress)dst, (int)dstPort);
        Socket clientSock = this.getSocket(key);
        if (clientSock == null) {
            clientSock = this.sipStack.getNetworkLayer().createSSLSocket(dst, dstPort, localAddress);
            SSLSocket sslsock = (SSLSocket)clientSock;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("inaddr = " + dst);
                logger.logDebug("port = " + dstPort);
            }
            HandshakeCompletedListenerImpl listner = new HandshakeCompletedListenerImpl(channel);
            channel.setHandshakeCompletedListener((HandshakeCompletedListener)listner);
            sslsock.addHandshakeCompletedListener((HandshakeCompletedListener)listner);
            sslsock.setEnabledProtocols(this.sipStack.getEnabledProtocols());
            sslsock.startHandshake();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Handshake passed");
            }
            try {
                this.sipStack.getTlsSecurityPolicy().enforceTlsPolicy((ClientTransactionExt)channel.getEncapsulatedClientTransaction());
            }
            catch (SecurityException ex) {
                throw new IOException(ex.getMessage());
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("TLS Security policy passed");
            }
            this.putSocket(key, clientSock);
        }
        return clientSock.getLocalSocketAddress();
    }

    public Socket sendBytes(InetAddress senderAddress, InetAddress receiverAddress, int contactPort, String transport, byte[] bytes, boolean isClient, MessageChannel messageChannel) throws IOException {
        int retry_count = 0;
        int max_retry = isClient ? 2 : 1;
        int length = bytes.length;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendBytes " + transport + " inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " length = " + length + " isClient " + isClient);
        }
        if (logger.isLoggingEnabled(16) && this.sipStack.isLogStackTraceOnMessageSend()) {
            logger.logStackTrace(16);
        }
        if (transport.compareToIgnoreCase("tcp") == 0) {
            String key = IOHandler.makeKey((InetAddress)receiverAddress, (int)contactPort);
            Socket clientSock = null;
            this.enterIOCriticalSection(key);
            try {
                clientSock = this.getSocket(key);
                while (retry_count < max_retry) {
                    if (clientSock == null) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("inaddr = " + receiverAddress);
                            logger.logDebug("port = " + contactPort);
                        }
                        try {
                            clientSock = this.sipStack.getNetworkLayer().createSocket(receiverAddress, contactPort, senderAddress);
                        }
                        catch (SocketException e) {
                            logger.logError("Problem connecting " + receiverAddress + " " + contactPort + " " + senderAddress + " for message " + new String(bytes, "UTF-8"));
                            this.removeSocket(key);
                            throw new SocketException(e.getClass() + " " + e.getMessage() + " " + e.getCause() + " Problem connecting " + receiverAddress + " " + contactPort + " " + senderAddress + " for message " + new String(bytes, "UTF-8"));
                        }
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        this.putSocket(key, clientSock);
                        break;
                    }
                    try {
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        break;
                    }
                    catch (IOException ex) {
                        if (logger.isLoggingEnabled(8)) {
                            logger.logWarning("IOException occured retryCount " + retry_count);
                        }
                        try {
                            clientSock.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        clientSock = null;
                        ++retry_count;
                        if (!isClient) {
                            this.removeSocket(key);
                            throw ex;
                        }
                        if (retry_count >= max_retry) {
                            this.removeSocket(key);
                            continue;
                        }
                        this.socketTable.remove(key);
                    }
                }
            }
            catch (IOException ex) {
                if (logger.isLoggingEnabled(4)) {
                    logger.logError("Problem sending: sendBytes " + transport + " inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " remoteHost " + messageChannel.getPeerAddress() + " remotePort " + messageChannel.getPeerPort() + " peerPacketPort " + messageChannel.getPeerPacketSourcePort() + " isClient " + isClient);
                }
                this.removeSocket(key);
                if (!isClient) {
                    receiverAddress = InetAddress.getByName(messageChannel.getViaHost());
                    contactPort = messageChannel.getViaPort();
                    if (contactPort == -1) {
                        contactPort = 5060;
                    }
                    if ((clientSock = this.getSocket(key = IOHandler.makeKey((InetAddress)receiverAddress, (int)messageChannel.getViaPort()))) == null) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("inaddr = " + receiverAddress + " port = " + contactPort);
                        }
                        clientSock = this.sipStack.getNetworkLayer().createSocket(receiverAddress, contactPort, senderAddress);
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        this.putSocket(key, clientSock);
                        Socket socket = clientSock;
                        return socket;
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("sending to " + key);
                    }
                    try {
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        Socket socket = clientSock;
                        return socket;
                    }
                    catch (IOException ioe) {
                        if (logger.isLoggingEnabled(4)) {
                            logger.logError("IOException occured  ", (Exception)ioe);
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Removing and Closing socket");
                        }
                        this.removeSocket(key);
                        try {
                            clientSock.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        clientSock = null;
                        throw ioe;
                    }
                }
                logger.logError("IOException occured at ", (Exception)ex);
                throw ex;
            }
            finally {
                this.leaveIOCriticalSection(key);
            }
            if (clientSock == null) {
                if (logger.isLoggingEnabled(4)) {
                    logger.logError(this.socketTable.toString());
                    logger.logError("Could not connect to " + receiverAddress + ":" + contactPort);
                }
                throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
            }
            return clientSock;
        }
        if (transport.compareToIgnoreCase("tls") == 0) {
            String key = IOHandler.makeKey((InetAddress)receiverAddress, (int)contactPort);
            Socket clientSock = null;
            this.enterIOCriticalSection(key);
            try {
                clientSock = this.getSocket(key);
                while (retry_count < max_retry) {
                    if (clientSock == null) {
                        clientSock = this.sipStack.getNetworkLayer().createSSLSocket(receiverAddress, contactPort, senderAddress);
                        SSLSocket sslsock = (SSLSocket)clientSock;
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("inaddr = " + receiverAddress);
                            logger.logDebug("port = " + contactPort);
                        }
                        HandshakeCompletedListenerImpl listner = new HandshakeCompletedListenerImpl((TLSMessageChannel)messageChannel);
                        ((TLSMessageChannel)messageChannel).setHandshakeCompletedListener((HandshakeCompletedListener)listner);
                        sslsock.addHandshakeCompletedListener((HandshakeCompletedListener)listner);
                        sslsock.setEnabledProtocols(this.sipStack.getEnabledProtocols());
                        sslsock.startHandshake();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Handshake passed");
                        }
                        try {
                            this.sipStack.getTlsSecurityPolicy().enforceTlsPolicy((ClientTransactionExt)messageChannel.getEncapsulatedClientTransaction());
                        }
                        catch (SecurityException ex) {
                            throw new IOException(ex.getMessage());
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("TLS Security policy passed");
                        }
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        this.putSocket(key, clientSock);
                        break;
                    }
                    try {
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        break;
                    }
                    catch (IOException ex) {
                        if (logger.isLoggingEnabled()) {
                            logger.logException((Throwable)ex);
                        }
                        this.removeSocket(key);
                        try {
                            logger.logDebug("Closing socket");
                            clientSock.close();
                        }
                        catch (Exception listner) {
                            // empty catch block
                        }
                        clientSock = null;
                        ++retry_count;
                    }
                }
            }
            catch (SSLHandshakeException ex) {
                this.removeSocket(key);
                throw ex;
            }
            catch (IOException ex) {
                this.removeSocket(key);
                if (!isClient) {
                    receiverAddress = InetAddress.getByName(messageChannel.getViaHost());
                    contactPort = messageChannel.getViaPort();
                    if (contactPort == -1) {
                        contactPort = 5060;
                    }
                    if ((clientSock = this.getSocket(key = IOHandler.makeKey((InetAddress)receiverAddress, (int)messageChannel.getViaPort()))) == null) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("inaddr = " + receiverAddress + " port = " + contactPort);
                        }
                        SSLSocket sslsock = this.sipStack.getNetworkLayer().createSSLSocket(receiverAddress, contactPort, senderAddress);
                        OutputStream outputStream = sslsock.getOutputStream();
                        HandshakeCompletedListenerImpl listner = new HandshakeCompletedListenerImpl((TLSMessageChannel)messageChannel);
                        ((TLSMessageChannel)messageChannel).setHandshakeCompletedListener((HandshakeCompletedListener)listner);
                        sslsock.addHandshakeCompletedListener((HandshakeCompletedListener)listner);
                        sslsock.setEnabledProtocols(this.sipStack.getEnabledProtocols());
                        sslsock.startHandshake();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Handshake passed");
                        }
                        this.writeChunks(outputStream, bytes, length);
                        this.putSocket(key, clientSock);
                        SSLSocket sSLSocket = sslsock;
                        return sSLSocket;
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("sending to " + key);
                    }
                    try {
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        Socket socket = clientSock;
                        return socket;
                    }
                    catch (IOException ioe) {
                        if (logger.isLoggingEnabled(4)) {
                            logger.logError("IOException occured  ", (Exception)ioe);
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Removing and Closing socket");
                        }
                        this.removeSocket(key);
                        try {
                            clientSock.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        clientSock = null;
                        throw ioe;
                    }
                }
                throw ex;
            }
            finally {
                this.leaveIOCriticalSection(key);
            }
            if (clientSock == null) {
                throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
            }
            return clientSock;
        }
        DatagramSocket datagramSock = this.sipStack.getNetworkLayer().createDatagramSocket();
        datagramSock.connect(receiverAddress, contactPort);
        DatagramPacket dgPacket = new DatagramPacket(bytes, 0, length, receiverAddress, contactPort);
        datagramSock.send(dgPacket);
        datagramSock.close();
        return null;
    }

    private void leaveIOCriticalSection(String key) {
        Semaphore creationSemaphore = (Semaphore)this.socketCreationMap.get(key);
        if (creationSemaphore != null) {
            creationSemaphore.release();
        }
    }

    private void enterIOCriticalSection(String key) throws IOException {
        Semaphore newCreationSemaphore;
        Semaphore creationSemaphore = (Semaphore)this.socketCreationMap.get(key);
        if (creationSemaphore == null && (creationSemaphore = this.socketCreationMap.putIfAbsent(key, newCreationSemaphore = new Semaphore(1, true))) == null) {
            creationSemaphore = newCreationSemaphore;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("new Semaphore added for key " + key);
            }
        }
        try {
            boolean retval = creationSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
            if (!retval) {
                throw new IOException("Could not acquire IO Semaphore'" + key + "' after 10 seconds -- giving up ");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("exception in acquiring sem");
        }
    }

    public void closeAll() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Closing " + this.socketTable.size() + " sockets from IOHandler");
        }
        Enumeration values = this.socketTable.elements();
        while (values.hasMoreElements()) {
            Socket s = (Socket)values.nextElement();
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }
}

