/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.InternalErrorHandler;
import com.coraltele.core.StackLogger;
import com.coraltele.core.net.AddressResolver;
import com.coraltele.interfaces.sip.SipException;
import com.coraltele.interfaces.sip.SipStack;
import com.coraltele.interfaces.sip.address.Hop;
import com.coraltele.interfaces.sip.address.Router;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.ViaHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.javax.sip.address.AddressImpl;
import com.coraltele.javax.sip.address.GenericURI;
import com.coraltele.javax.sip.address.SipUri;
import com.coraltele.javax.sip.header.RequestLine;
import com.coraltele.javax.sip.header.Route;
import com.coraltele.javax.sip.header.RouteList;
import com.coraltele.javax.sip.header.SIPHeader;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.stack.HopImpl;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import java.util.LinkedList;
import java.util.ListIterator;

public class DefaultRouter
implements Router {
    private static StackLogger logger = CommonLogger.getLogger(DefaultRouter.class);
    private SIPTransactionStack sipStack;
    private Hop defaultRoute;

    private DefaultRouter() {
    }

    public DefaultRouter(SipStack sipStack, String defaultRoute) {
        this.sipStack = (SIPTransactionStack)sipStack;
        if (defaultRoute != null) {
            try {
                this.defaultRoute = this.sipStack.getAddressResolver().resolveAddress((Hop)new HopImpl(defaultRoute));
            }
            catch (IllegalArgumentException ex) {
                logger.logError("Invalid default route specification - need host:port/transport");
                throw ex;
            }
        }
    }

    public Hop getNextHop(Request request) throws SipException {
        SIPRequest sipRequest = (SIPRequest)request;
        RequestLine requestLine = sipRequest.getRequestLine();
        if (requestLine == null) {
            return this.defaultRoute;
        }
        GenericURI requestURI = requestLine.getUri();
        if (requestURI == null) {
            throw new IllegalArgumentException("Bad message: Null requestURI");
        }
        RouteList routes = sipRequest.getRouteHeaders();
        if (routes != null) {
            Route route = (Route)routes.getFirst();
            URI uri = route.getAddress().getURI();
            if (uri.isSipURI()) {
                SipURI sipUri = (SipURI)uri;
                if (!sipUri.hasLrParam()) {
                    this.fixStrictRouting(sipRequest);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Route post processing fixed strict routing");
                    }
                }
                Hop hop = this.createHop(sipUri, request);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("NextHop based on Route:" + hop);
                }
                return hop;
            }
            throw new SipException("First Route not a SIP URI");
        }
        if (requestURI.isSipURI() && ((SipURI)requestURI).getMAddrParam() != null) {
            Hop hop = this.createHop((SipURI)requestURI, request);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Using request URI maddr to route the request = " + hop.toString());
            }
            return hop;
        }
        if (this.defaultRoute != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Using outbound proxy to route the request = " + this.defaultRoute.toString());
            }
            return this.defaultRoute;
        }
        if (requestURI.isSipURI()) {
            Hop hop = this.createHop((SipURI)requestURI, request);
            if (hop != null && logger.isLoggingEnabled(32)) {
                logger.logDebug("Used request-URI for nextHop = " + hop.toString());
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("returning null hop -- loop detected");
            }
            return hop;
        }
        InternalErrorHandler.handleException((String)"Unexpected non-sip URI", (StackLogger)logger);
        return null;
    }

    public void fixStrictRouting(SIPRequest req) {
        RouteList routes = req.getRouteHeaders();
        Route first = (Route)routes.getFirst();
        SipUri firstUri = (SipUri)first.getAddress().getURI();
        routes.removeFirst();
        AddressImpl addr = new AddressImpl();
        addr.setAddess(req.getRequestURI());
        Route route = new Route(addr);
        routes.add((SIPHeader)route);
        req.setRequestURI((URI)firstUri);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("post: fixStrictRouting" + req);
        }
    }

    protected final Hop createHop(SipURI sipUri, Request request) {
        ViaHeader via;
        String transport;
        String string = transport = sipUri.isSecure() ? "tls" : sipUri.getTransportParam();
        if (transport == null && (via = (ViaHeader)request.getHeader("Via")) != null) {
            transport = via.getTransport();
        }
        int port = sipUri.getPort() != -1 ? sipUri.getPort() : (transport.equalsIgnoreCase("tls") ? 5061 : 5060);
        String host = sipUri.getMAddrParam() != null ? sipUri.getMAddrParam() : sipUri.getHost();
        AddressResolver addressResolver = this.sipStack.getAddressResolver();
        return addressResolver.resolveAddress((Hop)new HopImpl(host, port, transport));
    }

    public Hop getOutboundProxy() {
        return this.defaultRoute;
    }

    public ListIterator getNextHops(Request request) {
        try {
            LinkedList<Hop> llist = new LinkedList<Hop>();
            llist.add(this.getNextHop(request));
            return llist.listIterator();
        }
        catch (SipException ex) {
            return null;
        }
    }
}

