/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.StackLogger;
import com.coraltele.interfaces.sip.SipStack;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.SIPMessageValve;
import java.io.IOException;

public class CongestionControlMessageValve
implements SIPMessageValve {
    private static StackLogger logger = CommonLogger.getLogger(CongestionControlMessageValve.class);
    protected SipStackImpl sipStack;
    protected int serverTransactionTableHighwaterMark;
    protected int dropResponseStatus;

    public boolean processRequest(SIPRequest request, MessageChannel messageChannel) {
        boolean undropableMethod;
        String requestMethod = request.getMethod();
        boolean bl = undropableMethod = requestMethod.equals("BYE") || requestMethod.equals("ACK") || requestMethod.equals("PRACK") || requestMethod.equals("CANCEL");
        if (!undropableMethod && this.serverTransactionTableHighwaterMark <= this.sipStack.getServerTransactionTableSize()) {
            if (request.getToTag() != null) {
                return true;
            }
            if (this.dropResponseStatus > 0) {
                SIPResponse response = request.createResponse(this.dropResponseStatus);
                try {
                    messageChannel.sendMessage((SIPMessage)response);
                }
                catch (IOException e) {
                    logger.logError("Failed to send congestion control error response" + response, (Exception)e);
                }
            }
            return false;
        }
        return true;
    }

    public boolean processResponse(Response response, MessageChannel messageChannel) {
        return true;
    }

    public void destroy() {
        logger.logInfo("Destorying the congestion control valve " + this);
    }

    public void init(SipStack stack) {
        this.sipStack = (SipStackImpl)stack;
        logger.logInfo("Initializing congestion control valve");
        String serverTransactionsString = this.sipStack.getConfigurationProperties().getProperty("gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS", "10000");
        this.serverTransactionTableHighwaterMark = new Integer(serverTransactionsString);
        String dropResponseStatusString = this.sipStack.getConfigurationProperties().getProperty("DROP_RESPONSE_STATUS", "503");
        this.dropResponseStatus = new Integer(dropResponseStatusString);
    }
}

