/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.StackLogger;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.stack.CallAnalyzer;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CallAnalyzer {
    private static StackLogger logger = CommonLogger.getLogger(CallAnalyzer.class);
    private Map<Thread, HashMap<MetricReference, Object>> threadMap = new WeakHashMap();
    private MetricReferenceMap metricStatisticsMap = new MetricReferenceMap();
    private Timer timer = new Timer();
    private SipStackImpl stack;
    static int count = 0;

    public CallAnalyzer(SipStackImpl stack) {
        this.stack = stack;
    }

    public void configure(MetricReference ref, MetricAnalysisConfiguration config) {
        this.metricStatisticsMap.get((Object)ref).config = config;
        if (!this.isAnalysisStarted(ref)) {
            this.startAnalysis(ref);
        }
    }

    public boolean isAnalysisStarted(MetricReference ref) {
        return this.metricStatisticsMap.get((Object)ref).task != null;
    }

    public TImeMetricInfo getMetricStats(MetricReference ref) {
        return this.metricStatisticsMap.get((Object)ref);
    }

    public void resetStats(MetricReference metricReference) {
        TImeMetricInfo info = this.metricStatisticsMap.get((Object)metricReference);
        info.totalTime = new Long(0L);
        info.numberOfEvents = new Long(0L);
        info.averageTime = new Long(1L);
        info.lastLoggedEventTime = new Long(0L);
    }

    public CallAnalyzer() {
    }

    public void stopAnalysis(MetricReference metricReference) {
        TImeMetricInfo statInfo = this.metricStatisticsMap.get((Object)metricReference);
        if (statInfo.task != null) {
            statInfo.task.cancel();
            statInfo.task = null;
        }
    }

    public void startAnalysis(MetricReference metricReference) {
        this.stopAnalysis(metricReference);
        this.resetStats(metricReference);
        TImeMetricInfo statInfo = this.metricStatisticsMap.get((Object)metricReference);
        statInfo.task = new /* Unavailable Anonymous Inner Class!! */;
        this.timer.scheduleAtFixedRate(statInfo.task, statInfo.config.checkingInterval, (long)statInfo.config.checkingInterval);
    }

    public void stop() {
        this.timer.cancel();
        this.timer = null;
    }

    public Long getTime(Thread threadId, MetricReference metricReference) {
        HashMap attribs = this.getAttributes(threadId);
        return (Long)attribs.get(metricReference);
    }

    public void setObject(Thread threadId, MetricReference objectName, Object object) {
        this.getAttributes(threadId).put(objectName, object);
    }

    public Object getObject(Thread threadId, String objectName) {
        return this.getAttributes(threadId).get(objectName);
    }

    public synchronized HashMap<MetricReference, Object> getAttributes(Thread threadId) {
        HashMap threadLocal = (HashMap)this.threadMap.get(threadId);
        if (threadLocal == null) {
            threadLocal = new HashMap();
            this.threadMap.put(threadId, threadLocal);
        }
        return threadLocal;
    }

    public void enter(MetricReference metricReference) {
        Thread threadId = Thread.currentThread();
        this.enter(threadId, metricReference);
    }

    public void leave(MetricReference metricReference) {
        Thread threadId = Thread.currentThread();
        this.leave(threadId, metricReference);
    }

    public void enter(Thread threadId, MetricReference metricReference) {
        HashMap attribs = this.getAttributes(threadId);
        attribs.put(metricReference, System.currentTimeMillis());
    }

    public void leave(Thread threadId, MetricReference metricReference) {
        TImeMetricInfo info = this.metricStatisticsMap.get((Object)metricReference);
        HashMap attribs = this.getAttributes(threadId);
        long delta = System.currentTimeMillis() - (Long)attribs.get(metricReference);
        TImeMetricInfo tImeMetricInfo = info;
        tImeMetricInfo.totalTime = tImeMetricInfo.totalTime + delta;
        tImeMetricInfo = info;
        Long l = tImeMetricInfo.numberOfEvents;
        tImeMetricInfo.numberOfEvents = tImeMetricInfo.numberOfEvents + 1L;
        info.averageTime = info.totalTime / info.numberOfEvents;
        attribs.put(metricReference, Long.MIN_VALUE);
    }

    public String getCurrentStack(Thread thread) {
        StackTraceElement[] ste;
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + thread.getName() + " " + thread.getId() + " " + thread.getState().toString() + "\n");
        for (StackTraceElement el : ste = thread.getStackTrace()) {
            sb.append(" " + el.toString() + "\n");
        }
        return sb.toString();
    }

    public String getThreadDump() {
        StringBuilder sb = new StringBuilder();
        Thread[] threads = new Thread[5000];
        int count = Thread.enumerate(threads);
        for (int q = 0; q < count; ++q) {
            sb.append(this.getCurrentStack(threads[q]));
        }
        return sb.toString();
    }

    public int getNumberOfThreads() {
        return this.threadMap.size();
    }

    public static void main(String[] arg) throws InterruptedException {
        ExecutorService ex = Executors.newFixedThreadPool(1000);
        CallAnalyzer tp = new CallAnalyzer();
        MetricReference sec = new MetricReference("sec");
        MetricReference se1c = new MetricReference("se111c");
        tp.configure(sec, new MetricAnalysisConfiguration(500, 500, 500));
        tp.startAnalysis(sec);
        tp.startAnalysis(se1c);
        2 r = new /* Unavailable Anonymous Inner Class!! */;
        for (int q = 0; q < 2000000; ++q) {
            ex.execute((Runnable)r);
        }
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        ex.shutdown();
        ex.awaitTermination(200L, TimeUnit.SECONDS);
        ex.shutdownNow();
        System.gc();
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        Thread.sleep(5000L);
        System.gc();
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        se1c = null;
        System.gc();
        Thread.sleep(5000L);
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        System.gc();
        Thread.sleep(5000L);
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        Thread.sleep(5000L);
        System.gc();
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        System.gc();
        Thread.sleep(5000L);
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        System.gc();
        Thread.sleep(5000L);
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        if (tp.threadMap.size() > 0) {
            throw new RuntimeException("Should be zero by this point. Leak.");
        }
    }

    static /* synthetic */ Map access$000(CallAnalyzer x0) {
        return x0.threadMap;
    }

    static /* synthetic */ StackLogger access$100() {
        return logger;
    }
}

