/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.interfaces.sip.SipStack;
import com.coraltele.interfaces.sip.message.Message;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.stack.CallAnalyzer;
import com.coraltele.javax.sip.stack.SIPEventInterceptor;
import java.util.Properties;

public class CallAnalysisInterceptor
implements SIPEventInterceptor {
    private CallAnalyzer callAnalyzer;
    private static final CallAnalyzer.MetricReference interceptorCheckpoint = new CallAnalyzer.MetricReference("ick");

    public void afterMessage(Message message) {
        this.callAnalyzer.leave(interceptorCheckpoint);
    }

    public void beforeMessage(Message message) {
        this.callAnalyzer.enter(interceptorCheckpoint);
    }

    public void destroy() {
        this.callAnalyzer.stop();
        this.callAnalyzer = null;
    }

    public void init(SipStack stack) {
        this.callAnalyzer = new CallAnalyzer((SipStackImpl)stack);
        Properties props = ((SipStackImpl)stack).getConfigurationProperties();
        Long checkingInterval = Long.parseLong(props.getProperty(CallAnalysisInterceptor.class.getName() + ".checkingInterval", "1000"));
        Long minStuckTime = Long.parseLong(props.getProperty(CallAnalysisInterceptor.class.getName() + ".minStuckTIme", "4000"));
        Long minTimeBetweenDumps = Long.parseLong(props.getProperty(CallAnalysisInterceptor.class.getName() + ".minTimeBetweenDumps", "2000"));
        CallAnalyzer.MetricAnalysisConfiguration config = new CallAnalyzer.MetricAnalysisConfiguration(checkingInterval, minTimeBetweenDumps, minStuckTime);
        this.callAnalyzer.configure(interceptorCheckpoint, config);
    }
}

