/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.stack;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.StackLogger;
import com.coraltele.javax.sip.stack.QueuedMessageDispatchBase;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;

public class BlockingQueueDispatchAuditor
extends TimerTask {
    private Timer timer = new Timer();
    private static StackLogger logger = CommonLogger.getLogger(BlockingQueueDispatchAuditor.class);
    private long totalReject = 0L;
    private boolean started = false;
    private Queue<? extends Runnable> queue;
    private int timeout = 8000;

    public BlockingQueueDispatchAuditor(Queue<? extends Runnable> queue) {
        this.queue = queue;
    }

    public void start(int interval) {
        if (this.started) {
            this.stop();
        }
        this.started = true;
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)this, interval, (long)interval);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void stop() {
        try {
            this.timer.cancel();
            this.timer = null;
        }
        catch (Exception exception) {
        }
        finally {
            this.started = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: {
            try {
                int removed = 0;
                Queue queue = this.queue;
                synchronized (queue) {
                    QueuedMessageDispatchBase runnable = (QueuedMessageDispatchBase)this.queue.peek();
                    while (runnable != null) {
                        QueuedMessageDispatchBase d = runnable;
                        if (System.currentTimeMillis() - d.getReceptionTime() > (long)this.timeout) {
                            this.queue.poll();
                            runnable = (QueuedMessageDispatchBase)this.queue.peek();
                            ++removed;
                            continue;
                        }
                        runnable = null;
                    }
                }
                if (removed > 0) {
                    this.totalReject += (long)removed;
                    if (logger != null && logger.isLoggingEnabled(8)) {
                        logger.logWarning("Removed stuck messages=" + removed + " total rejected=" + this.totalReject + " stil in queue=" + this.queue.size());
                    }
                }
            }
            catch (Exception e) {
                if (logger == null || !logger.isLoggingEnabled(8)) break block9;
                logger.logWarning("Problem reaping old requests. This is not a fatal error." + e);
            }
        }
    }
}

