/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.parser.extensions;

import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.javax.sip.header.ParametersHeader;
import com.coraltele.javax.sip.header.SIPHeader;
import com.coraltele.javax.sip.header.extensions.SessionExpires;
import com.coraltele.javax.sip.parser.Lexer;
import com.coraltele.javax.sip.parser.ParametersParser;
import java.text.ParseException;

public class SessionExpiresParser
extends ParametersParser {
    public SessionExpiresParser(String text) {
        super(text);
    }

    protected SessionExpiresParser(Lexer lexer) {
        super(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPHeader parse() throws ParseException {
        SessionExpires se = new SessionExpires();
        if (debug) {
            this.dbg_enter("parse");
        }
        try {
            this.headerName(2133);
            String nextId = this.lexer.getNextId();
            try {
                int delta = Integer.parseInt(nextId);
                se.setExpires(delta);
            }
            catch (NumberFormatException ex) {
                throw this.createParseException("bad integer format");
            }
            catch (InvalidArgumentException ex) {
                throw this.createParseException(ex.getMessage());
            }
            this.lexer.SPorHT();
            super.parse((ParametersHeader)se);
            SessionExpires sessionExpires = se;
            return sessionExpires;
        }
        finally {
            if (debug) {
                this.dbg_leave("parse");
            }
        }
    }

    public static void main(String[] args) throws ParseException {
        String[] to = new String[]{"Session-Expires: 30\n", "Session-Expires: 45;refresher=uac\n"};
        for (int i = 0; i < to.length; ++i) {
            SessionExpiresParser tp = new SessionExpiresParser(to[i]);
            SessionExpires t = (SessionExpires)tp.parse();
            System.out.println("encoded = " + t.encode());
            System.out.println("\ntime=" + t.getExpires());
            if (t.getParameter("refresher") == null) continue;
            System.out.println("refresher=" + t.getParameter("refresher"));
        }
    }
}

