/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.parser;

import com.coraltele.javax.sip.header.SIPHeader;
import com.coraltele.javax.sip.header.UserAgent;
import com.coraltele.javax.sip.parser.HeaderParser;
import com.coraltele.javax.sip.parser.Lexer;
import java.text.ParseException;

public class UserAgentParser
extends HeaderParser {
    public UserAgentParser(String userAgent) {
        super(userAgent);
    }

    protected UserAgentParser(Lexer lexer) {
        super(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPHeader parse() throws ParseException {
        if (debug) {
            this.dbg_enter("UserAgentParser.parse");
        }
        UserAgent userAgent = new UserAgent();
        try {
            this.headerName(2065);
            if (this.lexer.lookAhead(0) == '\n') {
                throw this.createParseException("empty header");
            }
            while (this.lexer.lookAhead(0) != '\n' && this.lexer.lookAhead(0) != '\u0000') {
                if (this.lexer.lookAhead(0) == '(') {
                    String comment = this.lexer.comment();
                    userAgent.addProductToken('(' + comment + ')');
                } else {
                    this.getLexer().SPorHT();
                    String product = this.lexer.byteStringNoSlash();
                    if (product == null) {
                        throw this.createParseException("Expected product string");
                    }
                    StringBuilder productSb = new StringBuilder(product);
                    if (this.lexer.peekNextToken().getTokenType() == 47) {
                        this.lexer.match(47);
                        this.getLexer().SPorHT();
                        String productVersion = this.lexer.byteStringNoSlash();
                        if (productVersion == null) {
                            throw this.createParseException("Expected product version");
                        }
                        productSb.append("/");
                        productSb.append(productVersion);
                    }
                    userAgent.addProductToken(productSb.toString());
                }
                this.lexer.SPorHT();
            }
        }
        finally {
            if (debug) {
                this.dbg_leave("UserAgentParser.parse");
            }
        }
        return userAgent;
    }

    public static void main(String[] args) throws ParseException {
        String[] userAgent = new String[]{"User-Agent: Softphone/Beta1.5 \n", "User-Agent:Nist/Beta1 (beta version) \n", "User-Agent: Nist UA (beta version)\n", "User-Agent: Nist1.0/Beta2 Ubi/vers.1.0 (very cool) \n", "User-Agent: SJphone/1.60.299a/L (SJ Labs)\n", "User-Agent: sipXecs/3.5.11 sipXecs/sipxbridge (Linux)\n"};
        for (int i = 0; i < userAgent.length; ++i) {
            UserAgentParser parser = new UserAgentParser(userAgent[i]);
            UserAgent ua = (UserAgent)parser.parse();
            System.out.println("encoded = " + ua.encode());
        }
    }
}

