/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.parser;

import com.coraltele.core.Token;
import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.javax.sip.header.SIPHeader;
import com.coraltele.javax.sip.header.SubscriptionState;
import com.coraltele.javax.sip.parser.HeaderParser;
import com.coraltele.javax.sip.parser.Lexer;
import java.text.ParseException;

public class SubscriptionStateParser
extends HeaderParser {
    public SubscriptionStateParser(String subscriptionState) {
        super(subscriptionState);
    }

    protected SubscriptionStateParser(Lexer lexer) {
        super(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPHeader parse() throws ParseException {
        if (debug) {
            this.dbg_enter("SubscriptionStateParser.parse");
        }
        SubscriptionState subscriptionState = new SubscriptionState();
        try {
            this.headerName(2104);
            subscriptionState.setHeaderName("Subscription-State");
            this.lexer.match(4095);
            Token token = this.lexer.getNextToken();
            subscriptionState.setState(token.getTokenValue());
            while (this.lexer.lookAhead(0) == ';') {
                this.lexer.match(59);
                this.lexer.SPorHT();
                this.lexer.match(4095);
                token = this.lexer.getNextToken();
                String value = token.getTokenValue();
                if (value.equalsIgnoreCase("reason")) {
                    this.lexer.match(61);
                    this.lexer.SPorHT();
                    this.lexer.match(4095);
                    token = this.lexer.getNextToken();
                    value = token.getTokenValue();
                    subscriptionState.setReasonCode(value);
                } else if (value.equalsIgnoreCase("expires")) {
                    this.lexer.match(61);
                    this.lexer.SPorHT();
                    this.lexer.match(4095);
                    token = this.lexer.getNextToken();
                    value = token.getTokenValue();
                    try {
                        int expires = Integer.parseInt(value);
                        subscriptionState.setExpires(expires);
                    }
                    catch (NumberFormatException ex) {
                        throw this.createParseException(ex.getMessage());
                    }
                    catch (InvalidArgumentException ex) {
                        throw this.createParseException(ex.getMessage());
                    }
                } else if (value.equalsIgnoreCase("retry-after")) {
                    this.lexer.match(61);
                    this.lexer.SPorHT();
                    this.lexer.match(4095);
                    token = this.lexer.getNextToken();
                    value = token.getTokenValue();
                    try {
                        int retryAfter = Integer.parseInt(value);
                        subscriptionState.setRetryAfter(retryAfter);
                    }
                    catch (NumberFormatException ex) {
                        throw this.createParseException(ex.getMessage());
                    }
                    catch (InvalidArgumentException ex) {
                        throw this.createParseException(ex.getMessage());
                    }
                } else {
                    this.lexer.match(61);
                    this.lexer.SPorHT();
                    this.lexer.match(4095);
                    Token secondToken = this.lexer.getNextToken();
                    String secondValue = secondToken.getTokenValue();
                    subscriptionState.setParameter(value, secondValue);
                }
                this.lexer.SPorHT();
            }
        }
        finally {
            if (debug) {
                this.dbg_leave("SubscriptionStateParser.parse");
            }
        }
        return subscriptionState;
    }
}

