/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.parser;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.InternalErrorHandler;
import com.coraltele.core.StackLogger;
import com.coraltele.interfaces.sip.message.Message;
import com.coraltele.javax.sip.header.ContentLength;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.parser.MessageParser;
import com.coraltele.javax.sip.parser.ParseExceptionListener;
import com.coraltele.javax.sip.parser.Pipeline;
import com.coraltele.javax.sip.parser.PipelinedMsgParser;
import com.coraltele.javax.sip.parser.SIPMessageListener;
import com.coraltele.javax.sip.stack.BlockingQueueDispatchAuditor;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PipelinedMsgParser
implements Runnable {
    private static StackLogger logger = CommonLogger.getLogger(PipelinedMsgParser.class);
    private static final String CRLF = "\r\n";
    protected SIPMessageListener sipMessageListener;
    private Thread mythread;
    private Pipeline rawInputStream;
    private int maxMessageSize;
    private int sizeCounter;
    private SIPTransactionStack sipStack;
    private MessageParser smp = null;
    private ConcurrentHashMap<String, CallIDOrderingStructure> messagesOrderingMap = new ConcurrentHashMap();
    boolean isRunning = false;
    private static int uid = 0;
    private static ExecutorService postParseExecutor = null;
    public static BlockingQueue<Runnable> staticQueue;
    public static BlockingQueueDispatchAuditor staticQueueAuditor;

    protected PipelinedMsgParser() {
    }

    private static synchronized int getNewUid() {
        return uid++;
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener sipMessageListener, Pipeline in, boolean debug, int maxMessageSize) {
        this();
        this.sipStack = sipStack;
        this.smp = sipStack.getMessageParserFactory().createMessageParser(sipStack);
        this.sipMessageListener = sipMessageListener;
        this.rawInputStream = in;
        this.maxMessageSize = maxMessageSize;
        this.mythread = new Thread((Runnable)this);
        this.mythread.setName("PipelineThread-" + PipelinedMsgParser.getNewUid());
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener mhandler, Pipeline in, int maxMsgSize) {
        this(sipStack, mhandler, in, false, maxMsgSize);
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, Pipeline in) {
        this(sipStack, null, in, false, 0);
    }

    public void processInput() {
        this.mythread.start();
    }

    protected Object clone() {
        PipelinedMsgParser p = new PipelinedMsgParser();
        p.rawInputStream = this.rawInputStream;
        p.sipMessageListener = this.sipMessageListener;
        Thread mythread = new Thread((Runnable)p);
        mythread.setName("PipelineThread");
        return p;
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int increment;
        int counter = 0;
        int bufferSize = increment = 1024;
        byte[] lineBuffer = new byte[bufferSize];
        byte[] crlfBuffer = new byte[2];
        int crlfCounter = 0;
        while (true) {
            int i;
            if ((i = inputStream.read()) == -1) {
                throw new IOException("End of stream");
            }
            char ch = (char)(i & 0xFF);
            if (this.maxMessageSize > 0) {
                --this.sizeCounter;
                if (this.sizeCounter <= 0) {
                    throw new IOException("Max size exceeded!");
                }
            }
            if (ch != '\r') {
                lineBuffer[counter++] = (byte)(i & 0xFF);
            } else if (counter == 0) {
                crlfBuffer[crlfCounter++] = 13;
            }
            if (ch == '\n') {
                if (counter != 1 || crlfCounter <= 0) break;
                crlfBuffer[crlfCounter++] = 10;
                break;
            }
            if (counter != bufferSize) continue;
            byte[] tempBuffer = new byte[bufferSize + increment];
            System.arraycopy(lineBuffer, 0, tempBuffer, 0, bufferSize);
            bufferSize += increment;
            lineBuffer = tempBuffer;
        }
        if (counter == 1 && crlfCounter > 0) {
            return new String(crlfBuffer, 0, crlfCounter, "UTF-8");
        }
        return new String(lineBuffer, 0, counter, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Pipeline inputStream = this.rawInputStream;
        StackLogger stackLogger = logger;
        try {
            this.isRunning = true;
            while (this.isRunning) {
                String clString;
                SIPMessage sipMessage;
                block71: {
                    String line1;
                    this.sizeCounter = this.maxMessageSize;
                    StringBuilder inputBuffer = new StringBuilder();
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Starting to parse.");
                    }
                    String line2 = null;
                    boolean isPreviousLineCRLF = false;
                    try {
                        while (true) {
                            if ((line1 = this.readLine((InputStream)inputStream)).equals("\n")) {
                                if (!logger.isLoggingEnabled(32)) continue;
                                logger.logDebug("Discarding blank line");
                                continue;
                            }
                            if (!"\r\n".equals(line1)) break;
                            if (isPreviousLineCRLF) {
                                if (logger.isLoggingEnabled(32)) {
                                    logger.logDebug("KeepAlive Double CRLF received, sending single CRLF as defined per RFC 5626 Section 4.4.1");
                                    logger.logDebug("~~~ setting isPreviousLineCRLF=false");
                                }
                                isPreviousLineCRLF = false;
                                try {
                                    this.sipMessageListener.sendSingleCLRF();
                                }
                                catch (Exception e) {
                                    logger.logError("A problem occured while trying to send a single CLRF in response to a double CLRF", e);
                                }
                                continue;
                            }
                            isPreviousLineCRLF = true;
                            if (!logger.isLoggingEnabled(32)) continue;
                            logger.logDebug("Received CRLF");
                        }
                    }
                    catch (IOException ex) {
                        if (postParseExecutor != null && this.isRunning) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("waiting for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                            ConcurrentHashMap concurrentHashMap = this.messagesOrderingMap;
                            // MONITORENTER : concurrentHashMap
                            try {
                                this.messagesOrderingMap.wait(64000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("got notified for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                        }
                        this.rawInputStream.stopTimer();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("thread ending for threadname " + this.mythread.getName());
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logStackTrace(32);
                        }
                        try {
                            this.cleanMessageOrderingMap();
                            if (inputStream.isClosed()) return;
                            inputStream.close();
                            return;
                        }
                        catch (IOException e) {
                            InternalErrorHandler.handleException((Exception)e);
                        }
                        return;
                    }
                    inputBuffer.append(line1);
                    this.rawInputStream.startTimer();
                    int bytesRead = 0;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Reading Input stream.");
                    }
                    try {
                        do {
                            line2 = this.readLine((InputStream)inputStream);
                            if (this.maxMessageSize > 0 && (bytesRead += line2.length()) > this.maxMessageSize / 2) {
                                throw new IOException("Pre-content-length headers size exceeded. The size of the message of the headers prior to Content-Length is too large. This must be an invalid message. Limit is MAX_MESSAGE_SIZE/2=" + this.maxMessageSize / 2);
                            }
                            inputBuffer.append(line2);
                        } while (!line2.trim().equals(""));
                    }
                    catch (IOException ex) {
                        if (postParseExecutor != null && this.isRunning) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("waiting for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                            ConcurrentHashMap concurrentHashMap = this.messagesOrderingMap;
                            // MONITORENTER : concurrentHashMap
                            try {
                                this.messagesOrderingMap.wait(64000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("got notified for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                        }
                        this.rawInputStream.stopTimer();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("thread ending for threadname " + this.mythread.getName());
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logStackTrace(32);
                        }
                        try {
                            this.cleanMessageOrderingMap();
                            if (inputStream.isClosed()) return;
                            inputStream.close();
                            return;
                        }
                        catch (IOException e) {
                            InternalErrorHandler.handleException((Exception)e);
                        }
                        return;
                    }
                    this.rawInputStream.stopTimer();
                    inputBuffer.append(line2);
                    sipMessage = null;
                    try {
                        if (stackLogger.isLoggingEnabled(32)) {
                            stackLogger.logDebug("About to parse : " + inputBuffer.toString());
                        }
                        if ((sipMessage = this.smp.parseSIPMessage(inputBuffer.toString().getBytes(), false, false, (ParseExceptionListener)this.sipMessageListener)) == null) {
                            this.rawInputStream.stopTimer();
                        }
                        break block71;
                    }
                    catch (ParseException ex) {
                        stackLogger.logError("Detected a parse error", (Exception)ex);
                    }
                    continue;
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Completed parsing message");
                }
                if ((clString = sipMessage.getHeaderAsFormattedString("Content-Length")).length() > 30) {
                    throw new RuntimeException("Bad content lenght header " + clString);
                }
                ContentLength cl = (ContentLength)sipMessage.getContentLength();
                int contentLength = 0;
                contentLength = cl != null ? cl.getContentLength() : 0;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Content length = " + contentLength);
                }
                if (this.maxMessageSize > 0 && contentLength > this.maxMessageSize) {
                    throw new RuntimeException("Max content size Exceeded! :" + contentLength + " allowed max size is " + this.maxMessageSize);
                }
                if (contentLength == 0) {
                    sipMessage.removeContent();
                } else if (this.maxMessageSize == 0 || contentLength < this.sizeCounter) {
                    byte[] message_body = new byte[contentLength];
                    int nread = 0;
                    while (nread < contentLength) {
                        this.rawInputStream.startTimer();
                        try {
                            int readlength = inputStream.read(message_body, nread, contentLength - nread);
                            if (readlength <= 0) break;
                            nread += readlength;
                        }
                        catch (IOException ex) {
                            stackLogger.logError("Exception Reading Content", (Exception)ex);
                            break;
                        }
                        finally {
                            this.rawInputStream.stopTimer();
                        }
                    }
                    sipMessage.setMessageContent(message_body);
                }
                if (this.sipMessageListener == null) continue;
                try {
                    CallIDOrderingStructure newCallIDOrderingStructure;
                    if (postParseExecutor == null) {
                        if (this.sipStack.sipEventInterceptor != null) {
                            this.sipStack.sipEventInterceptor.beforeMessage((Message)sipMessage);
                        }
                        this.sipMessageListener.processMessage(sipMessage);
                        if (this.sipStack.sipEventInterceptor == null) continue;
                        this.sipStack.sipEventInterceptor.afterMessage((Message)sipMessage);
                        continue;
                    }
                    String callId = sipMessage.getCallId().getCallId();
                    CallIDOrderingStructure orderingStructure = (CallIDOrderingStructure)this.messagesOrderingMap.get(callId);
                    if (orderingStructure == null && (orderingStructure = this.messagesOrderingMap.putIfAbsent(callId, newCallIDOrderingStructure = new CallIDOrderingStructure(this))) == null) {
                        orderingStructure = newCallIDOrderingStructure;
                        if (stackLogger.isLoggingEnabled(32)) {
                            stackLogger.logDebug("new CallIDOrderingStructure added for message " + sipMessage);
                        }
                    }
                    CallIDOrderingStructure callIDOrderingStructure = orderingStructure;
                    callIDOrderingStructure.getMessagesForCallID().offer(sipMessage);
                    postParseExecutor.execute((Runnable)new Dispatch(this, callIDOrderingStructure, callId));
                }
                catch (Exception ex) {
                    return;
                }
            }
            return;
        }
        finally {
            try {
                this.cleanMessageOrderingMap();
                if (!inputStream.isClosed()) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                InternalErrorHandler.handleException((Exception)e);
            }
        }
    }

    public static void setPostParseExcutorSize(int threads, int queueTimeout) {
        if (postParseExecutor != null) {
            postParseExecutor.shutdownNow();
        }
        if (staticQueueAuditor != null) {
            try {
                staticQueueAuditor.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (threads <= 0) {
            postParseExecutor = null;
        } else {
            staticQueue = new LinkedBlockingQueue();
            postParseExecutor = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)staticQueue, (ThreadFactory)new NamedThreadFactory());
            staticQueueAuditor = new BlockingQueueDispatchAuditor((Queue)staticQueue);
            staticQueueAuditor.setTimeout(queueTimeout);
            staticQueueAuditor.start(2000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block7: {
            this.isRunning = false;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing pipelinedmsgparser " + this + " threadname " + this.mythread.getName());
            }
            try {
                this.rawInputStream.close();
            }
            catch (IOException ex) {
                if (!logger.isLoggingEnabled(32)) break block7;
                logger.logDebug("Couldn't close the rawInputStream " + this + " threadname " + this.mythread.getName() + " already closed ? " + this.rawInputStream.isClosed());
            }
        }
        if (postParseExecutor != null) {
            this.cleanMessageOrderingMap();
            Thread thread = this.mythread;
            synchronized (thread) {
                this.mythread.notifyAll();
                this.mythread.interrupt();
            }
        }
    }

    public static void shutdownTcpThreadpool() {
        if (postParseExecutor != null) {
            postParseExecutor.shutdown();
            postParseExecutor = null;
        }
        if (staticQueueAuditor != null) {
            try {
                staticQueueAuditor.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanMessageOrderingMap() {
        this.messagesOrderingMap.clear();
        ConcurrentHashMap concurrentHashMap = this.messagesOrderingMap;
        synchronized (concurrentHashMap) {
            this.messagesOrderingMap.notifyAll();
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("cleaned the messagesOrderingMap " + this + " threadname " + this.mythread.getName());
        }
    }

    static /* synthetic */ SIPTransactionStack access$000(PipelinedMsgParser x0) {
        return x0.sipStack;
    }

    static /* synthetic */ StackLogger access$100() {
        return logger;
    }

    static /* synthetic */ ConcurrentHashMap access$200(PipelinedMsgParser x0) {
        return x0.messagesOrderingMap;
    }

    static /* synthetic */ Thread access$300(PipelinedMsgParser x0) {
        return x0.mythread;
    }
}

