/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.parser;

import com.coraltele.javax.sip.parser.Pipeline;
import com.coraltele.javax.sip.stack.SIPStackTimerTask;
import com.coraltele.javax.sip.stack.timers.SipTimer;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class Pipeline
extends InputStream {
    private LinkedList buffList;
    private Buffer currentBuffer;
    private boolean isClosed;
    private SipTimer timer;
    private InputStream pipe;
    private int readTimeout;
    private SIPStackTimerTask myTimerTask;

    public void startTimer() {
        if (this.readTimeout == -1) {
            return;
        }
        this.myTimerTask = new MyTimer(this, this);
        this.timer.schedule(this.myTimerTask, (long)this.readTimeout);
    }

    public void stopTimer() {
        if (this.readTimeout == -1) {
            return;
        }
        if (this.myTimerTask != null) {
            this.timer.cancel(this.myTimerTask);
        }
    }

    public Pipeline(InputStream pipe, int readTimeout, SipTimer timer) {
        this.timer = timer;
        this.pipe = pipe;
        this.buffList = new LinkedList();
        this.readTimeout = readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes, int start, int length) throws IOException {
        if (this.isClosed) {
            throw new IOException("Closed!!");
        }
        Buffer buff = new Buffer(this, bytes, length);
        buff.ptr = start;
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            this.buffList.add(buff);
            this.buffList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) throws IOException {
        if (this.isClosed) {
            throw new IOException("Closed!!");
        }
        Buffer buff = new Buffer(this, bytes, bytes.length);
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            this.buffList.add(buff);
            this.buffList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.isClosed = true;
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            this.buffList.notifyAll();
        }
        this.pipe.close();
    }

    @Override
    public int read() throws IOException {
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            if (this.currentBuffer != null && this.currentBuffer.ptr < this.currentBuffer.length) {
                int retval = this.currentBuffer.getNextByte();
                if (this.currentBuffer.ptr == this.currentBuffer.length) {
                    this.currentBuffer = null;
                }
                return retval;
            }
            if (this.isClosed && this.buffList.isEmpty()) {
                return -1;
            }
            try {
                while (this.buffList.isEmpty()) {
                    this.buffList.wait();
                    if (!this.buffList.isEmpty() || !this.isClosed) continue;
                    return -1;
                }
                this.currentBuffer = (Buffer)this.buffList.removeFirst();
                int retval = this.currentBuffer.getNextByte();
                if (this.currentBuffer.ptr == this.currentBuffer.length) {
                    this.currentBuffer = null;
                }
                return retval;
            }
            catch (InterruptedException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (NoSuchElementException ex) {
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

