/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.parser;

import com.coraltele.core.InternalErrorHandler;
import com.coraltele.javax.sip.header.SIPHeaderNamesCache;
import com.coraltele.javax.sip.parser.AcceptEncodingParser;
import com.coraltele.javax.sip.parser.AcceptLanguageParser;
import com.coraltele.javax.sip.parser.AcceptParser;
import com.coraltele.javax.sip.parser.AlertInfoParser;
import com.coraltele.javax.sip.parser.AllowEventsParser;
import com.coraltele.javax.sip.parser.AllowParser;
import com.coraltele.javax.sip.parser.AuthenticationInfoParser;
import com.coraltele.javax.sip.parser.AuthorizationParser;
import com.coraltele.javax.sip.parser.CSeqParser;
import com.coraltele.javax.sip.parser.CallIDParser;
import com.coraltele.javax.sip.parser.CallInfoParser;
import com.coraltele.javax.sip.parser.ContactParser;
import com.coraltele.javax.sip.parser.ContentDispositionParser;
import com.coraltele.javax.sip.parser.ContentEncodingParser;
import com.coraltele.javax.sip.parser.ContentLanguageParser;
import com.coraltele.javax.sip.parser.ContentLengthParser;
import com.coraltele.javax.sip.parser.ContentTypeParser;
import com.coraltele.javax.sip.parser.DateParser;
import com.coraltele.javax.sip.parser.ErrorInfoParser;
import com.coraltele.javax.sip.parser.EventParser;
import com.coraltele.javax.sip.parser.ExpiresParser;
import com.coraltele.javax.sip.parser.FromParser;
import com.coraltele.javax.sip.parser.HeaderParser;
import com.coraltele.javax.sip.parser.InReplyToParser;
import com.coraltele.javax.sip.parser.Lexer;
import com.coraltele.javax.sip.parser.MaxForwardsParser;
import com.coraltele.javax.sip.parser.MimeVersionParser;
import com.coraltele.javax.sip.parser.MinExpiresParser;
import com.coraltele.javax.sip.parser.OrganizationParser;
import com.coraltele.javax.sip.parser.PriorityParser;
import com.coraltele.javax.sip.parser.ProxyAuthenticateParser;
import com.coraltele.javax.sip.parser.ProxyAuthorizationParser;
import com.coraltele.javax.sip.parser.ProxyRequireParser;
import com.coraltele.javax.sip.parser.RAckParser;
import com.coraltele.javax.sip.parser.RSeqParser;
import com.coraltele.javax.sip.parser.ReasonParser;
import com.coraltele.javax.sip.parser.RecordRouteParser;
import com.coraltele.javax.sip.parser.ReferToParser;
import com.coraltele.javax.sip.parser.ReplyToParser;
import com.coraltele.javax.sip.parser.RequireParser;
import com.coraltele.javax.sip.parser.RetryAfterParser;
import com.coraltele.javax.sip.parser.RouteParser;
import com.coraltele.javax.sip.parser.SIPETagParser;
import com.coraltele.javax.sip.parser.SIPIfMatchParser;
import com.coraltele.javax.sip.parser.ServerParser;
import com.coraltele.javax.sip.parser.SubjectParser;
import com.coraltele.javax.sip.parser.SubscriptionStateParser;
import com.coraltele.javax.sip.parser.SupportedParser;
import com.coraltele.javax.sip.parser.TimeStampParser;
import com.coraltele.javax.sip.parser.ToParser;
import com.coraltele.javax.sip.parser.UnsupportedParser;
import com.coraltele.javax.sip.parser.UserAgentParser;
import com.coraltele.javax.sip.parser.ViaParser;
import com.coraltele.javax.sip.parser.WWWAuthenticateParser;
import com.coraltele.javax.sip.parser.WarningParser;
import com.coraltele.javax.sip.parser.extensions.JoinParser;
import com.coraltele.javax.sip.parser.extensions.MinSEParser;
import com.coraltele.javax.sip.parser.extensions.ReferencesParser;
import com.coraltele.javax.sip.parser.extensions.ReferredByParser;
import com.coraltele.javax.sip.parser.extensions.ReplacesParser;
import com.coraltele.javax.sip.parser.extensions.SessionExpiresParser;
import com.coraltele.javax.sip.parser.ims.PAccessNetworkInfoParser;
import com.coraltele.javax.sip.parser.ims.PAssertedIdentityParser;
import com.coraltele.javax.sip.parser.ims.PAssociatedURIParser;
import com.coraltele.javax.sip.parser.ims.PCalledPartyIDParser;
import com.coraltele.javax.sip.parser.ims.PChargingFunctionAddressesParser;
import com.coraltele.javax.sip.parser.ims.PChargingVectorParser;
import com.coraltele.javax.sip.parser.ims.PMediaAuthorizationParser;
import com.coraltele.javax.sip.parser.ims.PPreferredIdentityParser;
import com.coraltele.javax.sip.parser.ims.PVisitedNetworkIDParser;
import com.coraltele.javax.sip.parser.ims.PathParser;
import com.coraltele.javax.sip.parser.ims.PrivacyParser;
import com.coraltele.javax.sip.parser.ims.SecurityClientParser;
import com.coraltele.javax.sip.parser.ims.SecurityServerParser;
import com.coraltele.javax.sip.parser.ims.SecurityVerifyParser;
import com.coraltele.javax.sip.parser.ims.ServiceRouteParser;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ParserFactory {
    private static Map<String, Class<? extends HeaderParser>> parserTable = new ConcurrentHashMap(90);
    private static Class[] constructorArgs;
    private static ConcurrentHashMap<Class, Constructor> parserConstructorCache;

    public static HeaderParser createParser(String line) throws ParseException {
        String headerName = Lexer.getHeaderName((String)line);
        String headerValue = Lexer.getHeaderValue((String)line);
        if (headerName == null || headerValue == null) {
            throw new ParseException("The header name or value is null", 0);
        }
        Class parserClass = (Class)parserTable.get(SIPHeaderNamesCache.toLowerCase((String)headerName));
        if (parserClass != null) {
            try {
                Constructor cons = (Constructor)parserConstructorCache.get(parserClass);
                if (cons == null) {
                    cons = parserClass.getConstructor(constructorArgs);
                    parserConstructorCache.putIfAbsent(parserClass, cons);
                }
                Object[] args = new Object[]{line};
                HeaderParser retval = (HeaderParser)cons.newInstance(args);
                return retval;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException((Exception)ex);
                return null;
            }
        }
        return new HeaderParser(line);
    }

    static {
        parserConstructorCache = new ConcurrentHashMap();
        constructorArgs = new Class[1];
        ParserFactory.constructorArgs[0] = String.class;
        parserTable.put("Reply-To".toLowerCase(), ReplyToParser.class);
        parserTable.put("In-Reply-To".toLowerCase(), InReplyToParser.class);
        parserTable.put("Accept-Encoding".toLowerCase(), AcceptEncodingParser.class);
        parserTable.put("Accept-Language".toLowerCase(), AcceptLanguageParser.class);
        parserTable.put("t", ToParser.class);
        parserTable.put("To".toLowerCase(), ToParser.class);
        parserTable.put("From".toLowerCase(), FromParser.class);
        parserTable.put("f", FromParser.class);
        parserTable.put("CSeq".toLowerCase(), CSeqParser.class);
        parserTable.put("Via".toLowerCase(), ViaParser.class);
        parserTable.put("v", ViaParser.class);
        parserTable.put("Contact".toLowerCase(), ContactParser.class);
        parserTable.put("m", ContactParser.class);
        parserTable.put("Content-Type".toLowerCase(), ContentTypeParser.class);
        parserTable.put("c", ContentTypeParser.class);
        parserTable.put("Content-Length".toLowerCase(), ContentLengthParser.class);
        parserTable.put("l", ContentLengthParser.class);
        parserTable.put("Authorization".toLowerCase(), AuthorizationParser.class);
        parserTable.put("WWW-Authenticate".toLowerCase(), WWWAuthenticateParser.class);
        parserTable.put("Call-ID".toLowerCase(), CallIDParser.class);
        parserTable.put("i", CallIDParser.class);
        parserTable.put("Route".toLowerCase(), RouteParser.class);
        parserTable.put("Record-Route".toLowerCase(), RecordRouteParser.class);
        parserTable.put("Date".toLowerCase(), DateParser.class);
        parserTable.put("Proxy-Authorization".toLowerCase(), ProxyAuthorizationParser.class);
        parserTable.put("Proxy-Authenticate".toLowerCase(), ProxyAuthenticateParser.class);
        parserTable.put("Retry-After".toLowerCase(), RetryAfterParser.class);
        parserTable.put("Require".toLowerCase(), RequireParser.class);
        parserTable.put("Proxy-Require".toLowerCase(), ProxyRequireParser.class);
        parserTable.put("Timestamp".toLowerCase(), TimeStampParser.class);
        parserTable.put("Unsupported".toLowerCase(), UnsupportedParser.class);
        parserTable.put("User-Agent".toLowerCase(), UserAgentParser.class);
        parserTable.put("Supported".toLowerCase(), SupportedParser.class);
        parserTable.put("k", SupportedParser.class);
        parserTable.put("Server".toLowerCase(), ServerParser.class);
        parserTable.put("Subject".toLowerCase(), SubjectParser.class);
        parserTable.put("s", SubjectParser.class);
        parserTable.put("Subscription-State".toLowerCase(), SubscriptionStateParser.class);
        parserTable.put("Max-Forwards".toLowerCase(), MaxForwardsParser.class);
        parserTable.put("MIME-Version".toLowerCase(), MimeVersionParser.class);
        parserTable.put("Min-Expires".toLowerCase(), MinExpiresParser.class);
        parserTable.put("Organization".toLowerCase(), OrganizationParser.class);
        parserTable.put("Priority".toLowerCase(), PriorityParser.class);
        parserTable.put("RAck".toLowerCase(), RAckParser.class);
        parserTable.put("RSeq".toLowerCase(), RSeqParser.class);
        parserTable.put("Reason".toLowerCase(), ReasonParser.class);
        parserTable.put("Warning".toLowerCase(), WarningParser.class);
        parserTable.put("Expires".toLowerCase(), ExpiresParser.class);
        parserTable.put("Event".toLowerCase(), EventParser.class);
        parserTable.put("o", EventParser.class);
        parserTable.put("Error-Info".toLowerCase(), ErrorInfoParser.class);
        parserTable.put("Content-Language".toLowerCase(), ContentLanguageParser.class);
        parserTable.put("Content-Encoding".toLowerCase(), ContentEncodingParser.class);
        parserTable.put("e", ContentEncodingParser.class);
        parserTable.put("Content-Disposition".toLowerCase(), ContentDispositionParser.class);
        parserTable.put("Call-Info".toLowerCase(), CallInfoParser.class);
        parserTable.put("Authentication-Info".toLowerCase(), AuthenticationInfoParser.class);
        parserTable.put("Allow".toLowerCase(), AllowParser.class);
        parserTable.put("Allow-Events".toLowerCase(), AllowEventsParser.class);
        parserTable.put("u", AllowEventsParser.class);
        parserTable.put("Alert-Info".toLowerCase(), AlertInfoParser.class);
        parserTable.put("Accept".toLowerCase(), AcceptParser.class);
        parserTable.put("Refer-To".toLowerCase(), ReferToParser.class);
        parserTable.put("r", ReferToParser.class);
        parserTable.put("SIP-ETag".toLowerCase(), SIPETagParser.class);
        parserTable.put("SIP-If-Match".toLowerCase(), SIPIfMatchParser.class);
        parserTable.put("P-Access-Network-Info".toLowerCase(), PAccessNetworkInfoParser.class);
        parserTable.put("P-Asserted-Identity".toLowerCase(), PAssertedIdentityParser.class);
        parserTable.put("P-Preferred-Identity".toLowerCase(), PPreferredIdentityParser.class);
        parserTable.put("P-Charging-Vector".toLowerCase(), PChargingVectorParser.class);
        parserTable.put("P-Charging-Function-Addresses".toLowerCase(), PChargingFunctionAddressesParser.class);
        parserTable.put("P-Media-Authorization".toLowerCase(), PMediaAuthorizationParser.class);
        parserTable.put("Path".toLowerCase(), PathParser.class);
        parserTable.put("Privacy".toLowerCase(), PrivacyParser.class);
        parserTable.put("Service-Route".toLowerCase(), ServiceRouteParser.class);
        parserTable.put("P-Visited-Network-ID".toLowerCase(), PVisitedNetworkIDParser.class);
        parserTable.put("P-Associated-URI".toLowerCase(), PAssociatedURIParser.class);
        parserTable.put("P-Called-Party-ID".toLowerCase(), PCalledPartyIDParser.class);
        parserTable.put("Security-Server".toLowerCase(), SecurityServerParser.class);
        parserTable.put("Security-Client".toLowerCase(), SecurityClientParser.class);
        parserTable.put("Security-Verify".toLowerCase(), SecurityVerifyParser.class);
        parserTable.put("Referred-By".toLowerCase(), ReferredByParser.class);
        parserTable.put("b", ReferToParser.class);
        parserTable.put("Session-Expires".toLowerCase(), SessionExpiresParser.class);
        parserTable.put("x", SessionExpiresParser.class);
        parserTable.put("Min-SE".toLowerCase(), MinSEParser.class);
        parserTable.put("Replaces".toLowerCase(), ReplacesParser.class);
        parserTable.put("Join".toLowerCase(), JoinParser.class);
        parserTable.put("References".toLowerCase(), ReferencesParser.class);
    }
}

