/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.parser;

import com.coraltele.core.Token;
import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.javax.sip.header.AcceptLanguage;
import com.coraltele.javax.sip.header.AcceptLanguageList;
import com.coraltele.javax.sip.header.SIPHeader;
import com.coraltele.javax.sip.parser.HeaderParser;
import com.coraltele.javax.sip.parser.Lexer;
import java.text.ParseException;

public class AcceptLanguageParser
extends HeaderParser {
    public AcceptLanguageParser(String acceptLanguage) {
        super(acceptLanguage);
    }

    protected AcceptLanguageParser(Lexer lexer) {
        super(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPHeader parse() throws ParseException {
        AcceptLanguageList acceptLanguageList = new AcceptLanguageList();
        if (debug) {
            this.dbg_enter("AcceptLanguageParser.parse");
        }
        try {
            this.headerName(2095);
            while (this.lexer.lookAhead(0) != '\n') {
                Token value;
                AcceptLanguage acceptLanguage = new AcceptLanguage();
                acceptLanguage.setHeaderName("Accept-Language");
                if (this.lexer.lookAhead(0) != ';') {
                    this.lexer.match(4095);
                    value = this.lexer.getNextToken();
                    acceptLanguage.setLanguageRange(value.getTokenValue());
                }
                while (this.lexer.lookAhead(0) == ';') {
                    this.lexer.match(59);
                    this.lexer.SPorHT();
                    this.lexer.match(113);
                    this.lexer.SPorHT();
                    this.lexer.match(61);
                    this.lexer.SPorHT();
                    this.lexer.match(4095);
                    value = this.lexer.getNextToken();
                    try {
                        float fl = Float.parseFloat(value.getTokenValue());
                        acceptLanguage.setQValue(fl);
                    }
                    catch (NumberFormatException ex) {
                        throw this.createParseException(ex.getMessage());
                    }
                    catch (InvalidArgumentException ex) {
                        throw this.createParseException(ex.getMessage());
                    }
                    this.lexer.SPorHT();
                }
                acceptLanguageList.add((SIPHeader)acceptLanguage);
                if (this.lexer.lookAhead(0) == ',') {
                    this.lexer.match(44);
                    this.lexer.SPorHT();
                    continue;
                }
                this.lexer.SPorHT();
            }
        }
        finally {
            if (debug) {
                this.dbg_leave("AcceptLanguageParser.parse");
            }
        }
        return acceptLanguageList;
    }
}

