/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.message;

import com.coraltele.core.InternalErrorHandler;
import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.SipException;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContentDispositionHeader;
import com.coraltele.interfaces.sip.header.ContentEncodingHeader;
import com.coraltele.interfaces.sip.header.ContentLanguageHeader;
import com.coraltele.interfaces.sip.header.ContentLengthHeader;
import com.coraltele.interfaces.sip.header.ContentTypeHeader;
import com.coraltele.interfaces.sip.header.ExpiresHeader;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.header.MaxForwardsHeader;
import com.coraltele.interfaces.sip.header.RecordRouteHeader;
import com.coraltele.interfaces.sip.header.ToHeader;
import com.coraltele.interfaces.sip.header.ViaHeader;
import com.coraltele.interfaces.sip.message.Message;
import com.coraltele.javax.sip.Utils;
import com.coraltele.javax.sip.header.AlertInfo;
import com.coraltele.javax.sip.header.Authorization;
import com.coraltele.javax.sip.header.CSeq;
import com.coraltele.javax.sip.header.CallID;
import com.coraltele.javax.sip.header.Contact;
import com.coraltele.javax.sip.header.ContactList;
import com.coraltele.javax.sip.header.ContentLength;
import com.coraltele.javax.sip.header.ContentType;
import com.coraltele.javax.sip.header.ErrorInfo;
import com.coraltele.javax.sip.header.ErrorInfoList;
import com.coraltele.javax.sip.header.From;
import com.coraltele.javax.sip.header.InReplyTo;
import com.coraltele.javax.sip.header.MaxForwards;
import com.coraltele.javax.sip.header.Priority;
import com.coraltele.javax.sip.header.ProxyAuthenticate;
import com.coraltele.javax.sip.header.ProxyAuthorization;
import com.coraltele.javax.sip.header.ProxyRequire;
import com.coraltele.javax.sip.header.ProxyRequireList;
import com.coraltele.javax.sip.header.RSeq;
import com.coraltele.javax.sip.header.RecordRouteList;
import com.coraltele.javax.sip.header.RetryAfter;
import com.coraltele.javax.sip.header.Route;
import com.coraltele.javax.sip.header.RouteList;
import com.coraltele.javax.sip.header.SIPETag;
import com.coraltele.javax.sip.header.SIPHeader;
import com.coraltele.javax.sip.header.SIPHeaderList;
import com.coraltele.javax.sip.header.SIPHeaderNamesCache;
import com.coraltele.javax.sip.header.SIPIfMatch;
import com.coraltele.javax.sip.header.Server;
import com.coraltele.javax.sip.header.Subject;
import com.coraltele.javax.sip.header.To;
import com.coraltele.javax.sip.header.Unsupported;
import com.coraltele.javax.sip.header.UserAgent;
import com.coraltele.javax.sip.header.Via;
import com.coraltele.javax.sip.header.ViaList;
import com.coraltele.javax.sip.header.WWWAuthenticate;
import com.coraltele.javax.sip.header.Warning;
import com.coraltele.javax.sip.message.HeaderIterator;
import com.coraltele.javax.sip.message.ListMap;
import com.coraltele.javax.sip.message.MessageExt;
import com.coraltele.javax.sip.message.MessageFactoryImpl;
import com.coraltele.javax.sip.message.MessageObject;
import com.coraltele.javax.sip.message.MultipartMimeContent;
import com.coraltele.javax.sip.message.MultipartMimeContentImpl;
import com.coraltele.javax.sip.message.SIPDuplicateHeaderException;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.parser.HeaderParser;
import com.coraltele.javax.sip.parser.ParserFactory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SIPMessage
extends MessageObject
implements Message,
MessageExt {
    private String contentEncodingCharset = MessageFactoryImpl.getDefaultContentEncodingCharset();
    protected boolean nullRequest;
    protected LinkedList<String> unrecognizedHeaders = new LinkedList();
    protected ConcurrentLinkedQueue<SIPHeader> headers = new ConcurrentLinkedQueue();
    protected From fromHeader;
    protected To toHeader;
    protected CSeq cSeqHeader;
    protected CallID callIdHeader;
    protected ContentLength contentLengthHeader;
    protected MaxForwards maxForwardsHeader;
    protected int size;
    protected String messageContent;
    protected byte[] messageContentBytes;
    protected Object messageContentObject;
    protected Map<String, SIPHeader> headerTable = new ConcurrentHashMap();
    protected Object applicationData;
    protected String forkId;
    private InetAddress remoteAddress;
    private int remotePort;
    private InetAddress localAddress;
    private int localPort;
    private static final String CONTENT_TYPE_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Content-Type");
    private static final String ERROR_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Error-Info");
    private static final String CONTACT_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Contact");
    private static final String VIA_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Via");
    private static final String AUTHORIZATION_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Authorization");
    private static final String ROUTE_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Route");
    private static final String RECORDROUTE_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Record-Route");
    private static final String CONTENT_DISPOSITION_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Content-Disposition");
    private static final String CONTENT_ENCODING_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Content-Encoding");
    private static final String CONTENT_LANGUAGE_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Content-Language");
    private static final String EXPIRES_LOWERCASE = SIPHeaderNamesCache.toLowerCase((String)"Expires");

    public static boolean isRequestHeader(SIPHeader sipHeader) {
        return sipHeader instanceof AlertInfo || sipHeader instanceof InReplyTo || sipHeader instanceof Authorization || sipHeader instanceof MaxForwards || sipHeader instanceof UserAgent || sipHeader instanceof Priority || sipHeader instanceof ProxyAuthorization || sipHeader instanceof ProxyRequire || sipHeader instanceof ProxyRequireList || sipHeader instanceof Route || sipHeader instanceof RouteList || sipHeader instanceof Subject || sipHeader instanceof SIPIfMatch;
    }

    public static boolean isResponseHeader(SIPHeader sipHeader) {
        return sipHeader instanceof ErrorInfo || sipHeader instanceof ProxyAuthenticate || sipHeader instanceof Server || sipHeader instanceof Unsupported || sipHeader instanceof RetryAfter || sipHeader instanceof Warning || sipHeader instanceof WWWAuthenticate || sipHeader instanceof SIPETag || sipHeader instanceof RSeq;
    }

    public LinkedList<String> getMessageAsEncodedStrings() {
        LinkedList<String> retval = new LinkedList<String>();
        for (SIPHeader sipHeader : this.headers) {
            if (sipHeader instanceof SIPHeaderList) {
                SIPHeaderList shl = (SIPHeaderList)sipHeader;
                retval.addAll(shl.getHeadersAsEncodedStrings());
                continue;
            }
            retval.add(sipHeader.encode());
        }
        return retval;
    }

    protected StringBuilder encodeSIPHeaders(StringBuilder encoding) {
        for (SIPHeader siphdr : this.headers) {
            if (siphdr instanceof ContentLength) continue;
            siphdr.encode(encoding);
        }
        return this.contentLengthHeader.encode(encoding).append("\r\n");
    }

    public abstract StringBuilder encodeMessage(StringBuilder var1);

    public final String getDialogId(boolean isServer) {
        To to = (To)this.getTo();
        return this.getDialogId(isServer, to.getTag());
    }

    public final String getDialogId(boolean isServer, String toTag) {
        From from = (From)this.getFrom();
        CallID cid = (CallID)this.getCallId();
        StringBuffer retval = new StringBuffer(cid.getCallId());
        if (!isServer) {
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
            if (toTag != null) {
                retval.append(":");
                retval.append(toTag);
            }
        } else {
            if (toTag != null) {
                retval.append(":");
                retval.append(toTag);
            }
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
        }
        return retval.toString().toLowerCase();
    }

    public boolean match(Object other) {
        if (other == null) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPMessage matchObj = (SIPMessage)other;
        Iterator li = matchObj.getHeaders();
        while (li.hasNext()) {
            SIPHeader hisHeaders = (SIPHeader)li.next();
            List myHeaders = this.getHeaderList(hisHeaders.getHeaderName());
            if (myHeaders == null || myHeaders.size() == 0) {
                return false;
            }
            if (hisHeaders instanceof SIPHeaderList) {
                ListIterator outerIterator = ((SIPHeaderList)hisHeaders).listIterator();
                while (outerIterator.hasNext()) {
                    SIPHeader hisHeader = (SIPHeader)outerIterator.next();
                    if (hisHeader instanceof ContentLength) continue;
                    ListIterator innerIterator = myHeaders.listIterator();
                    boolean found = false;
                    while (innerIterator.hasNext()) {
                        SIPHeader myHeader = (SIPHeader)innerIterator.next();
                        if (!myHeader.match((Object)hisHeader)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                continue;
            }
            SIPHeader hisHeader = hisHeaders;
            ListIterator innerIterator = myHeaders.listIterator();
            boolean found = false;
            while (innerIterator.hasNext()) {
                SIPHeader myHeader = (SIPHeader)innerIterator.next();
                if (!myHeader.match((Object)hisHeader)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void merge(Object template) {
        if (!template.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad class " + template.getClass());
        }
        SIPMessage templateMessage = (SIPMessage)template;
        Object[] templateHeaders = templateMessage.headers.toArray();
        for (int i = 0; i < templateHeaders.length; ++i) {
            SIPHeader hdr = (SIPHeader)templateHeaders[i];
            String hdrName = hdr.getHeaderName();
            List myHdrs = this.getHeaderList(hdrName);
            if (myHdrs == null) {
                this.attachHeader(hdr);
                continue;
            }
            ListIterator it = myHdrs.listIterator();
            while (it.hasNext()) {
                SIPHeader sipHdr = (SIPHeader)it.next();
                sipHdr.merge((Object)hdr);
            }
        }
    }

    public String encode() {
        StringBuilder encoding = new StringBuilder();
        for (Object siphdr : this.headers) {
            if (siphdr instanceof ContentLength) continue;
            siphdr.encode(encoding);
        }
        if (this.unrecognizedHeaders != null) {
            for (String unrecognized : this.unrecognizedHeaders) {
                encoding.append(unrecognized).append("\r\n");
            }
        }
        this.contentLengthHeader.encode(encoding).append("\r\n");
        if (this.messageContentObject != null) {
            String mbody = this.getContent().toString();
            encoding.append(mbody);
        } else if (this.messageContent != null || this.messageContentBytes != null) {
            String content = null;
            try {
                content = this.messageContent != null ? this.messageContent : new String(this.messageContentBytes, this.getCharset());
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException((Exception)ex);
            }
            encoding.append(content);
        }
        return encoding.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeAsBytes(String transport) {
        if (this instanceof SIPRequest && ((SIPRequest)this).isNullRequest()) {
            return "\r\n\r\n".getBytes();
        }
        ViaHeader topVia = (ViaHeader)this.getHeader("Via");
        try {
            topVia.setTransport(transport);
        }
        catch (ParseException e) {
            InternalErrorHandler.handleException((Exception)e);
        }
        StringBuilder encoding = new StringBuilder();
        ConcurrentLinkedQueue concurrentLinkedQueue = this.headers;
        synchronized (concurrentLinkedQueue) {
            for (SIPHeader siphdr : this.headers) {
                if (siphdr instanceof ContentLength) continue;
                siphdr.encode(encoding);
            }
        }
        this.contentLengthHeader.encode(encoding);
        encoding.append("\r\n");
        byte[] retval = null;
        byte[] content = this.getRawContent();
        if (content != null) {
            byte[] msgarray = null;
            try {
                msgarray = encoding.toString().getBytes(this.getCharset());
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException((Exception)ex);
            }
            retval = new byte[msgarray.length + content.length];
            System.arraycopy(msgarray, 0, retval, 0, msgarray.length);
            System.arraycopy(content, 0, retval, msgarray.length, content.length);
        } else {
            try {
                retval = encoding.toString().getBytes(this.getCharset());
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException((Exception)ex);
            }
        }
        return retval;
    }

    public Object clone() {
        SIPMessage retval = (SIPMessage)super.clone();
        retval.headerTable = new ConcurrentHashMap();
        retval.fromHeader = null;
        retval.toHeader = null;
        retval.cSeqHeader = null;
        retval.callIdHeader = null;
        retval.contentLengthHeader = null;
        retval.maxForwardsHeader = null;
        retval.forkId = null;
        if (this.headers != null) {
            retval.headers = new ConcurrentLinkedQueue();
            for (SIPHeader hdr : this.headers) {
                retval.attachHeader((SIPHeader)hdr.clone());
            }
        }
        if (this.messageContentBytes != null) {
            retval.messageContentBytes = (byte[])this.messageContentBytes.clone();
        }
        if (this.messageContentObject != null) {
            retval.messageContentObject = SIPMessage.makeClone((Object)this.messageContentObject);
        }
        retval.unrecognizedHeaders = this.unrecognizedHeaders;
        retval.remoteAddress = this.remoteAddress;
        retval.remotePort = this.remotePort;
        return retval;
    }

    public String debugDump() {
        this.stringRepresentation = "";
        this.sprint("SIPMessage:");
        this.sprint("{");
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                Class<?> fieldType = f.getType();
                String fieldName = f.getName();
                if (f.get(this) == null || !SIPHeader.class.isAssignableFrom(fieldType) || fieldName.compareTo("headers") == 0) continue;
                this.sprint(fieldName + "=");
                this.sprint(((SIPHeader)f.get(this)).debugDump());
            }
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException((Exception)ex);
        }
        this.sprint("List of headers : ");
        this.sprint(this.headers.toString());
        this.sprint("messageContent = ");
        this.sprint("{");
        this.sprint(this.messageContent);
        this.sprint("}");
        if (this.getContent() != null) {
            this.sprint(this.getContent().toString());
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    public SIPMessage() {
        try {
            this.attachHeader((SIPHeader)new ContentLength(0), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void attachHeader(SIPHeader h) {
        if (h == null) {
            throw new IllegalArgumentException("null header!");
        }
        try {
            SIPHeaderList hl;
            if (h instanceof SIPHeaderList && (hl = (SIPHeaderList)h).isEmpty()) {
                return;
            }
            this.attachHeader(h, false, false);
        }
        catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
            // empty catch block
        }
    }

    public void setHeader(Header sipHeader) {
        SIPHeader header = (SIPHeader)sipHeader;
        if (header == null) {
            throw new IllegalArgumentException("null header!");
        }
        try {
            SIPHeaderList hl;
            if (header instanceof SIPHeaderList && (hl = (SIPHeaderList)header).isEmpty()) {
                return;
            }
            this.removeHeader(header.getHeaderName());
            this.attachHeader(header, true, false);
        }
        catch (SIPDuplicateHeaderException ex) {
            InternalErrorHandler.handleException((Exception)((Object)ex));
        }
    }

    public void setHeaders(List<SIPHeader> headers) {
        ListIterator<SIPHeader> listIterator = headers.listIterator();
        while (listIterator.hasNext()) {
            SIPHeader sipHeader = listIterator.next();
            try {
                this.attachHeader(sipHeader, false);
            }
            catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {}
        }
    }

    public void attachHeader(SIPHeader h, boolean replaceflag) throws SIPDuplicateHeaderException {
        this.attachHeader(h, replaceflag, false);
    }

    public void attachHeader(SIPHeader header, boolean replaceFlag, boolean top) throws SIPDuplicateHeaderException {
        SIPHeader h;
        if (header == null) {
            throw new NullPointerException("null header");
        }
        if (ListMap.hasList((SIPHeader)header) && !SIPHeaderList.class.isAssignableFrom(header.getClass())) {
            SIPHeaderList hdrList = ListMap.getList((SIPHeader)header);
            hdrList.add(header);
            h = hdrList;
        } else {
            h = header;
        }
        String headerNameLowerCase = SIPHeaderNamesCache.toLowerCase((String)h.getName());
        if (replaceFlag) {
            this.headerTable.remove(headerNameLowerCase);
        } else if (this.headerTable.containsKey(headerNameLowerCase) && !(h instanceof SIPHeaderList)) {
            if (h instanceof ContentLength) {
                try {
                    ContentLength cl = (ContentLength)h;
                    this.contentLengthHeader.setContentLength(cl.getContentLength());
                }
                catch (InvalidArgumentException cl) {
                    // empty catch block
                }
            }
            return;
        }
        SIPHeader originalHeader = (SIPHeader)this.getHeader(header.getName());
        if (originalHeader != null) {
            Iterator li = this.headers.iterator();
            while (li.hasNext()) {
                SIPHeader next = (SIPHeader)li.next();
                if (!next.equals((Object)originalHeader)) continue;
                li.remove();
            }
        }
        if (!this.headerTable.containsKey(headerNameLowerCase)) {
            this.headerTable.put(headerNameLowerCase, h);
            this.headers.add(h);
        } else if (h instanceof SIPHeaderList) {
            SIPHeaderList hdrlist = (SIPHeaderList)this.headerTable.get(headerNameLowerCase);
            if (hdrlist != null) {
                hdrlist.concatenate((SIPHeaderList)h, top);
            } else {
                this.headerTable.put(headerNameLowerCase, h);
            }
        } else {
            this.headerTable.put(headerNameLowerCase, h);
        }
        if (h instanceof From) {
            this.fromHeader = (From)h;
        } else if (h instanceof ContentLength) {
            this.contentLengthHeader = (ContentLength)h;
        } else if (h instanceof To) {
            this.toHeader = (To)h;
        } else if (h instanceof CSeq) {
            this.cSeqHeader = (CSeq)h;
        } else if (h instanceof CallID) {
            this.callIdHeader = (CallID)h;
        } else if (h instanceof MaxForwards) {
            this.maxForwardsHeader = (MaxForwards)h;
        }
    }

    public void removeHeader(String headerName, boolean top) {
        String headerNameLowerCase = SIPHeaderNamesCache.toLowerCase((String)headerName);
        SIPHeader toRemove = (SIPHeader)this.headerTable.get(headerNameLowerCase);
        if (toRemove == null) {
            return;
        }
        if (toRemove instanceof SIPHeaderList) {
            SIPHeaderList hdrList = (SIPHeaderList)toRemove;
            if (top) {
                hdrList.removeFirst();
            } else {
                hdrList.removeLast();
            }
            if (hdrList.isEmpty()) {
                Iterator li = this.headers.iterator();
                while (li.hasNext()) {
                    SIPHeader sipHeader = (SIPHeader)li.next();
                    if (!sipHeader.getName().equalsIgnoreCase(headerNameLowerCase)) continue;
                    li.remove();
                }
                this.headerTable.remove(headerNameLowerCase);
            }
        } else {
            this.headerTable.remove(headerNameLowerCase);
            if (toRemove instanceof From) {
                this.fromHeader = null;
            } else if (toRemove instanceof To) {
                this.toHeader = null;
            } else if (toRemove instanceof CSeq) {
                this.cSeqHeader = null;
            } else if (toRemove instanceof CallID) {
                this.callIdHeader = null;
            } else if (toRemove instanceof MaxForwards) {
                this.maxForwardsHeader = null;
            } else if (toRemove instanceof ContentLength) {
                this.contentLengthHeader = null;
            }
            Iterator li = this.headers.iterator();
            while (li.hasNext()) {
                SIPHeader sipHeader = (SIPHeader)li.next();
                if (!sipHeader.getName().equalsIgnoreCase(headerName)) continue;
                li.remove();
            }
        }
    }

    public void removeHeader(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null arg");
        }
        String headerNameLowerCase = SIPHeaderNamesCache.toLowerCase((String)headerName);
        SIPHeader removed = (SIPHeader)this.headerTable.remove(headerNameLowerCase);
        if (removed == null) {
            return;
        }
        if (removed instanceof From) {
            this.fromHeader = null;
        } else if (removed instanceof To) {
            this.toHeader = null;
        } else if (removed instanceof CSeq) {
            this.cSeqHeader = null;
        } else if (removed instanceof CallID) {
            this.callIdHeader = null;
        } else if (removed instanceof MaxForwards) {
            this.maxForwardsHeader = null;
        } else if (removed instanceof ContentLength) {
            this.contentLengthHeader = null;
        }
        Iterator li = this.headers.iterator();
        while (li.hasNext()) {
            SIPHeader sipHeader = (SIPHeader)li.next();
            if (!sipHeader.getName().equalsIgnoreCase(headerNameLowerCase)) continue;
            li.remove();
        }
    }

    public String getTransactionId() {
        Via topVia = this.getTopmostVia();
        if (topVia != null && topVia.getBranch() != null && topVia.getBranch().toUpperCase().startsWith("Z9HG4BK")) {
            if (this.getCSeq().getMethod().equals("CANCEL")) {
                return (topVia.getBranch() + ":" + this.getCSeq().getMethod()).toLowerCase();
            }
            return topVia.getBranch().toLowerCase();
        }
        StringBuilder retval = new StringBuilder();
        From from = (From)this.getFrom();
        To to = (To)this.getTo();
        if (from.hasTag()) {
            retval.append(from.getTag()).append("-");
        }
        String cid = this.callIdHeader.getCallId();
        retval.append(cid).append("-");
        retval.append(this.cSeqHeader.getSequenceNumber()).append("-").append(this.cSeqHeader.getMethod());
        if (topVia != null) {
            retval.append("-").append(topVia.getSentBy().encode());
            if (!topVia.getSentBy().hasPort()) {
                retval.append("-").append(5060);
            }
        }
        if (this.getCSeq().getMethod().equals("CANCEL")) {
            retval.append("CANCEL");
        }
        return retval.toString().toLowerCase().replace(":", "-").replace("@", "-") + Utils.getSignature();
    }

    public int hashCode() {
        if (this.callIdHeader == null) {
            throw new RuntimeException("Invalid message! Cannot compute hashcode! call-id header is missing !");
        }
        return this.callIdHeader.getCallId().hashCode();
    }

    public boolean hasContent() {
        return this.messageContent != null || this.messageContentBytes != null;
    }

    public Iterator<SIPHeader> getHeaders() {
        return this.headers.iterator();
    }

    public Header getHeader(String headerName) {
        return this.getHeaderLowerCase(SIPHeaderNamesCache.toLowerCase((String)headerName));
    }

    protected Header getHeaderLowerCase(String lowerCaseHeaderName) {
        if (lowerCaseHeaderName == null) {
            throw new NullPointerException("bad name");
        }
        SIPHeader sipHeader = (SIPHeader)this.headerTable.get(lowerCaseHeaderName);
        if (sipHeader instanceof SIPHeaderList) {
            return ((SIPHeaderList)sipHeader).getFirst();
        }
        return sipHeader;
    }

    public ContentType getContentTypeHeader() {
        return (ContentType)this.getHeaderLowerCase(CONTENT_TYPE_LOWERCASE);
    }

    public ContentLengthHeader getContentLengthHeader() {
        return this.getContentLength();
    }

    public FromHeader getFrom() {
        return this.fromHeader;
    }

    public ErrorInfoList getErrorInfoHeaders() {
        return (ErrorInfoList)this.getSIPHeaderListLowerCase(ERROR_LOWERCASE);
    }

    public ContactList getContactHeaders() {
        return (ContactList)this.getSIPHeaderListLowerCase(CONTACT_LOWERCASE);
    }

    public Contact getContactHeader() {
        ContactList clist = this.getContactHeaders();
        if (clist != null) {
            return (Contact)clist.getFirst();
        }
        return null;
    }

    public ViaList getViaHeaders() {
        return (ViaList)this.getSIPHeaderListLowerCase(VIA_LOWERCASE);
    }

    public void setVia(List viaList) {
        ViaList vList = new ViaList();
        ListIterator it = viaList.listIterator();
        while (it.hasNext()) {
            Via via = (Via)it.next();
            vList.add((SIPHeader)via);
        }
        this.setHeader((SIPHeaderList)vList);
    }

    public void setHeader(SIPHeaderList<Via> sipHeaderList) {
        this.setHeader(sipHeaderList);
    }

    public Via getTopmostVia() {
        if (this.getViaHeaders() == null) {
            return null;
        }
        return (Via)this.getViaHeaders().getFirst();
    }

    public CSeqHeader getCSeq() {
        return this.cSeqHeader;
    }

    public Authorization getAuthorization() {
        return (Authorization)this.getHeaderLowerCase(AUTHORIZATION_LOWERCASE);
    }

    public MaxForwardsHeader getMaxForwards() {
        return this.maxForwardsHeader;
    }

    public void setMaxForwards(MaxForwardsHeader maxForwards) {
        this.setHeader((Header)maxForwards);
    }

    public RouteList getRouteHeaders() {
        return (RouteList)this.getSIPHeaderListLowerCase(ROUTE_LOWERCASE);
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    public void setCallId(CallIdHeader callId) {
        this.setHeader((Header)callId);
    }

    public void setCallId(String callId) throws ParseException {
        if (this.callIdHeader == null) {
            this.setHeader((Header)new CallID());
        }
        this.callIdHeader.setCallId(callId);
    }

    public RecordRouteList getRecordRouteHeaders() {
        return (RecordRouteList)this.getSIPHeaderListLowerCase(RECORDROUTE_LOWERCASE);
    }

    public ToHeader getTo() {
        return this.toHeader;
    }

    public void setTo(ToHeader to) {
        this.setHeader((Header)to);
    }

    public void setFrom(FromHeader from) {
        this.setHeader((Header)from);
    }

    public ContentLengthHeader getContentLength() {
        return this.contentLengthHeader;
    }

    public String getMessageContent() throws UnsupportedEncodingException {
        if (this.messageContent == null && this.messageContentBytes == null) {
            return null;
        }
        if (this.messageContent == null) {
            this.messageContent = new String(this.messageContentBytes, this.getCharset());
        }
        return this.messageContent;
    }

    public byte[] getRawContent() {
        try {
            if (this.messageContentBytes == null) {
                if (this.messageContentObject != null) {
                    String messageContent = this.messageContentObject.toString();
                    this.messageContentBytes = messageContent.getBytes(this.getCharset());
                } else if (this.messageContent != null) {
                    this.messageContentBytes = this.messageContent.getBytes(this.getCharset());
                }
            }
            return this.messageContentBytes;
        }
        catch (UnsupportedEncodingException ex) {
            InternalErrorHandler.handleException((Exception)ex);
            return null;
        }
    }

    public void setMessageContent(String type, String subType, String messageContent) {
        if (messageContent == null) {
            throw new IllegalArgumentException("messgeContent is null");
        }
        ContentType ct = new ContentType(type, subType);
        this.setHeader((Header)ct);
        this.messageContent = messageContent;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        this.computeContentLength((Object)messageContent);
    }

    public void setContent(Object content, ContentTypeHeader contentTypeHeader) throws ParseException {
        if (content == null) {
            throw new NullPointerException("null content");
        }
        this.setHeader((Header)contentTypeHeader);
        this.messageContent = null;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        if (content instanceof String) {
            this.messageContent = (String)content;
        } else if (content instanceof byte[]) {
            this.messageContentBytes = (byte[])content;
        } else {
            this.messageContentObject = content;
        }
        this.computeContentLength(content);
    }

    public Object getContent() {
        if (this.messageContentObject != null) {
            return this.messageContentObject;
        }
        if (this.messageContent != null) {
            return this.messageContent;
        }
        if (this.messageContentBytes != null) {
            return this.messageContentBytes;
        }
        return null;
    }

    public void setMessageContent(String type, String subType, byte[] messageContent) {
        ContentType ct = new ContentType(type, subType);
        this.setHeader((Header)ct);
        this.setMessageContent(messageContent);
        this.computeContentLength((Object)messageContent);
    }

    public void setMessageContent(byte[] content, boolean strict, boolean computeContentLength, int givenLength) throws ParseException {
        this.computeContentLength((Object)content);
        if (!computeContentLength && (!strict && this.contentLengthHeader.getContentLength() != givenLength || this.contentLengthHeader.getContentLength() < givenLength)) {
            throw new ParseException("Invalid content length " + this.contentLengthHeader.getContentLength() + " / " + givenLength, 0);
        }
        this.messageContent = null;
        this.messageContentBytes = content;
        this.messageContentObject = null;
    }

    public void setMessageContent(byte[] content) {
        this.computeContentLength((Object)content);
        this.messageContentBytes = content;
        this.messageContent = null;
        this.messageContentObject = null;
    }

    public void setMessageContent(byte[] content, boolean computeContentLength, int givenLength) throws ParseException {
        this.computeContentLength((Object)content);
        if (!computeContentLength && this.contentLengthHeader.getContentLength() < givenLength) {
            throw new ParseException("Invalid content length " + this.contentLengthHeader.getContentLength() + " / " + givenLength, 0);
        }
        this.messageContentBytes = content;
        this.messageContent = null;
        this.messageContentObject = null;
    }

    private void computeContentLength(Object content) {
        int length = 0;
        if (content != null) {
            if (content instanceof String) {
                try {
                    length = ((String)content).getBytes(this.getCharset()).length;
                }
                catch (UnsupportedEncodingException ex) {
                    InternalErrorHandler.handleException((Exception)ex);
                }
            } else {
                length = content instanceof byte[] ? ((byte[])content).length : content.toString().length();
            }
        }
        try {
            this.contentLengthHeader.setContentLength(length);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public void removeContent() {
        this.messageContent = null;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        try {
            this.contentLengthHeader.setContentLength(0);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public ListIterator<SIPHeader> getHeaders(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null headerName");
        }
        SIPHeader sipHeader = (SIPHeader)this.headerTable.get(SIPHeaderNamesCache.toLowerCase((String)headerName));
        if (sipHeader == null) {
            return new LinkedList().listIterator();
        }
        if (sipHeader instanceof SIPHeaderList) {
            return ((SIPHeaderList)sipHeader).listIterator();
        }
        return new HeaderIterator(this, sipHeader);
    }

    public String getHeaderAsFormattedString(String name) {
        String lowerCaseName = SIPHeaderNamesCache.toLowerCase((String)name);
        if (this.headerTable.containsKey(lowerCaseName)) {
            return ((SIPHeader)this.headerTable.get(lowerCaseName)).toString();
        }
        return this.getHeader(name).toString();
    }

    public SIPHeader getSIPHeaderListLowerCase(String lowerCaseHeaderName) {
        return (SIPHeader)this.headerTable.get(lowerCaseHeaderName);
    }

    private List<SIPHeader> getHeaderList(String headerName) {
        SIPHeader sipHeader = (SIPHeader)this.headerTable.get(SIPHeaderNamesCache.toLowerCase((String)headerName));
        if (sipHeader == null) {
            return null;
        }
        if (sipHeader instanceof SIPHeaderList) {
            return ((SIPHeaderList)sipHeader).getHeaderList();
        }
        LinkedList<SIPHeader> ll = new LinkedList<SIPHeader>();
        ll.add(sipHeader);
        return ll;
    }

    public boolean hasHeader(String headerName) {
        return this.headerTable.containsKey(SIPHeaderNamesCache.toLowerCase((String)headerName));
    }

    public boolean hasFromTag() {
        return this.fromHeader != null && this.fromHeader.getTag() != null;
    }

    public boolean hasToTag() {
        return this.toHeader != null && this.toHeader.getTag() != null;
    }

    public String getFromTag() {
        return this.fromHeader == null ? null : this.fromHeader.getTag();
    }

    public void setFromTag(String tag) {
        try {
            this.fromHeader.setTag(tag);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setToTag(String tag) {
        try {
            this.toHeader.setTag(tag);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getToTag() {
        return this.toHeader == null ? null : this.toHeader.getTag();
    }

    public abstract String getFirstLine();

    public void addHeader(Header sipHeader) {
        SIPHeader sh = (SIPHeader)sipHeader;
        try {
            if (sipHeader instanceof ViaHeader || sipHeader instanceof RecordRouteHeader) {
                this.attachHeader(sh, false, true);
            } else {
                this.attachHeader(sh, false, false);
            }
        }
        catch (SIPDuplicateHeaderException ex) {
            try {
                if (sipHeader instanceof ContentLength) {
                    ContentLength cl = (ContentLength)sipHeader;
                    this.contentLengthHeader.setContentLength(cl.getContentLength());
                }
            }
            catch (InvalidArgumentException invalidArgumentException) {
                // empty catch block
            }
        }
    }

    public void addUnparsed(String unparsed) {
        this.getUnrecognizedHeadersList().add(unparsed);
    }

    public void addHeader(String sipHeader) {
        String hdrString = sipHeader.trim() + "\n";
        try {
            HeaderParser parser = ParserFactory.createParser((String)sipHeader);
            SIPHeader sh = parser.parse();
            this.attachHeader(sh, false);
        }
        catch (ParseException ex) {
            this.getUnrecognizedHeadersList().add(hdrString);
        }
    }

    public ListIterator<String> getUnrecognizedHeaders() {
        return this.getUnrecognizedHeadersList().listIterator();
    }

    public ListIterator<String> getHeaderNames() {
        Iterator li = this.headers.iterator();
        LinkedList<String> retval = new LinkedList<String>();
        while (li.hasNext()) {
            SIPHeader sipHeader = (SIPHeader)li.next();
            String name = sipHeader.getName();
            retval.add(name);
        }
        return retval.listIterator();
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPMessage otherMessage = (SIPMessage)other;
        Collection values = this.headerTable.values();
        Iterator it = values.iterator();
        if (this.headerTable.size() != otherMessage.headerTable.size()) {
            return false;
        }
        while (it.hasNext()) {
            SIPHeader mine = (SIPHeader)it.next();
            SIPHeader his = (SIPHeader)otherMessage.headerTable.get(SIPHeaderNamesCache.toLowerCase((String)mine.getName()));
            if (his == null) {
                return false;
            }
            if (his.equals((Object)mine)) continue;
            return false;
        }
        return true;
    }

    public ContentDispositionHeader getContentDisposition() {
        return (ContentDispositionHeader)this.getHeaderLowerCase(CONTENT_DISPOSITION_LOWERCASE);
    }

    public ContentEncodingHeader getContentEncoding() {
        return (ContentEncodingHeader)this.getHeaderLowerCase(CONTENT_ENCODING_LOWERCASE);
    }

    public ContentLanguageHeader getContentLanguage() {
        return (ContentLanguageHeader)this.getHeaderLowerCase(CONTENT_LANGUAGE_LOWERCASE);
    }

    public ExpiresHeader getExpires() {
        return (ExpiresHeader)this.getHeaderLowerCase(EXPIRES_LOWERCASE);
    }

    public void setExpires(ExpiresHeader expiresHeader) {
        this.setHeader((Header)expiresHeader);
    }

    public void setContentDisposition(ContentDispositionHeader contentDispositionHeader) {
        this.setHeader((Header)contentDispositionHeader);
    }

    public void setContentEncoding(ContentEncodingHeader contentEncodingHeader) {
        this.setHeader((Header)contentEncodingHeader);
    }

    public void setContentLanguage(ContentLanguageHeader contentLanguageHeader) {
        this.setHeader((Header)contentLanguageHeader);
    }

    public void setContentLength(ContentLengthHeader contentLength) {
        try {
            this.contentLengthHeader.setContentLength(contentLength.getContentLength());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void addLast(Header header) throws SipException, NullPointerException {
        if (header == null) {
            throw new NullPointerException("null arg!");
        }
        try {
            this.attachHeader((SIPHeader)header, false, false);
        }
        catch (SIPDuplicateHeaderException ex) {
            throw new SipException("Cannot add header - header already exists");
        }
    }

    public void addFirst(Header header) throws SipException, NullPointerException {
        if (header == null) {
            throw new NullPointerException("null arg!");
        }
        try {
            this.attachHeader((SIPHeader)header, false, true);
        }
        catch (SIPDuplicateHeaderException ex) {
            throw new SipException("Cannot add header - header already exists");
        }
    }

    public void removeFirst(String headerName) throws NullPointerException {
        if (headerName == null) {
            throw new NullPointerException("Null argument Provided!");
        }
        this.removeHeader(headerName, true);
    }

    public void removeLast(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("Null argument Provided!");
        }
        this.removeHeader(headerName, false);
    }

    public void setCSeq(CSeqHeader cseqHeader) {
        this.setHeader((Header)cseqHeader);
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public MultipartMimeContent getMultipartMimeContent() throws ParseException {
        if (this.contentLengthHeader.getContentLength() == 0) {
            return null;
        }
        MultipartMimeContentImpl retval = new MultipartMimeContentImpl((ContentTypeHeader)this.getContentTypeHeader());
        byte[] rawContent = this.getRawContent();
        try {
            String body = new String(rawContent, this.getCharset());
            retval.createContentList(body);
            return retval;
        }
        catch (UnsupportedEncodingException e) {
            InternalErrorHandler.handleException((Exception)e);
            return null;
        }
    }

    public CallIdHeader getCallIdHeader() {
        return this.callIdHeader;
    }

    public FromHeader getFromHeader() {
        return this.fromHeader;
    }

    public ToHeader getToHeader() {
        return this.toHeader;
    }

    public ViaHeader getTopmostViaHeader() {
        return this.getTopmostVia();
    }

    public CSeqHeader getCSeqHeader() {
        return this.cSeqHeader;
    }

    protected final String getCharset() {
        ContentType ct = this.getContentTypeHeader();
        if (ct != null) {
            String c = ct.getCharset();
            return c != null ? c : this.contentEncodingCharset;
        }
        return this.contentEncodingCharset;
    }

    public boolean isNullRequest() {
        return this.nullRequest;
    }

    public void setNullRequest() {
        this.nullRequest = true;
    }

    public String getForkId() {
        if (this.forkId != null) {
            return this.forkId;
        }
        String callId = this.getCallId().getCallId();
        String fromTag = this.getFromTag();
        if (fromTag == null) {
            throw new IllegalStateException("From tag is not yet set. Cannot compute forkId");
        }
        this.forkId = (callId + ":" + fromTag).toLowerCase();
        return this.forkId;
    }

    public abstract void setSIPVersion(String var1) throws ParseException;

    public abstract String getSIPVersion();

    public abstract String toString();

    public void cleanUp() {
    }

    protected void setUnrecognizedHeadersList(LinkedList<String> unrecognizedHeaders) {
        this.unrecognizedHeaders = unrecognizedHeaders;
    }

    protected LinkedList<String> getUnrecognizedHeadersList() {
        if (this.unrecognizedHeaders == null) {
            this.unrecognizedHeaders = new LinkedList();
        }
        return this.unrecognizedHeaders;
    }

    public void setRemoteAddress(InetAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getLocalPort() {
        return this.localPort;
    }
}

