/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.message;

import com.coraltele.interfaces.sip.header.ContentDispositionHeader;
import com.coraltele.interfaces.sip.header.ContentTypeHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.javax.sip.header.HeaderFactoryImpl;
import com.coraltele.javax.sip.message.Content;
import com.coraltele.javax.sip.message.ContentImpl;
import com.coraltele.javax.sip.message.MultipartMimeContent;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MultipartMimeContentImpl
implements MultipartMimeContent {
    private List<Content> contentList = new LinkedList();
    private ContentTypeHeader multipartMimeContentTypeHeader;
    private String boundary;
    public static String BOUNDARY = "boundary";

    public MultipartMimeContentImpl(ContentTypeHeader contentTypeHeader) {
        this.multipartMimeContentTypeHeader = contentTypeHeader;
        this.boundary = contentTypeHeader.getParameter(BOUNDARY);
    }

    public boolean add(Content content) {
        return this.contentList.add((ContentImpl)content);
    }

    public ContentTypeHeader getContentTypeHeader() {
        return this.multipartMimeContentTypeHeader;
    }

    public String toString() {
        StringBuilder StringBuilder2 = new StringBuilder();
        for (Content content : this.contentList) {
            StringBuilder2.append(content.toString());
        }
        return StringBuilder2.toString();
    }

    public void createContentList(String body) throws ParseException {
        try {
            String[] fragments;
            HeaderFactoryImpl headerFactory = new HeaderFactoryImpl();
            String delimiter = this.getContentTypeHeader().getParameter(BOUNDARY);
            if (delimiter == null) {
                this.contentList = new LinkedList();
                ContentImpl content = new ContentImpl(body, delimiter);
                content.setContentTypeHeader(this.getContentTypeHeader());
                this.contentList.add(content);
                return;
            }
            for (String nextPart : fragments = body.split("--" + delimiter + "\r\n")) {
                String[] headerArray;
                if (nextPart == null) {
                    return;
                }
                StringBuilder strbuf = new StringBuilder(nextPart);
                while (strbuf.length() > 0 && (strbuf.charAt(0) == '\r' || strbuf.charAt(0) == '\n')) {
                    strbuf.deleteCharAt(0);
                }
                if (strbuf.length() == 0) continue;
                nextPart = strbuf.toString();
                int position = nextPart.indexOf("\r\n\r\n");
                int off = 4;
                if (position == -1) {
                    position = nextPart.indexOf("\n");
                    off = 2;
                }
                if (position == -1) {
                    throw new ParseException("no content type header found in " + nextPart, 0);
                }
                String rest = nextPart.substring(position + off);
                if (rest == null) {
                    throw new ParseException("No content [" + nextPart + "]", 0);
                }
                String headers = nextPart.substring(0, position);
                ContentImpl content = new ContentImpl(rest, this.boundary);
                for (String hdr : headerArray = headers.split("\r\n")) {
                    Header header = headerFactory.createHeader(hdr);
                    if (header instanceof ContentTypeHeader) {
                        content.setContentTypeHeader((ContentTypeHeader)header);
                    } else if (header instanceof ContentDispositionHeader) {
                        content.setContentDispositionHeader((ContentDispositionHeader)header);
                    } else {
                        throw new ParseException("Unexpected header type " + header.getName(), 0);
                    }
                    this.contentList.add(content);
                }
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new ParseException("Invalid Multipart mime format", 0);
        }
    }

    public Content getContentByType(String contentType, String contentSubtype) {
        Content retval = null;
        if (this.contentList == null) {
            return null;
        }
        for (Content content : this.contentList) {
            if (!content.getContentTypeHeader().getContentType().equalsIgnoreCase(contentType) || !content.getContentTypeHeader().getContentSubType().equalsIgnoreCase(contentSubtype)) continue;
            retval = content;
            break;
        }
        return retval;
    }

    public void addContent(Content content) {
        this.add(content);
    }

    public Iterator<Content> getContents() {
        return this.contentList.iterator();
    }

    public int getContentCount() {
        return this.contentList.size();
    }
}

