/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.message;

import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContentTypeHeader;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.header.MaxForwardsHeader;
import com.coraltele.interfaces.sip.header.ServerHeader;
import com.coraltele.interfaces.sip.header.ToHeader;
import com.coraltele.interfaces.sip.header.UserAgentHeader;
import com.coraltele.interfaces.sip.message.MessageFactory;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.header.ContentType;
import com.coraltele.javax.sip.header.StatusLine;
import com.coraltele.javax.sip.message.Content;
import com.coraltele.javax.sip.message.ContentImpl;
import com.coraltele.javax.sip.message.MessageFactoryExt;
import com.coraltele.javax.sip.message.MessageFactoryImpl;
import com.coraltele.javax.sip.message.MultipartMimeContent;
import com.coraltele.javax.sip.message.MultipartMimeContentImpl;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.parser.ParseExceptionListener;
import com.coraltele.javax.sip.parser.StringMsgParser;
import java.text.ParseException;
import java.util.List;

public class MessageFactoryImpl
implements MessageFactory,
MessageFactoryExt {
    private boolean testing = false;
    private boolean strict = true;
    private static String defaultContentEncodingCharset = "UTF-8";
    private static UserAgentHeader userAgent;
    private static ServerHeader server;

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setTest(boolean flag) {
        this.testing = flag;
    }

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, Object content) throws ParseException {
        if (requestURI == null || method == null || callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException("Null parameters");
        }
        SIPRequest sipRequest = new SIPRequest();
        sipRequest.setRequestURI(requestURI);
        sipRequest.setMethod(method);
        sipRequest.setCallId(callId);
        sipRequest.setCSeq(cSeq);
        sipRequest.setFrom(from);
        sipRequest.setTo(to);
        sipRequest.setVia(via);
        sipRequest.setMaxForwards(maxForwards);
        sipRequest.setContent(content, contentType);
        if (userAgent != null) {
            sipRequest.setHeader((Header)userAgent);
        }
        return sipRequest;
    }

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, byte[] content, ContentTypeHeader contentType) throws ParseException {
        if (requestURI == null || method == null || callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new ParseException("JAIN-SIP Exception, some parameters are missing, unable to create the request", 0);
        }
        SIPRequest sipRequest = new SIPRequest();
        sipRequest.setRequestURI(requestURI);
        sipRequest.setMethod(method);
        sipRequest.setCallId(callId);
        sipRequest.setCSeq(cSeq);
        sipRequest.setFrom(from);
        sipRequest.setTo(to);
        sipRequest.setVia(via);
        sipRequest.setMaxForwards(maxForwards);
        sipRequest.setHeader((Header)((ContentType)contentType));
        sipRequest.setMessageContent(content);
        if (userAgent != null) {
            sipRequest.setHeader((Header)userAgent);
        }
        return sipRequest;
    }

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards) throws ParseException {
        if (requestURI == null || method == null || callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null) {
            throw new ParseException("JAIN-SIP Exception, some parameters are missing, unable to create the request", 0);
        }
        SIPRequest sipRequest = new SIPRequest();
        sipRequest.setRequestURI(requestURI);
        sipRequest.setMethod(method);
        sipRequest.setCallId(callId);
        sipRequest.setCSeq(cSeq);
        sipRequest.setFrom(from);
        sipRequest.setTo(to);
        sipRequest.setVia(via);
        sipRequest.setMaxForwards(maxForwards);
        if (userAgent != null) {
            sipRequest.setHeader((Header)userAgent);
        }
        return sipRequest;
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, Object content, ContentTypeHeader contentType) throws ParseException {
        if (callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException(" unable to create the response");
        }
        SIPResponse sipResponse = new SIPResponse();
        StatusLine statusLine = new StatusLine();
        statusLine.setStatusCode(statusCode);
        String reasonPhrase = SIPResponse.getReasonPhrase((int)statusCode);
        statusLine.setReasonPhrase(reasonPhrase);
        sipResponse.setStatusLine(statusLine);
        sipResponse.setCallId(callId);
        sipResponse.setCSeq(cSeq);
        sipResponse.setFrom(from);
        sipResponse.setTo(to);
        sipResponse.setVia(via);
        sipResponse.setMaxForwards(maxForwards);
        sipResponse.setContent(content, contentType);
        if (userAgent != null) {
            sipResponse.setHeader((Header)userAgent);
        }
        return sipResponse;
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, byte[] content, ContentTypeHeader contentType) throws ParseException {
        if (callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException("Null params ");
        }
        SIPResponse sipResponse = new SIPResponse();
        sipResponse.setStatusCode(statusCode);
        sipResponse.setCallId(callId);
        sipResponse.setCSeq(cSeq);
        sipResponse.setFrom(from);
        sipResponse.setTo(to);
        sipResponse.setVia(via);
        sipResponse.setMaxForwards(maxForwards);
        sipResponse.setHeader((Header)((ContentType)contentType));
        sipResponse.setMessageContent(content);
        if (userAgent != null) {
            sipResponse.setHeader((Header)userAgent);
        }
        return sipResponse;
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards) throws ParseException {
        if (callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null) {
            throw new ParseException("JAIN-SIP Exception, some parameters are missing, unable to create the response", 0);
        }
        SIPResponse sipResponse = new SIPResponse();
        sipResponse.setStatusCode(statusCode);
        sipResponse.setCallId(callId);
        sipResponse.setCSeq(cSeq);
        sipResponse.setFrom(from);
        sipResponse.setTo(to);
        sipResponse.setVia(via);
        sipResponse.setMaxForwards(maxForwards);
        if (userAgent != null) {
            sipResponse.setHeader((Header)userAgent);
        }
        return sipResponse;
    }

    public Response createResponse(int statusCode, Request request, ContentTypeHeader contentType, Object content) throws ParseException {
        if (request == null || content == null || contentType == null) {
            throw new NullPointerException("null parameters");
        }
        SIPRequest sipRequest = (SIPRequest)request;
        SIPResponse sipResponse = sipRequest.createResponse(statusCode);
        sipResponse.setContent(content, contentType);
        if (server != null) {
            sipResponse.setHeader((Header)server);
        }
        return sipResponse;
    }

    public Response createResponse(int statusCode, Request request, ContentTypeHeader contentType, byte[] content) throws ParseException {
        if (request == null || content == null || contentType == null) {
            throw new NullPointerException("null Parameters");
        }
        SIPRequest sipRequest = (SIPRequest)request;
        SIPResponse sipResponse = sipRequest.createResponse(statusCode);
        sipResponse.setHeader((Header)((ContentType)contentType));
        sipResponse.setMessageContent(content);
        if (server != null) {
            sipResponse.setHeader((Header)server);
        }
        return sipResponse;
    }

    public Response createResponse(int statusCode, Request request) throws ParseException {
        if (request == null) {
            throw new NullPointerException("null parameters");
        }
        SIPRequest sipRequest = (SIPRequest)request;
        SIPResponse sipResponse = sipRequest.createResponse(statusCode);
        sipResponse.removeContent();
        sipResponse.removeHeader("Content-Type");
        if (server != null) {
            sipResponse.setHeader((Header)server);
        }
        return sipResponse;
    }

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, byte[] content) throws ParseException {
        if (requestURI == null || method == null || callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException("missing parameters");
        }
        SIPRequest sipRequest = new SIPRequest();
        sipRequest.setRequestURI(requestURI);
        sipRequest.setMethod(method);
        sipRequest.setCallId(callId);
        sipRequest.setCSeq(cSeq);
        sipRequest.setFrom(from);
        sipRequest.setTo(to);
        sipRequest.setVia(via);
        sipRequest.setMaxForwards(maxForwards);
        sipRequest.setContent((Object)content, contentType);
        if (userAgent != null) {
            sipRequest.setHeader((Header)userAgent);
        }
        return sipRequest;
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, Object content) throws ParseException {
        if (callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException("missing parameters");
        }
        SIPResponse sipResponse = new SIPResponse();
        StatusLine statusLine = new StatusLine();
        statusLine.setStatusCode(statusCode);
        String reason = SIPResponse.getReasonPhrase((int)statusCode);
        if (reason == null) {
            throw new ParseException(statusCode + " Unknown", 0);
        }
        statusLine.setReasonPhrase(reason);
        sipResponse.setStatusLine(statusLine);
        sipResponse.setCallId(callId);
        sipResponse.setCSeq(cSeq);
        sipResponse.setFrom(from);
        sipResponse.setTo(to);
        sipResponse.setVia(via);
        sipResponse.setContent(content, contentType);
        if (userAgent != null) {
            sipResponse.setHeader((Header)userAgent);
        }
        return sipResponse;
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, byte[] content) throws ParseException {
        if (callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException("missing parameters");
        }
        SIPResponse sipResponse = new SIPResponse();
        StatusLine statusLine = new StatusLine();
        statusLine.setStatusCode(statusCode);
        String reason = SIPResponse.getReasonPhrase((int)statusCode);
        if (reason == null) {
            throw new ParseException(statusCode + " : Unknown", 0);
        }
        statusLine.setReasonPhrase(reason);
        sipResponse.setStatusLine(statusLine);
        sipResponse.setCallId(callId);
        sipResponse.setCSeq(cSeq);
        sipResponse.setFrom(from);
        sipResponse.setTo(to);
        sipResponse.setVia(via);
        sipResponse.setContent((Object)content, contentType);
        if (userAgent != null) {
            sipResponse.setHeader((Header)userAgent);
        }
        return sipResponse;
    }

    public Request createRequest(String requestString) throws ParseException {
        SIPMessage sipMessage;
        if (requestString == null || requestString.equals("")) {
            SIPRequest retval = new SIPRequest();
            retval.setNullRequest();
            return retval;
        }
        StringMsgParser smp = new StringMsgParser();
        1 parseExceptionListener = new /* Unavailable Anonymous Inner Class!! */;
        1 exHandler = null;
        if (this.testing) {
            exHandler = parseExceptionListener;
        }
        if (!((sipMessage = smp.parseSIPMessage(requestString.getBytes(), true, this.strict, (ParseExceptionListener)exHandler)) instanceof SIPRequest)) {
            throw new ParseException(requestString, 0);
        }
        return (SIPRequest)sipMessage;
    }

    public Response createResponse(String responseString) throws ParseException {
        if (responseString == null) {
            return new SIPResponse();
        }
        StringMsgParser smp = new StringMsgParser();
        SIPMessage sipMessage = smp.parseSIPMessage(responseString.getBytes(), true, false, null);
        if (!(sipMessage instanceof SIPResponse)) {
            throw new ParseException(responseString, 0);
        }
        return (SIPResponse)sipMessage;
    }

    public void setDefaultUserAgentHeader(UserAgentHeader userAgent) {
        MessageFactoryImpl.userAgent = userAgent;
    }

    public void setDefaultServerHeader(ServerHeader server) {
        MessageFactoryImpl.server = server;
    }

    public static UserAgentHeader getDefaultUserAgentHeader() {
        return userAgent;
    }

    public static ServerHeader getDefaultServerHeader() {
        return server;
    }

    public void setDefaultContentEncodingCharset(String charset) throws NullPointerException, IllegalArgumentException {
        if (charset == null) {
            throw new NullPointerException("Null argument!");
        }
        defaultContentEncodingCharset = charset;
    }

    public static String getDefaultContentEncodingCharset() {
        return defaultContentEncodingCharset;
    }

    public MultipartMimeContent createMultipartMimeContent(ContentTypeHeader multipartMimeCth, String[] contentType, String[] contentSubtype, String[] contentBody) {
        String boundary = multipartMimeCth.getParameter("boundary");
        MultipartMimeContentImpl retval = new MultipartMimeContentImpl(multipartMimeCth);
        for (int i = 0; i < contentType.length; ++i) {
            ContentType cth = new ContentType(contentType[i], contentSubtype[i]);
            ContentImpl contentImpl = new ContentImpl(contentBody[i], boundary);
            contentImpl.setContentTypeHeader((ContentTypeHeader)cth);
            retval.add((Content)contentImpl);
        }
        return retval;
    }

    static /* synthetic */ boolean access$000(MessageFactoryImpl x0) {
        return x0.testing;
    }
}

