/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header.ims;

import com.coraltele.core.NameValue;
import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.header.Parameters;
import com.coraltele.javax.sip.header.ParametersHeader;
import com.coraltele.javax.sip.header.ims.SecurityAgreeHeader;
import java.text.ParseException;

public abstract class SecurityAgree
extends ParametersHeader {
    private String secMechanism;

    public SecurityAgree(String name) {
        super(name);
        this.parameters.setSeparator(";");
    }

    public SecurityAgree() {
        this.parameters.setSeparator(";");
    }

    public void setParameter(String name, String value) throws ParseException {
        if (value == null) {
            throw new NullPointerException("null value");
        }
        NameValue nv = this.parameters.getNameValue(name.toLowerCase());
        if (nv == null) {
            nv = new NameValue(name, (Object)value);
            if (name.equalsIgnoreCase("d-ver")) {
                nv.setQuotedValue();
                if (value.startsWith("\"")) {
                    throw new ParseException(value + " : Unexpected DOUBLE_QUOTE", 0);
                }
            }
            super.setParameter(nv);
        } else {
            nv.setValueAsObject((Object)value);
        }
    }

    public StringBuilder encodeBody(StringBuilder retval) {
        retval.append(this.secMechanism).append(";").append(" ");
        return this.parameters.encode(retval);
    }

    public void setSecurityMechanism(String secMech) throws ParseException {
        if (secMech == null) {
            throw new NullPointerException("JAIN-SIP Exception, SecurityAgree, setSecurityMechanism(), the sec-mechanism parameter is null");
        }
        this.secMechanism = secMech;
    }

    public void setEncryptionAlgorithm(String ealg) throws ParseException {
        if (ealg == null) {
            throw new NullPointerException("JAIN-SIP Exception, SecurityClient, setEncryptionAlgorithm(), the encryption-algorithm parameter is null");
        }
        this.setParameter("ealg", ealg);
    }

    public void setAlgorithm(String alg) throws ParseException {
        if (alg == null) {
            throw new NullPointerException("JAIN-SIP Exception, SecurityClient, setAlgorithm(), the algorithm parameter is null");
        }
        this.setParameter("alg", alg);
    }

    public void setProtocol(String prot) throws ParseException {
        if (prot == null) {
            throw new NullPointerException("JAIN-SIP Exception, SecurityClient, setProtocol(), the protocol parameter is null");
        }
        this.setParameter("prot", prot);
    }

    public void setMode(String mod) throws ParseException {
        if (mod == null) {
            throw new NullPointerException("JAIN-SIP Exception, SecurityClient, setMode(), the mode parameter is null");
        }
        this.setParameter("mod", mod);
    }

    public void setSPIClient(int spic) throws InvalidArgumentException {
        if (spic < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SecurityClient, setSPIClient(), the spi-c parameter is <0");
        }
        this.setParameter("spi-c", spic);
    }

    public void setSPIServer(int spis) throws InvalidArgumentException {
        if (spis < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SecurityClient, setSPIServer(), the spi-s parameter is <0");
        }
        this.setParameter("spi-s", spis);
    }

    public void setPortClient(int portC) throws InvalidArgumentException {
        if (portC < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SecurityClient, setPortClient(), the port-c parameter is <0");
        }
        this.setParameter("port-c", portC);
    }

    public void setPortServer(int portS) throws InvalidArgumentException {
        if (portS < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SecurityClient, setPortServer(), the port-s parameter is <0");
        }
        this.setParameter("port-s", portS);
    }

    public void setPreference(float q) throws InvalidArgumentException {
        if (q < 0.0f) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SecurityClient, setPreference(), the preference (q) parameter is <0");
        }
        this.setParameter("q", q);
    }

    public String getSecurityMechanism() {
        return this.secMechanism;
    }

    public String getEncryptionAlgorithm() {
        return this.getParameter("ealg");
    }

    public String getAlgorithm() {
        return this.getParameter("alg");
    }

    public String getProtocol() {
        return this.getParameter("prot");
    }

    public String getMode() {
        return this.getParameter("mod");
    }

    public int getSPIClient() {
        return Integer.parseInt(this.getParameter("spi-c"));
    }

    public int getSPIServer() {
        return Integer.parseInt(this.getParameter("spi-s"));
    }

    public int getPortClient() {
        return Integer.parseInt(this.getParameter("port-c"));
    }

    public int getPortServer() {
        return Integer.parseInt(this.getParameter("port-s"));
    }

    public float getPreference() {
        return Float.parseFloat(this.getParameter("q"));
    }

    public boolean equals(Object other) {
        if (other instanceof SecurityAgreeHeader) {
            SecurityAgreeHeader o = (SecurityAgreeHeader)other;
            return this.getSecurityMechanism().equals(o.getSecurityMechanism()) && this.equalParameters((Parameters)o);
        }
        return false;
    }

    public Object clone() {
        SecurityAgree retval = (SecurityAgree)super.clone();
        if (this.secMechanism != null) {
            retval.secMechanism = this.secMechanism;
        }
        return retval;
    }
}

