/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header.ims;

import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.header.ExtensionHeader;
import com.coraltele.javax.sip.header.SIPHeader;
import com.coraltele.javax.sip.header.ims.PMediaAuthorizationHeader;
import com.coraltele.javax.sip.header.ims.SIPHeaderNamesIms;
import java.text.ParseException;

public class PMediaAuthorization
extends SIPHeader
implements PMediaAuthorizationHeader,
SIPHeaderNamesIms,
ExtensionHeader {
    private static final long serialVersionUID = -6463630258703731133L;
    private String token;

    public PMediaAuthorization() {
        super("P-Media-Authorization");
    }

    public String getToken() {
        return this.token;
    }

    public void setMediaAuthorizationToken(String token) throws InvalidArgumentException {
        if (token == null || token.length() == 0) {
            throw new InvalidArgumentException(" the Media-Authorization-Token parameter is null or empty");
        }
        this.token = token;
    }

    public StringBuilder encodeBody(StringBuilder encoding) {
        return encoding.append(this.token);
    }

    public void setValue(String value) throws ParseException {
        throw new ParseException(value, 0);
    }

    public boolean equals(Object other) {
        if (other instanceof PMediaAuthorizationHeader) {
            PMediaAuthorizationHeader o = (PMediaAuthorizationHeader)other;
            return this.getToken().equals(o.getToken());
        }
        return false;
    }

    public Object clone() {
        PMediaAuthorization retval = (PMediaAuthorization)super.clone();
        if (this.token != null) {
            retval.token = this.token;
        }
        return retval;
    }
}

