/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.header.WarningHeader;
import com.coraltele.javax.sip.header.SIPHeader;
import java.text.ParseException;

public class Warning
extends SIPHeader
implements WarningHeader {
    private static final long serialVersionUID = -3433328864230783899L;
    protected int code;
    protected String agent;
    protected String text;

    public Warning() {
        super("Warning");
    }

    public StringBuilder encodeBody(StringBuilder buffer) {
        return this.text != null ? buffer.append(Integer.toString(this.code)).append(" ").append(this.agent).append(" ").append("\"").append(this.text).append("\"") : buffer.append(Integer.toString(this.code)).append(" ").append(this.agent);
    }

    public int getCode() {
        return this.code;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getText() {
        return this.text;
    }

    public void setCode(int code) throws InvalidArgumentException {
        if (code <= 99 || code >= 1000) {
            throw new InvalidArgumentException("Code parameter in the Warning header is invalid: code=" + code);
        }
        this.code = code;
    }

    public void setAgent(String host) throws ParseException {
        if (host == null) {
            throw new NullPointerException("the host parameter in the Warning header is null");
        }
        this.agent = host;
    }

    public void setText(String text) throws ParseException {
        if (text == null) {
            throw new ParseException("The text parameter in the Warning header is null", 0);
        }
        this.text = text;
    }
}

