/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.header.TimeStampHeader;
import com.coraltele.javax.sip.header.SIPHeader;

public class TimeStamp
extends SIPHeader
implements TimeStampHeader {
    private static final long serialVersionUID = -3711322366481232720L;
    protected long timeStamp = -1L;
    protected int delay = -1;
    protected float delayFloat = -1.0f;
    private float timeStampFloat = -1.0f;

    public TimeStamp() {
        super("Timestamp");
    }

    private String getTimeStampAsString() {
        if (this.timeStamp == -1L && this.timeStampFloat == -1.0f) {
            return "";
        }
        if (this.timeStamp != -1L) {
            return Long.toString(this.timeStamp);
        }
        return Float.toString(this.timeStampFloat);
    }

    private String getDelayAsString() {
        if (this.delay == -1 && this.delayFloat == -1.0f) {
            return "";
        }
        if (this.delay != -1) {
            return Integer.toString(this.delay);
        }
        return Float.toString(this.delayFloat);
    }

    public StringBuilder encodeBody(StringBuilder retval) {
        String s1 = this.getTimeStampAsString();
        String s2 = this.getDelayAsString();
        if (s1.equals("") && s2.equals("")) {
            return retval.append("");
        }
        if (!s1.equals("")) {
            retval.append(s1);
        }
        if (!s2.equals("")) {
            retval.append(" ").append(s2);
        }
        return retval;
    }

    public boolean hasDelay() {
        return this.delay != -1;
    }

    public void removeDelay() {
        this.delay = -1;
    }

    public void setTimeStamp(float timeStamp) throws InvalidArgumentException {
        if (timeStamp < 0.0f) {
            throw new InvalidArgumentException("JAIN-SIP Exception, TimeStamp, setTimeStamp(), the timeStamp parameter is <0");
        }
        this.timeStamp = -1L;
        this.timeStampFloat = timeStamp;
    }

    public float getTimeStamp() {
        return this.timeStampFloat == -1.0f ? Float.valueOf(this.timeStamp).floatValue() : this.timeStampFloat;
    }

    public float getDelay() {
        return this.delayFloat == -1.0f ? Float.valueOf(this.delay).floatValue() : this.delayFloat;
    }

    public void setDelay(float delay) throws InvalidArgumentException {
        if (delay < 0.0f && delay != -1.0f) {
            throw new InvalidArgumentException("JAIN-SIP Exception, TimeStamp, setDelay(), the delay parameter is <0");
        }
        this.delayFloat = delay;
        this.delay = -1;
    }

    public long getTime() {
        return this.timeStamp == -1L ? (long)this.timeStampFloat : this.timeStamp;
    }

    public int getTimeDelay() {
        return this.delay == -1 ? (int)this.delayFloat : this.delay;
    }

    public void setTime(long timeStamp) throws InvalidArgumentException {
        if (timeStamp < -1L) {
            throw new InvalidArgumentException("Illegal timestamp");
        }
        this.timeStamp = timeStamp;
        this.timeStampFloat = -1.0f;
    }

    public void setTimeDelay(int delay) throws InvalidArgumentException {
        if (delay < -1) {
            throw new InvalidArgumentException("Value out of range " + delay);
        }
        this.delay = delay;
        this.delayFloat = -1.0f;
    }
}

