/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.core.GenericObject;
import com.coraltele.core.GenericObjectList;
import com.coraltele.core.InternalErrorHandler;
import java.lang.reflect.Field;

public abstract class SIPObject
extends GenericObject {
    protected SIPObject() {
    }

    public void dbgPrint() {
        super.dbgPrint();
    }

    public abstract String encode();

    public StringBuilder encode(StringBuilder buffer) {
        return buffer.append(this.encode());
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        SIPObject that = (SIPObject)other;
        Class<?> myclass = this.getClass();
        Class<?> hisclass = other.getClass();
        while (true) {
            Field[] fields = myclass.getDeclaredFields();
            if (!hisclass.equals(myclass)) {
                return false;
            }
            Field[] hisfields = hisclass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                Field g = hisfields[i];
                int modifier = f.getModifiers();
                if ((modifier & 2) == 2) continue;
                Class<?> fieldType = f.getType();
                String fieldName = f.getName();
                if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
                try {
                    if (fieldType.isPrimitive()) {
                        String fname = fieldType.toString();
                        if (!(fname.compareTo("int") == 0 ? f.getInt(this) != g.getInt(that) : (fname.compareTo("short") == 0 ? f.getShort(this) != g.getShort(that) : (fname.compareTo("char") == 0 ? f.getChar(this) != g.getChar(that) : (fname.compareTo("long") == 0 ? f.getLong(this) != g.getLong(that) : (fname.compareTo("boolean") == 0 ? f.getBoolean(this) != g.getBoolean(that) : (fname.compareTo("double") == 0 ? f.getDouble(this) != g.getDouble(that) : fname.compareTo("float") == 0 && f.getFloat(this) != g.getFloat(that)))))))) continue;
                        return false;
                    }
                    if (g.get(that) == f.get(this)) continue;
                    if (f.get(this) == null && g.get(that) != null) {
                        return false;
                    }
                    if (g.get(that) == null && f.get(this) != null) {
                        return false;
                    }
                    if (f.get(this).equals(g.get(that))) continue;
                    return false;
                }
                catch (IllegalAccessException ex1) {
                    System.out.println("accessed field " + fieldName);
                    System.out.println("modifier  " + modifier);
                    System.out.println("modifier.private  2");
                    InternalErrorHandler.handleException((Exception)ex1);
                }
            }
            if (myclass.equals(SIPObject.class)) break;
            myclass = myclass.getSuperclass();
            hisclass = hisclass.getSuperclass();
        }
        return true;
    }

    public boolean match(Object other) {
        if (other == null) {
            return true;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        GenericObject that = (GenericObject)other;
        Class<?> myclass = this.getClass();
        Class<?> hisclass = other.getClass();
        while (true) {
            Field[] fields = myclass.getDeclaredFields();
            Field[] hisfields = hisclass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                Field g = hisfields[i];
                int modifier = f.getModifiers();
                if ((modifier & 2) == 2) continue;
                Class<?> fieldType = f.getType();
                String fieldName = f.getName();
                if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
                try {
                    if (fieldType.isPrimitive()) {
                        String fname = fieldType.toString();
                        if (fname.compareTo("int") == 0) {
                            if (f.getInt(this) == g.getInt(that)) continue;
                            return false;
                        }
                        if (fname.compareTo("short") == 0) {
                            if (f.getShort(this) == g.getShort(that)) continue;
                            return false;
                        }
                        if (fname.compareTo("char") == 0) {
                            if (f.getChar(this) == g.getChar(that)) continue;
                            return false;
                        }
                        if (fname.compareTo("long") == 0) {
                            if (f.getLong(this) == g.getLong(that)) continue;
                            return false;
                        }
                        if (fname.compareTo("boolean") == 0) {
                            if (f.getBoolean(this) == g.getBoolean(that)) continue;
                            return false;
                        }
                        if (fname.compareTo("double") == 0) {
                            if (f.getDouble(this) == g.getDouble(that)) continue;
                            return false;
                        }
                        if (fname.compareTo("float") == 0) {
                            if (f.getFloat(this) == g.getFloat(that)) continue;
                            return false;
                        }
                        InternalErrorHandler.handleException((String)"unknown type");
                        continue;
                    }
                    Object myObj = f.get(this);
                    Object hisObj = g.get(that);
                    if (hisObj != null && myObj == null) {
                        return false;
                    }
                    if (hisObj == null && myObj != null || hisObj == null && myObj == null) continue;
                    if (hisObj instanceof String && myObj instanceof String) {
                        if (((String)hisObj).trim().equals("") || ((String)myObj).compareToIgnoreCase((String)hisObj) == 0) continue;
                        return false;
                    }
                    if (hisObj != null && GenericObject.isMySubclass(myObj.getClass()) && GenericObject.isMySubclass(hisObj.getClass()) && myObj.getClass().equals(hisObj.getClass()) && ((GenericObject)hisObj).getMatcher() != null) {
                        String myObjEncoded = ((GenericObject)myObj).encode();
                        boolean retval = ((GenericObject)hisObj).getMatcher().match(myObjEncoded);
                        if (retval) continue;
                        return false;
                    }
                    if (GenericObject.isMySubclass(myObj.getClass()) && !((GenericObject)myObj).match(hisObj)) {
                        return false;
                    }
                    if (!GenericObjectList.isMySubclass(myObj.getClass()) || ((GenericObjectList)myObj).match(hisObj)) continue;
                    return false;
                }
                catch (IllegalAccessException ex1) {
                    InternalErrorHandler.handleException((Exception)ex1);
                }
            }
            if (myclass.equals(SIPObject.class)) break;
            myclass = myclass.getSuperclass();
            hisclass = hisclass.getSuperclass();
        }
        return true;
    }

    public String debugDump() {
        this.stringRepresentation = "";
        Class<?> myclass = this.getClass();
        this.sprint(myclass.getName());
        this.sprint("{");
        Field[] fields = myclass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int modifier = f.getModifiers();
            if ((modifier & 2) == 2) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
            this.sprint(fieldName + ":");
            try {
                if (fieldType.isPrimitive()) {
                    String fname = fieldType.toString();
                    this.sprint(fname + ":");
                    if (fname.compareTo("int") == 0) {
                        int intfield = f.getInt(this);
                        this.sprint(intfield);
                        continue;
                    }
                    if (fname.compareTo("short") == 0) {
                        short shortField = f.getShort(this);
                        this.sprint(shortField);
                        continue;
                    }
                    if (fname.compareTo("char") == 0) {
                        char charField = f.getChar(this);
                        this.sprint(charField);
                        continue;
                    }
                    if (fname.compareTo("long") == 0) {
                        long longField = f.getLong(this);
                        this.sprint(longField);
                        continue;
                    }
                    if (fname.compareTo("boolean") == 0) {
                        boolean booleanField = f.getBoolean(this);
                        this.sprint(booleanField);
                        continue;
                    }
                    if (fname.compareTo("double") == 0) {
                        double doubleField = f.getDouble(this);
                        this.sprint(doubleField);
                        continue;
                    }
                    if (fname.compareTo("float") != 0) continue;
                    float floatField = f.getFloat(this);
                    this.sprint(floatField);
                    continue;
                }
                if (GenericObject.class.isAssignableFrom(fieldType)) {
                    if (f.get(this) != null) {
                        this.sprint(((GenericObject)f.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (GenericObjectList.class.isAssignableFrom(fieldType)) {
                    if (f.get(this) != null) {
                        this.sprint(((GenericObjectList)f.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (f.get(this) != null) {
                    this.sprint(f.get(this).getClass().getName() + ":");
                } else {
                    this.sprint(fieldType.getName() + ":");
                }
                this.sprint("{");
                if (f.get(this) != null) {
                    this.sprint(f.get(this).toString());
                } else {
                    this.sprint("<null>");
                }
                this.sprint("}");
                continue;
            }
            catch (IllegalAccessException ex1) {
                // empty catch block
            }
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    public String debugDump(int indent) {
        int save = this.indentation;
        this.indentation = indent;
        String retval = this.debugDump();
        this.indentation = save;
        return retval;
    }

    public String toString() {
        return this.encode();
    }
}

