/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.core.GenericObject;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.javax.sip.header.ExtensionHeaderList;
import com.coraltele.javax.sip.header.Indentation;
import com.coraltele.javax.sip.header.SIPHeader;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class SIPHeaderList<HDR extends SIPHeader>
extends SIPHeader
implements List<HDR>,
Header {
    private static boolean prettyEncode = true;
    protected List<HDR> hlist = new LinkedList();
    private Class<HDR> myClass;

    public String getName() {
        return this.headerName;
    }

    private SIPHeaderList() {
    }

    protected SIPHeaderList(Class<HDR> objclass, String hname) {
        this();
        this.headerName = hname;
        this.myClass = objclass;
    }

    @Override
    public boolean add(HDR objectToAdd) {
        this.hlist.add(objectToAdd);
        return true;
    }

    @Override
    public void addFirst(HDR obj) {
        this.hlist.add(0, obj);
    }

    public void add(HDR sipheader, boolean top) {
        if (top) {
            this.addFirst(sipheader);
        } else {
            this.add(sipheader);
        }
    }

    public void concatenate(SIPHeaderList<HDR> other, boolean topFlag) throws IllegalArgumentException {
        if (!topFlag) {
            this.addAll(other);
        } else {
            this.addAll(0, other);
        }
    }

    public String encode() {
        return this.encode(new StringBuilder()).toString();
    }

    public StringBuilder encode(StringBuilder buffer) {
        if (this.hlist.isEmpty()) {
            buffer.append(this.headerName).append(':').append("\r\n");
        } else if (this.headerName.equals("WWW-Authenticate") || this.headerName.equals("Proxy-Authenticate") || this.headerName.equals("Authorization") || this.headerName.equals("Proxy-Authorization") || prettyEncode && (this.headerName.equals("Via") || this.headerName.equals("Route") || this.headerName.equals("Record-Route")) || this.getClass().equals(ExtensionHeaderList.class)) {
            ListIterator li = this.hlist.listIterator();
            while (li.hasNext()) {
                SIPHeader sipheader = (SIPHeader)li.next();
                sipheader.encode(buffer);
            }
        } else {
            buffer.append(this.headerName).append(":").append(" ");
            this.encodeBody(buffer);
            buffer.append("\r\n");
        }
        return buffer;
    }

    public List<String> getHeadersAsEncodedStrings() {
        LinkedList<String> retval = new LinkedList<String>();
        ListIterator li = this.hlist.listIterator();
        while (li.hasNext()) {
            Header sipheader = (Header)li.next();
            retval.add(sipheader.toString());
        }
        return retval;
    }

    @Override
    public Header getFirst() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (Header)this.hlist.get(0);
    }

    @Override
    public Header getLast() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (Header)this.hlist.get(this.hlist.size() - 1);
    }

    public Class<HDR> getMyClass() {
        return this.myClass;
    }

    @Override
    public boolean isEmpty() {
        return this.hlist.isEmpty();
    }

    @Override
    public ListIterator<HDR> listIterator() {
        return this.hlist.listIterator(0);
    }

    public List<HDR> getHeaderList() {
        return this.hlist;
    }

    @Override
    public ListIterator<HDR> listIterator(int position) {
        return this.hlist.listIterator(position);
    }

    @Override
    public void removeFirst() {
        if (this.hlist.size() != 0) {
            this.hlist.remove(0);
        }
    }

    @Override
    public void removeLast() {
        if (this.hlist.size() != 0) {
            this.hlist.remove(this.hlist.size() - 1);
        }
    }

    @Override
    public boolean remove(HDR obj) {
        if (this.hlist.size() == 0) {
            return false;
        }
        return this.hlist.remove(obj);
    }

    protected void setMyClass(Class<HDR> cl) {
        this.myClass = cl;
    }

    public String debugDump(int indentation) {
        this.stringRepresentation = "";
        String indent = new Indentation(indentation).getIndentation();
        String className = this.getClass().getName();
        this.sprint(indent + className);
        this.sprint(indent + "{");
        for (SIPHeader sipHeader : this.hlist) {
            this.sprint(indent + sipHeader.debugDump());
        }
        this.sprint(indent + "}");
        return this.stringRepresentation;
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    @Override
    public Object[] toArray() {
        return this.hlist.toArray();
    }

    public int indexOf(GenericObject gobj) {
        return this.hlist.indexOf(gobj);
    }

    @Override
    public void add(int index, HDR sipHeader) throws IndexOutOfBoundsException {
        this.hlist.add(index, sipHeader);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SIPHeaderList) {
            SIPHeaderList that = (SIPHeaderList)other;
            if (this.hlist == that.hlist) {
                return true;
            }
            if (this.hlist == null) {
                return that.hlist == null || that.hlist.size() == 0;
            }
            return this.hlist.equals(that.hlist);
        }
        return false;
    }

    public boolean match(SIPHeaderList<?> template) {
        if (template == null) {
            return true;
        }
        if (!this.getClass().equals(template.getClass())) {
            return false;
        }
        SIPHeaderList<?> that = template;
        if (this.hlist == that.hlist) {
            return true;
        }
        if (this.hlist == null) {
            return false;
        }
        for (SIPHeader sipHeader : that.hlist) {
            boolean found = false;
            Iterator it1 = this.hlist.iterator();
            while (it1.hasNext() && !found) {
                SIPHeader sipHeader1 = (SIPHeader)it1.next();
                found = sipHeader1.match((Object)sipHeader);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            Class<?> clazz = this.getClass();
            Constructor<?> cons = clazz.getConstructor(null);
            SIPHeaderList retval = (SIPHeaderList)cons.newInstance(null);
            retval.headerName = this.headerName;
            retval.myClass = this.myClass;
            return retval.clonehlist(this.hlist);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not clone!", ex);
        }
    }

    protected final SIPHeaderList<HDR> clonehlist(List<HDR> hlistToClone) {
        if (hlistToClone != null) {
            for (Header h : hlistToClone) {
                this.hlist.add((SIPHeader)h.clone());
            }
        }
        return this;
    }

    @Override
    public int size() {
        return this.hlist.size();
    }

    public boolean isHeaderList() {
        return true;
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    protected StringBuilder encodeBody(StringBuilder buffer) {
        ListIterator iterator = this.listIterator();
        while (true) {
            SIPHeader sipHeader;
            if ((sipHeader = (SIPHeader)iterator.next()) == this) {
                throw new RuntimeException("Unexpected circularity in SipHeaderList");
            }
            sipHeader.encodeBody(buffer);
            if (!iterator.hasNext()) break;
            if (!this.headerName.equals("Privacy")) {
                buffer.append(",");
                continue;
            }
            buffer.append(";");
        }
        return buffer;
    }

    @Override
    public boolean addAll(Collection<? extends HDR> collection) {
        return this.hlist.addAll(collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends HDR> collection) {
        return this.hlist.addAll(index, collection);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.hlist.containsAll(collection);
    }

    @Override
    public void clear() {
        this.hlist.clear();
    }

    @Override
    public boolean contains(Object header) {
        return this.hlist.contains(header);
    }

    @Override
    public HDR get(int index) {
        return (HDR)((SIPHeader)this.hlist.get(index));
    }

    @Override
    public int indexOf(Object obj) {
        return this.hlist.indexOf(obj);
    }

    @Override
    public Iterator<HDR> iterator() {
        return this.hlist.listIterator();
    }

    @Override
    public int lastIndexOf(Object obj) {
        return this.hlist.lastIndexOf(obj);
    }

    @Override
    public boolean remove(Object obj) {
        return this.hlist.remove(obj);
    }

    @Override
    public HDR remove(int index) {
        return (HDR)((SIPHeader)this.hlist.remove(index));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.hlist.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.hlist.retainAll(collection);
    }

    @Override
    public List<HDR> subList(int index1, int index2) {
        return this.hlist.subList(index1, index2);
    }

    @Override
    public int hashCode() {
        return this.headerName.hashCode();
    }

    @Override
    public HDR set(int position, HDR sipHeader) {
        return (HDR)((SIPHeader)this.hlist.set(position, sipHeader));
    }

    public static void setPrettyEncode(boolean flag) {
        prettyEncode = flag;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.hlist.toArray(array);
    }
}

