/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.core.HostPort;
import com.coraltele.interfaces.sip.header.ReplyToHeader;
import com.coraltele.javax.sip.address.AddressImpl;
import com.coraltele.javax.sip.header.AddressParametersHeader;

public final class ReplyTo
extends AddressParametersHeader
implements ReplyToHeader {
    private static final long serialVersionUID = -9103698729465531373L;

    public ReplyTo() {
        super("Reply-To");
    }

    public ReplyTo(AddressImpl address) {
        super("Reply-To");
        this.address = address;
    }

    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody(new StringBuilder()).toString() + "\r\n";
    }

    public StringBuilder encodeBody(StringBuilder retval) {
        if (this.address.getAddressType() == 2) {
            retval.append("<");
        }
        this.address.encode(retval);
        if (this.address.getAddressType() == 2) {
            retval.append(">");
        }
        if (!this.parameters.isEmpty()) {
            retval.append(";");
            this.parameters.encode(retval);
        }
        return retval;
    }

    public HostPort getHostPort() {
        return this.address.getHostPort();
    }

    public String getDisplayName() {
        return this.address.getDisplayName();
    }
}

