/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.header.ReasonHeader;
import com.coraltele.javax.sip.Utils;
import com.coraltele.javax.sip.header.ParametersHeader;
import java.text.ParseException;

public class Reason
extends ParametersHeader
implements ReasonHeader {
    private static final long serialVersionUID = -8903376965568297388L;
    public final String TEXT = "text";
    public final String CAUSE = "cause";
    protected String protocol;

    public int getCause() {
        return this.getParameterAsInt("cause");
    }

    public void setCause(int cause) throws InvalidArgumentException {
        this.parameters.set("cause", (Object)cause);
    }

    public void setProtocol(String protocol) throws ParseException {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setText(String text) throws ParseException {
        if (text.charAt(0) != '\"') {
            text = Utils.getQuotedString((String)text);
        }
        this.parameters.set("text", (Object)text);
    }

    public String getText() {
        return this.parameters.getParameter("text");
    }

    public Reason() {
        super("Reason");
    }

    public String getName() {
        return "Reason";
    }

    public StringBuilder encodeBody(StringBuilder buffer) {
        buffer.append(this.protocol);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            buffer = buffer.append(";");
            buffer = this.parameters.encode(buffer);
        }
        return buffer;
    }
}

