/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.header.RAckHeader;
import com.coraltele.javax.sip.header.SIPHeader;
import java.text.ParseException;

public class RAck
extends SIPHeader
implements RAckHeader {
    private static final long serialVersionUID = 743999286077404118L;
    protected long cSeqNumber;
    protected long rSeqNumber;
    protected String method;

    public RAck() {
        super("RAck");
    }

    public StringBuilder encodeBody(StringBuilder buffer) {
        return buffer.append(this.rSeqNumber).append(" ").append(this.cSeqNumber).append(" ").append(this.method);
    }

    public int getCSeqNumber() {
        return (int)this.cSeqNumber;
    }

    public long getCSeqNumberLong() {
        return this.cSeqNumber;
    }

    public String getMethod() {
        return this.method;
    }

    public int getRSeqNumber() {
        return (int)this.rSeqNumber;
    }

    public void setCSeqNumber(int cSeqNumber) throws InvalidArgumentException {
        this.setCSequenceNumber((long)cSeqNumber);
    }

    public void setMethod(String method) throws ParseException {
        this.method = method;
    }

    public long getCSequenceNumber() {
        return this.cSeqNumber;
    }

    public long getRSequenceNumber() {
        return this.rSeqNumber;
    }

    public void setCSequenceNumber(long cSeqNumber) throws InvalidArgumentException {
        if (cSeqNumber <= 0L || cSeqNumber > 0x80000000L) {
            throw new InvalidArgumentException("Bad CSeq # " + cSeqNumber);
        }
        this.cSeqNumber = cSeqNumber;
    }

    public void setRSeqNumber(int rSeqNumber) throws InvalidArgumentException {
        this.setRSequenceNumber((long)rSeqNumber);
    }

    public void setRSequenceNumber(long rSeqNumber) throws InvalidArgumentException {
        if (rSeqNumber <= 0L || this.cSeqNumber > 0x80000000L) {
            throw new InvalidArgumentException("Bad rSeq # " + rSeqNumber);
        }
        this.rSeqNumber = rSeqNumber;
    }
}

