/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.core.HostPort;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.javax.sip.address.AddressImpl;
import com.coraltele.javax.sip.header.AddressParametersHeader;
import com.coraltele.javax.sip.header.To;
import com.coraltele.javax.sip.parser.Parser;
import java.text.ParseException;

public final class From
extends AddressParametersHeader
implements FromHeader {
    private static final long serialVersionUID = -6312727234330643892L;

    public From() {
        super("From");
    }

    public From(To to) {
        super("From");
        this.address = to.address;
        this.parameters = to.parameters;
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    protected StringBuilder encodeBody(StringBuilder buffer) {
        if (this.address.getAddressType() == 2) {
            buffer.append("<");
        }
        this.address.encode(buffer);
        if (this.address.getAddressType() == 2) {
            buffer.append(">");
        }
        if (!this.parameters.isEmpty()) {
            buffer.append(";");
            this.parameters.encode(buffer);
        }
        return buffer;
    }

    public HostPort getHostPort() {
        return this.address.getHostPort();
    }

    public String getDisplayName() {
        return this.address.getDisplayName();
    }

    public String getTag() {
        if (this.parameters == null) {
            return null;
        }
        return this.getParameter("tag");
    }

    public boolean hasTag() {
        return this.hasParameter("tag");
    }

    public void removeTag() {
        this.parameters.delete("tag");
    }

    public void setAddress(Address address) {
        this.address = (AddressImpl)address;
    }

    public void setTag(String t) throws ParseException {
        Parser.checkToken((String)t);
        this.setParameter("tag", t);
    }

    public String getUserAtHostPort() {
        return this.address.getUserAtHostPort();
    }

    public boolean equals(Object other) {
        return other instanceof FromHeader && super.equals(other);
    }
}

