/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.interfaces.sip.header.ExtensionHeader;
import com.coraltele.javax.sip.header.SIPHeader;

public class ExtensionHeaderImpl
extends SIPHeader
implements ExtensionHeader {
    private static final long serialVersionUID = -8693922839612081849L;
    protected String value;

    public ExtensionHeaderImpl() {
    }

    public ExtensionHeaderImpl(String headerName) {
        super(headerName);
    }

    public void setName(String headerName) {
        this.headerName = headerName;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getHeaderValue() {
        if (this.value != null) {
            return this.value;
        }
        String encodedHdr = null;
        try {
            encodedHdr = this.encode();
        }
        catch (Exception ex) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(encodedHdr);
        while (buffer.length() > 0 && buffer.charAt(0) != ':') {
            buffer.deleteCharAt(0);
        }
        buffer.deleteCharAt(0);
        this.value = buffer.toString().trim();
        return this.value;
    }

    public String encode() {
        return new StringBuffer(this.headerName).append(":").append(" ").append(this.value).append("\r\n").toString();
    }

    public StringBuilder encodeBody(StringBuilder buffer) {
        return buffer.append(this.encodeBody());
    }

    public String encodeBody() {
        return this.getHeaderValue();
    }
}

