/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.javax.sip.header.SIPHeader;
import com.coraltele.javax.sip.message.SIPRequest;
import java.text.ParseException;

public class CSeq
extends SIPHeader
implements CSeqHeader {
    private static final long serialVersionUID = -5405798080040422910L;
    protected Long seqno;
    protected String method;

    public CSeq() {
        super("CSeq");
    }

    public CSeq(long seqno, String method) {
        this();
        this.seqno = seqno;
        this.method = SIPRequest.getCannonicalName((String)method);
    }

    public boolean equals(Object other) {
        if (other instanceof CSeqHeader) {
            CSeqHeader o = (CSeqHeader)other;
            return this.getSeqNumber() == o.getSeqNumber() && this.getMethod().equals(o.getMethod());
        }
        return false;
    }

    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    public String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    protected StringBuilder encodeBody(StringBuilder buffer) {
        return buffer.append(this.seqno).append(" ").append(this.method.toUpperCase());
    }

    public String getMethod() {
        return this.method;
    }

    public void setSeqNumber(long sequenceNumber) throws InvalidArgumentException {
        if (sequenceNumber < 0L) {
            throw new InvalidArgumentException("JAIN-SIP Exception, CSeq, setSequenceNumber(), the sequence number parameter is < 0 : " + sequenceNumber);
        }
        if (sequenceNumber > 0x80000000L) {
            throw new InvalidArgumentException("JAIN-SIP Exception, CSeq, setSequenceNumber(), the sequence number parameter is too large : " + sequenceNumber);
        }
        this.seqno = sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) throws InvalidArgumentException {
        this.setSeqNumber((long)sequenceNumber);
    }

    public void setMethod(String meth) throws ParseException {
        if (meth == null) {
            throw new NullPointerException("JAIN-SIP Exception, CSeq, setMethod(), the meth parameter is null");
        }
        this.method = SIPRequest.getCannonicalName((String)meth);
    }

    public int getSequenceNumber() {
        if (this.seqno == null) {
            return 0;
        }
        return this.seqno.intValue();
    }

    public long getSeqNumber() {
        return this.seqno;
    }
}

