/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.AlertInfoHeader;
import com.coraltele.javax.sip.address.GenericURI;
import com.coraltele.javax.sip.header.ParametersHeader;
import java.text.ParseException;

public final class AlertInfo
extends ParametersHeader
implements AlertInfoHeader {
    private static final long serialVersionUID = 4159657362051508719L;
    protected GenericURI uri;
    protected String string;

    public AlertInfo() {
        super("Alert-Info");
    }

    protected StringBuilder encodeBody(StringBuilder encoding) {
        if (this.uri != null) {
            encoding.append("<").append(this.uri.encode()).append(">");
        } else if (this.string != null) {
            encoding.append(this.string);
        }
        if (!this.parameters.isEmpty()) {
            encoding.append(";").append(this.parameters.encode());
        }
        return encoding;
    }

    public void setAlertInfo(URI uri) {
        this.uri = (GenericURI)uri;
    }

    public void setAlertInfo(String string) {
        this.string = string;
    }

    public URI getAlertInfo() {
        GenericURI alertInfoUri = null;
        if (this.uri != null) {
            alertInfoUri = this.uri;
        } else {
            try {
                alertInfoUri = new GenericURI(this.string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return alertInfoUri;
    }

    public Object clone() {
        AlertInfo retval = (AlertInfo)super.clone();
        if (this.uri != null) {
            retval.uri = (GenericURI)this.uri.clone();
        } else if (this.string != null) {
            retval.string = this.string;
        }
        return retval;
    }
}

