/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.core.NameValue;
import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.header.AcceptLanguageHeader;
import com.coraltele.javax.sip.header.ParametersHeader;
import java.util.Locale;

public final class AcceptLanguage
extends ParametersHeader
implements AcceptLanguageHeader {
    private static final long serialVersionUID = -4473982069737324919L;
    protected String languageRange;

    public AcceptLanguage() {
        super("Accept-Language");
    }

    protected StringBuilder encodeBody(StringBuilder encoding) {
        if (this.languageRange != null) {
            encoding.append(this.languageRange);
        }
        if (!this.parameters.isEmpty()) {
            encoding.append(";").append(this.parameters.encode());
        }
        return encoding;
    }

    public String getLanguageRange() {
        return this.languageRange;
    }

    public float getQValue() {
        if (!this.hasParameter("q")) {
            return -1.0f;
        }
        return ((Float)this.parameters.getValue("q")).floatValue();
    }

    public boolean hasQValue() {
        return this.hasParameter("q");
    }

    public void removeQValue() {
        this.removeParameter("q");
    }

    public void setLanguageRange(String languageRange) {
        this.languageRange = languageRange.trim();
    }

    public void setQValue(float q) throws InvalidArgumentException {
        if ((double)q < 0.0 || (double)q > 1.0) {
            throw new InvalidArgumentException("qvalue out of range!");
        }
        if (q == -1.0f) {
            this.removeParameter("q");
        } else {
            this.setParameter(new NameValue("q", (Object)Float.valueOf(q)));
        }
    }

    public Locale getAcceptLanguage() {
        if (this.languageRange == null) {
            return null;
        }
        int dash = this.languageRange.indexOf(45);
        if (dash >= 0) {
            return new Locale(this.languageRange.substring(0, dash), this.languageRange.substring(dash + 1));
        }
        return new Locale(this.languageRange);
    }

    public void setAcceptLanguage(Locale language) {
        this.languageRange = "".equals(language.getCountry()) ? language.getLanguage() : language.getLanguage() + '-' + language.getCountry();
    }
}

