/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.header;

import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.header.AcceptEncodingHeader;
import com.coraltele.javax.sip.header.ParametersHeader;
import java.text.ParseException;

public final class AcceptEncoding
extends ParametersHeader
implements AcceptEncodingHeader {
    private static final long serialVersionUID = -1476807565552873525L;
    protected String contentCoding;

    public AcceptEncoding() {
        super("Accept-Encoding");
    }

    protected String encodeBody() {
        return this.encode(new StringBuilder()).toString();
    }

    protected StringBuilder encodeBody(StringBuilder buffer) {
        if (this.contentCoding != null) {
            buffer.append(this.contentCoding);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            buffer.append(";").append(this.parameters.encode());
        }
        return buffer;
    }

    public float getQValue() {
        return this.getParameterAsFloat("q");
    }

    public String getEncoding() {
        return this.contentCoding;
    }

    public void setQValue(float q) throws InvalidArgumentException {
        if ((double)q < 0.0 || (double)q > 1.0) {
            throw new InvalidArgumentException("qvalue out of range!");
        }
        super.setParameter("q", q);
    }

    public void setEncoding(String encoding) throws ParseException {
        if (encoding == null) {
            throw new NullPointerException(" encoding parameter is null");
        }
        this.contentCoding = encoding;
    }
}

