/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.clientauthutils;

import com.coraltele.core.StackLogger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/*
 * Exception performing whole class analysis ignored.
 */
public class MessageDigestAlgorithm {
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static String calculateResponse(String algorithm, String hashUserNameRealmPasswd, String nonce_value, String nc_value, String cnonce_value, String method, String digest_uri_value, String entity_body, String qop_value, StackLogger stackLogger) {
        if (stackLogger.isLoggingEnabled(32)) {
            stackLogger.logDebug("trying to authenticate using : " + algorithm + ", " + hashUserNameRealmPasswd + ", " + nonce_value + ", " + nc_value + ", " + cnonce_value + ", " + method + ", " + digest_uri_value + ", " + entity_body + ", " + qop_value);
        }
        if (hashUserNameRealmPasswd == null || method == null || digest_uri_value == null || nonce_value == null) {
            throw new NullPointerException("Null parameter to MessageDigestAlgorithm.calculateResponse()");
        }
        if (cnonce_value == null || cnonce_value.length() == 0) {
            throw new NullPointerException("cnonce_value may not be absent for MD5-Sess algorithm.");
        }
        String A2 = null;
        if (qop_value == null || qop_value.trim().length() == 0 || qop_value.trim().equalsIgnoreCase("auth")) {
            A2 = method + ":" + digest_uri_value;
        } else {
            if (entity_body == null) {
                entity_body = "";
            }
            A2 = method + ":" + digest_uri_value + ":" + MessageDigestAlgorithm.H((String)entity_body);
        }
        String request_digest = null;
        request_digest = cnonce_value != null && qop_value != null && nc_value != null && (qop_value.equalsIgnoreCase("auth") || qop_value.equalsIgnoreCase("auth-int")) ? MessageDigestAlgorithm.KD((String)hashUserNameRealmPasswd, (String)(nonce_value + ":" + nc_value + ":" + cnonce_value + ":" + qop_value + ":" + MessageDigestAlgorithm.H((String)A2))) : MessageDigestAlgorithm.KD((String)hashUserNameRealmPasswd, (String)(nonce_value + ":" + MessageDigestAlgorithm.H((String)A2)));
        return request_digest;
    }

    public static String calculateResponse(String algorithm, String username_value, String realm_value, String passwd, String nonce_value, String nc_value, String cnonce_value, String method, String digest_uri_value, String entity_body, String qop_value) {
        if (username_value == null || realm_value == null || passwd == null || method == null || digest_uri_value == null || nonce_value == null) {
            throw new NullPointerException("Null parameter to MessageDigestAlgorithm.calculateResponse()");
        }
        String A1 = null;
        if (algorithm == null || algorithm.trim().length() == 0 || algorithm.trim().equalsIgnoreCase("MD5")) {
            A1 = username_value + ":" + realm_value + ":" + passwd;
        } else {
            if (cnonce_value == null || cnonce_value.length() == 0) {
                throw new NullPointerException("cnonce_value may not be absent for MD5-Sess algorithm.");
            }
            A1 = MessageDigestAlgorithm.H((String)(username_value + ":" + realm_value + ":" + passwd)) + ":" + nonce_value + ":" + cnonce_value;
        }
        String A2 = null;
        if (qop_value == null || qop_value.trim().length() == 0 || qop_value.trim().equalsIgnoreCase("auth")) {
            A2 = method + ":" + digest_uri_value;
        } else {
            if (entity_body == null) {
                entity_body = "";
            }
            A2 = method + ":" + digest_uri_value + ":" + MessageDigestAlgorithm.H((String)entity_body);
        }
        String request_digest = null;
        if (cnonce_value == null || qop_value == null || nc_value == null || !qop_value.equalsIgnoreCase("auth") && !qop_value.equalsIgnoreCase("auth-int")) {
            request_digest = MessageDigestAlgorithm.KD((String)MessageDigestAlgorithm.H((String)A1), (String)(nonce_value + ":" + MessageDigestAlgorithm.H((String)A2)));
        }
        return request_digest;
    }

    private static String H(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            return MessageDigestAlgorithm.toHexString((byte[])digest.digest(data.getBytes()));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Failed to instantiate an MD5 algorithm", ex);
        }
    }

    private static String KD(String secret, String data) {
        return MessageDigestAlgorithm.H((String)(secret + ":" + data));
    }

    private static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }
}

