/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.clientauthutils;

import com.coraltele.interfaces.sip.header.AuthorizationHeader;
import com.coraltele.javax.sip.clientauthutils.CredentialsCache;
import com.coraltele.javax.sip.stack.SIPStackTimerTask;
import com.coraltele.javax.sip.stack.timers.SipTimer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;

class CredentialsCache {
    private ConcurrentHashMap<String, List<AuthorizationHeader>> authorizationHeaders = new ConcurrentHashMap();
    private SipTimer timer;

    CredentialsCache(SipTimer timer) {
        this.timer = timer;
    }

    void cacheAuthorizationHeader(String callId, AuthorizationHeader authorization, int cacheTime) {
        String user = authorization.getUsername();
        if (callId == null) {
            throw new NullPointerException("Call ID is null!");
        }
        if (authorization == null) {
            throw new NullPointerException("Null authorization domain");
        }
        LinkedList<AuthorizationHeader> authHeaders = (LinkedList<AuthorizationHeader>)this.authorizationHeaders.get(callId);
        if (authHeaders == null) {
            authHeaders = new LinkedList<AuthorizationHeader>();
            this.authorizationHeaders.put(callId, authHeaders);
        } else {
            String realm = authorization.getRealm();
            ListIterator li = authHeaders.listIterator();
            while (li.hasNext()) {
                AuthorizationHeader authHeader = (AuthorizationHeader)li.next();
                if (!realm.equals(authHeader.getRealm())) continue;
                li.remove();
            }
        }
        authHeaders.add(authorization);
        TimeoutTask timeoutTask = new TimeoutTask(this, callId, user);
        if (cacheTime != -1) {
            this.timer.schedule((SIPStackTimerTask)timeoutTask, (long)(cacheTime * 1000));
        }
    }

    Collection<AuthorizationHeader> getCachedAuthorizationHeaders(String callid) {
        if (callid == null) {
            throw new NullPointerException("Null arg!");
        }
        return (Collection)this.authorizationHeaders.get(callid);
    }

    public void removeAuthenticationHeader(String callId) {
        this.authorizationHeaders.remove(callId);
    }

    static /* synthetic */ ConcurrentHashMap access$000(CredentialsCache x0) {
        return x0.authorizationHeaders;
    }
}

